/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.layout;

import com.trollworks.ttk.layout.Alignment;
import com.trollworks.ttk.layout.FlexLayout;
import com.trollworks.ttk.layout.LayoutSize;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;

public abstract class FlexCell {
    private Alignment mHorizontalAlignment = Alignment.LEFT_TOP;
    private Alignment mVerticalAlignment = Alignment.CENTER;
    private Insets mInsets = new Insets(0, 0, 0, 0);
    private int mX;
    private int mY;
    private int mWidth;
    private int mHeight;

    public void apply(Container container) {
        container.setLayout(new FlexLayout(this));
    }

    public void draw(Graphics graphics, Color color) {
        graphics.setColor(color);
        graphics.drawRect(this.mX, this.mY, this.mWidth, this.mHeight);
    }

    public final void layout(Rectangle rectangle) {
        rectangle.x += this.mInsets.left;
        rectangle.y += this.mInsets.top;
        rectangle.width -= this.mInsets.left + this.mInsets.right;
        rectangle.height -= this.mInsets.top + this.mInsets.bottom;
        this.mX = rectangle.x;
        this.mY = rectangle.y;
        this.mWidth = rectangle.width;
        this.mHeight = rectangle.height;
        this.layoutSelf(rectangle);
    }

    protected abstract void layoutSelf(Rectangle var1);

    public final Dimension getSize(LayoutSize layoutSize) {
        Dimension dimension = this.getSizeSelf(layoutSize);
        dimension.width += this.mInsets.left + this.mInsets.right;
        dimension.height += this.mInsets.top + this.mInsets.bottom;
        return LayoutSize.sanitizeSize(dimension);
    }

    protected abstract Dimension getSizeSelf(LayoutSize var1);

    public Alignment getHorizontalAlignment() {
        return this.mHorizontalAlignment;
    }

    public void setHorizontalAlignment(Alignment alignment) {
        this.mHorizontalAlignment = alignment;
    }

    public Alignment getVerticalAlignment() {
        return this.mVerticalAlignment;
    }

    public void setVerticalAlignment(Alignment alignment) {
        this.mVerticalAlignment = alignment;
    }

    public Insets getInsets() {
        return this.mInsets;
    }

    public void setInsets(Insets insets) {
        if (insets != null) {
            this.mInsets.set(insets.top, insets.left, insets.bottom, insets.right);
        } else {
            this.mInsets.set(0, 0, 0, 0);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

