/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.layout;

import com.trollworks.ttk.layout.FlexCell;
import com.trollworks.ttk.layout.FlexComponent;
import com.trollworks.ttk.layout.LayoutSize;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;

public abstract class FlexContainer
extends FlexCell {
    private ArrayList<FlexCell> mChildren = new ArrayList();
    private int mHorizontalGap = 5;
    private int mVerticalGap = 2;
    private boolean mFillHorizontal = false;
    private boolean mFillVertical = false;

    public void add(FlexCell flexCell) {
        this.mChildren.add(flexCell);
    }

    public void add(Component component) {
        this.mChildren.add(new FlexComponent(component));
    }

    protected int getChildCount() {
        return this.mChildren.size();
    }

    protected ArrayList<FlexCell> getChildren() {
        return this.mChildren;
    }

    protected Dimension[] getChildSizes(LayoutSize layoutSize) {
        int n = this.getChildCount();
        Dimension[] dimensionArray = new Dimension[n];
        for (int i = 0; i < n; ++i) {
            dimensionArray[i] = this.mChildren.get(i).getSize(layoutSize);
        }
        return dimensionArray;
    }

    protected void layoutChildren(Rectangle[] rectangleArray) {
        for (int i = 0; i < rectangleArray.length; ++i) {
            this.mChildren.get(i).layout(rectangleArray[i]);
        }
    }

    public int getHorizontalGap() {
        return this.mHorizontalGap;
    }

    public void setHorizontalGap(int n) {
        this.mHorizontalGap = n;
    }

    public int getVerticalGap() {
        return this.mVerticalGap;
    }

    public void setVerticalGap(int n) {
        this.mVerticalGap = n;
    }

    public void setFill(boolean bl) {
        this.mFillHorizontal = bl;
        this.mFillVertical = bl;
    }

    public boolean getFillHorizontal() {
        return this.mFillHorizontal;
    }

    public void setFillHorizontal(boolean bl) {
        this.mFillHorizontal = bl;
    }

    public boolean getFillVertical() {
        return this.mFillVertical;
    }

    public void setFillVertical(boolean bl) {
        this.mFillVertical = bl;
    }

    protected int distribute(int n, int[] nArray, int[] nArray2) {
        if (n < 0) {
            return this.distributeShrink(-n, nArray, nArray2);
        }
        return this.distributeGrow(n, nArray, nArray2);
    }

    private int distributeShrink(int n, int[] nArray, int[] nArray2) {
        int n2;
        int[] nArray3 = new int[nArray.length];
        System.arraycopy(nArray, 0, nArray3, 0, nArray.length);
        int[] nArray4 = new int[nArray2.length];
        for (n2 = 0; n2 < nArray2.length; ++n2) {
            nArray4[n2] = nArray[n2] * 2 - nArray2[n2];
        }
        n = this.distributeGrow(n, nArray, nArray4);
        for (n2 = 0; n2 < nArray.length; ++n2) {
            nArray[n2] = nArray3[n2] * 2 - nArray[n2];
        }
        return -n;
    }

    private int distributeGrow(int n, int[] nArray, int[] nArray2) {
        int n2;
        int[] nArray3 = new int[nArray.length];
        System.arraycopy(nArray, 0, nArray3, 0, nArray.length);
        Arrays.sort(nArray3);
        for (n2 = 1; n2 < nArray.length && nArray3[n2] == nArray3[n2 - 1]; ++n2) {
        }
        while (n2 < nArray.length && n > 0) {
            n = this.fill(n, nArray3[n2], nArray, nArray2);
            ++n2;
        }
        if (n > 0) {
            n = this.fill(n, 0x3FFFFF, nArray, nArray2);
        }
        return n;
    }

    private int fill(int n, int n2, int[] nArray, int[] nArray2) {
        int n3;
        int n4 = 0;
        int n5 = 0;
        for (n3 = 0; n3 < nArray.length; ++n3) {
            if (nArray[n3] >= n2 || nArray[n3] >= nArray2[n3]) continue;
            n5 += Math.min(n2, nArray2[n3]) - nArray[n3];
            ++n4;
        }
        if (n4 > 0) {
            if (n5 <= n) {
                for (n3 = 0; n3 < nArray.length; ++n3) {
                    if (nArray[n3] >= n2 || nArray[n3] >= nArray2[n3]) continue;
                    nArray[n3] = Math.min(n2, nArray2[n3]);
                }
                n -= n5;
            } else {
                while (n4 > 0 && n > 0) {
                    n3 = Math.max(n / n4, 1);
                    n4 = 0;
                    for (int i = 0; i < nArray.length && n > 0; ++i) {
                        if (nArray[i] >= n2 || nArray[i] >= nArray2[i]) continue;
                        if (nArray[i] + n3 <= nArray2[i]) {
                            int n6 = i;
                            nArray[n6] = nArray[n6] + n3;
                            n -= n3;
                            if (nArray[i] == n2) continue;
                            ++n4;
                            continue;
                        }
                        n -= nArray2[i] - nArray[i];
                        nArray[i] = nArray2[i];
                    }
                }
            }
        }
        return n;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(super.toString());
        stringBuilder.append('[');
        boolean bl = false;
        for (FlexCell flexCell : this.mChildren) {
            if (bl) {
                stringBuilder.append(", ");
            } else {
                bl = true;
            }
            stringBuilder.append(flexCell);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    @Override
    public void draw(Graphics graphics, Color color) {
        super.draw(graphics, Color.RED);
        for (FlexCell flexCell : this.mChildren) {
            flexCell.draw(graphics, Color.BLUE);
        }
    }
}

