/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.layout;

import com.trollworks.ttk.layout.FlexCell;
import com.trollworks.ttk.layout.FlexSpacer;
import com.trollworks.ttk.layout.LayoutSize;
import java.awt.Dimension;

class FlexGridData {
    FlexCell mCell;
    int mRow;
    int mColumn;
    int mRowSpan;
    int mColumnSpan;
    Dimension mSize;
    Dimension mMinSize;
    Dimension mMaxSize;

    FlexGridData(FlexCell flexCell, int n, int n2, int n3, int n4) {
        if (n < 0) {
            throw new IllegalArgumentException("row must be >= 0");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("column must be >= 0");
        }
        if (n3 < 1) {
            throw new IllegalArgumentException("rowSpan must be > 0");
        }
        if (n4 < 1) {
            throw new IllegalArgumentException("columnSpan must be > 0");
        }
        this.mCell = flexCell;
        this.mRow = n * 2;
        this.mColumn = n2 * 2;
        this.mRowSpan = 1 + (n3 - 1) * 2;
        this.mColumnSpan = 1 + (n4 - 1) * 2;
    }

    FlexGridData(int n, int n2, int n3, int n4) {
        boolean bl = (n & 1) == 1;
        boolean bl2 = (n2 & 1) == 1;
        this.mCell = new FlexSpacer(n4, n3, bl && !bl2, !bl && bl2);
        this.mRow = n;
        this.mColumn = n2;
        this.mRowSpan = 1;
        this.mColumnSpan = 1;
        this.mSize = this.mCell.getSize(LayoutSize.PREFERRED);
        this.mMinSize = this.mCell.getSize(LayoutSize.MINIMUM);
        this.mMaxSize = this.mCell.getSize(LayoutSize.MAXIMUM);
    }

    int getLastRow() {
        return this.mRow + this.mRowSpan - 1;
    }

    int getLastColumn() {
        return this.mColumn + this.mColumnSpan - 1;
    }

    int getNonGapRowSpan() {
        return 1 + (this.mRowSpan - 1) / 2;
    }

    int getNonGapColumnSpan() {
        return 1 + (this.mColumnSpan - 1) / 2;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getSimpleName());
        stringBuilder.append('[');
        if (this.mRow % 2 == 1 || this.mColumn % 2 == 1) {
            stringBuilder.append('g');
        }
        stringBuilder.append(FlexGridData.formatRowColumn(this.mRow / 2, this.mColumn / 2, false));
        if (this.mRowSpan > 1 || this.mColumnSpan > 1) {
            stringBuilder.append(", span ");
            stringBuilder.append(FlexGridData.formatRowColumn(this.getNonGapRowSpan(), this.getNonGapColumnSpan(), true));
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    static String formatRowColumn(int n, int n2, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        if (!bl || n != 1) {
            stringBuilder.append('r');
            stringBuilder.append(n);
        }
        if (!bl || n2 != 1) {
            stringBuilder.append('c');
            stringBuilder.append(n2);
        }
        return stringBuilder.toString();
    }
}

