/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.layout;

import java.awt.Component;
import java.awt.Dimension;

public enum LayoutSize {
    PREFERRED{

        @Override
        public Dimension get(Component component) {
            return 1.sanitizeSize(component.getPreferredSize());
        }
    }
    ,
    MINIMUM{

        @Override
        public Dimension get(Component component) {
            return 2.sanitizeSize(component.getMinimumSize());
        }
    }
    ,
    MAXIMUM{

        @Override
        public Dimension get(Component component) {
            return 3.sanitizeSize(component.getMaximumSize());
        }
    };

    public static final int MAXIMUM_SIZE = 0x3FFFFF;

    public abstract Dimension get(Component var1);

    public static Dimension sanitizeSize(Dimension dimension) {
        if (dimension.width < 0) {
            dimension.width = 0;
        } else if (dimension.width > 0x3FFFFF) {
            dimension.width = 0x3FFFFF;
        }
        if (dimension.height < 0) {
            dimension.height = 0;
        } else if (dimension.height > 0x3FFFFF) {
            dimension.height = 0x3FFFFF;
        }
        return dimension;
    }
}

