/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.layout;

import com.trollworks.ttk.layout.PrecisionLayoutData;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;

public final class PrecisionLayout
implements LayoutManager2 {
    private static final String KEY_COLUMNS = "columns";
    private static final String KEY_EQUAL_COLUMNS = "equalColumns";
    private static final String KEY_HSPACING = "hSpacing";
    private static final String KEY_VSPACING = "vSpacing";
    public int mColumns = 1;
    public boolean mEqualColumns = false;
    public int mMarginLeft = 4;
    public int mMarginTop = 4;
    public int mMarginRight = 4;
    public int mMarginBottom = 4;
    public int mHSpacing = 4;
    public int mVSpacing = 2;
    public int mVAlign = 0;
    public int mHAlign = 0;
    private HashMap<Component, PrecisionLayoutData> mConstraints = new HashMap();
    private int mRowCount;

    public PrecisionLayout() {
    }

    public PrecisionLayout(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n = string2.indexOf(58);
            String string3 = string2.substring(0, n);
            String string4 = string2.substring(n + 1);
            if (KEY_COLUMNS.equalsIgnoreCase(string3)) {
                this.mColumns = Integer.parseInt(string4);
                continue;
            }
            if (KEY_EQUAL_COLUMNS.equalsIgnoreCase(string3)) {
                this.mEqualColumns = PrecisionLayoutData.decodeBoolean(string4);
                continue;
            }
            if ("margins".equalsIgnoreCase(string3)) {
                this.mMarginLeft = this.mMarginTop = Integer.parseInt(string4);
                this.mMarginBottom = this.mMarginTop;
                this.mMarginRight = this.mMarginTop;
                continue;
            }
            if ("top".equalsIgnoreCase(string3)) {
                this.mMarginTop = Integer.parseInt(string4);
                continue;
            }
            if ("left".equalsIgnoreCase(string3)) {
                this.mMarginLeft = Integer.parseInt(string4);
                continue;
            }
            if ("bottom".equalsIgnoreCase(string3)) {
                this.mMarginBottom = Integer.parseInt(string4);
                continue;
            }
            if ("right".equalsIgnoreCase(string3)) {
                this.mMarginRight = Integer.parseInt(string4);
                continue;
            }
            if (KEY_HSPACING.equalsIgnoreCase(string3)) {
                this.mHSpacing = Integer.parseInt(string4);
                continue;
            }
            if (KEY_VSPACING.equalsIgnoreCase(string3)) {
                this.mVSpacing = Integer.parseInt(string4);
                continue;
            }
            if ("hAlign".equalsIgnoreCase(string3)) {
                this.mHAlign = PrecisionLayoutData.decodeAlignment(string4, false);
                continue;
            }
            if ("vAlign".equalsIgnoreCase(string3)) {
                this.mVAlign = PrecisionLayoutData.decodeAlignment(string4, false);
                continue;
            }
            throw new IllegalArgumentException(string2);
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        PrecisionLayoutData.emit(KEY_COLUMNS, this.mColumns, stringBuilder);
        PrecisionLayoutData.emit(KEY_EQUAL_COLUMNS, this.mEqualColumns, stringBuilder);
        if (this.mMarginTop == this.mMarginLeft && this.mMarginTop == this.mMarginBottom && this.mMarginTop == this.mMarginRight) {
            PrecisionLayoutData.emit("margins", this.mMarginTop, stringBuilder);
        } else {
            PrecisionLayoutData.emit("top", this.mMarginTop, stringBuilder);
            PrecisionLayoutData.emit("left", this.mMarginLeft, stringBuilder);
            PrecisionLayoutData.emit("bottom", this.mMarginBottom, stringBuilder);
            PrecisionLayoutData.emit("right", this.mMarginBottom, stringBuilder);
        }
        PrecisionLayoutData.emit(KEY_HSPACING, this.mHSpacing, stringBuilder);
        PrecisionLayoutData.emit(KEY_VSPACING, this.mVSpacing, stringBuilder);
        PrecisionLayoutData.emitAlign("hAlign", this.mHAlign, stringBuilder);
        PrecisionLayoutData.emitAlign("vAlign", this.mVAlign, stringBuilder);
        return stringBuilder.toString();
    }

    @Override
    public void addLayoutComponent(Component component, Object object) {
        if (object == null) {
            object = new PrecisionLayoutData();
        } else if (!(object instanceof PrecisionLayoutData)) {
            object = new PrecisionLayoutData(object.toString());
        }
        this.mConstraints.put(component, (PrecisionLayoutData)object);
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
        this.addLayoutComponent(component, string);
    }

    public PrecisionLayoutData getGridData(Component component) {
        return this.mConstraints.get(component);
    }

    @Override
    public void removeLayoutComponent(Component component) {
        this.mConstraints.remove(component);
    }

    @Override
    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    @Override
    public void invalidateLayout(Container container) {
        for (PrecisionLayoutData precisionLayoutData : this.mConstraints.values()) {
            precisionLayoutData.mCacheHeight = 0;
            precisionLayoutData.mCacheWidth = 0;
            precisionLayoutData.mCacheMinWidth = 0;
        }
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        Insets insets = container.getInsets();
        Dimension dimension = this.layout(container, false, 0, 0, -1, -1, true);
        dimension.width += insets.left + insets.right;
        dimension.height += insets.top + insets.bottom;
        return dimension;
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        Insets insets = container.getInsets();
        Dimension dimension = this.layout(container, false, 0, 0, -1, -1, false);
        dimension.width += insets.left + insets.right;
        dimension.height += insets.top + insets.bottom;
        return dimension;
    }

    @Override
    public Dimension maximumLayoutSize(Container container) {
        int n = 0xFFFFFFF;
        return new Dimension(n, n);
    }

    @Override
    public void layoutContainer(Container container) {
        Insets insets = container.getInsets();
        this.layout(container, true, insets.left, insets.top, container.getWidth() - (insets.left + insets.right), container.getHeight() - (insets.top + insets.bottom), false);
    }

    private Dimension layout(Container container, boolean bl, int n, int n2, int n3, int n4, boolean bl2) {
        Component[] componentArray;
        int n5 = this.mMarginLeft + this.mMarginRight;
        int n6 = this.mMarginTop + this.mMarginBottom;
        if (this.mColumns > 0 && (componentArray = this.getChildren(container, bl2)).length > 0) {
            int n7;
            Component[][] componentArray2 = this.buildGrid(componentArray);
            int[] nArray = this.adjustColumnWidths(n3, componentArray2);
            this.wrap(n3, componentArray2, nArray, bl2);
            int[] nArray2 = this.adjustRowHeights(n4, componentArray2);
            n5 += this.mHSpacing * (this.mColumns - 1);
            n6 += this.mVSpacing * (this.mRowCount - 1);
            for (n7 = 0; n7 < this.mColumns; ++n7) {
                n5 += nArray[n7];
            }
            for (n7 = 0; n7 < this.mRowCount; ++n7) {
                n6 += nArray2[n7];
            }
            if (bl) {
                if (n5 < n3) {
                    if (this.mHAlign == 1) {
                        n += (n3 - n5) / 2;
                    } else if (this.mHAlign == 2) {
                        n += n3 - n5;
                    }
                }
                if (n6 < n4) {
                    if (this.mVAlign == 1) {
                        n2 += (n4 - n6) / 2;
                    } else if (this.mVAlign == 2) {
                        n2 += n4 - n6;
                    }
                }
                this.positionChildren(n, n2, componentArray2, nArray, nArray2);
            }
        }
        return new Dimension(n5, n6);
    }

    private void positionChildren(int n, int n2, Component[][] componentArray, int[] nArray, int[] nArray2) {
        int n3 = n2 + this.mMarginTop;
        for (int i = 0; i < this.mRowCount; ++i) {
            int n4 = n + this.mMarginLeft;
            for (int j = 0; j < this.mColumns; ++j) {
                PrecisionLayoutData precisionLayoutData = this.getData(componentArray, i, j, this.mRowCount, true);
                if (precisionLayoutData != null) {
                    int n5;
                    int n6 = Math.max(1, Math.min(precisionLayoutData.mHSpan, this.mColumns));
                    int n7 = Math.max(1, precisionLayoutData.mVSpan);
                    int n8 = 0;
                    int n9 = 0;
                    for (n5 = 0; n5 < n6; ++n5) {
                        n8 += nArray[j + n5];
                    }
                    for (n5 = 0; n5 < n7; ++n5) {
                        n9 += nArray2[i + n5];
                    }
                    n5 = n4 + precisionLayoutData.mMarginLeft;
                    int n10 = Math.min(precisionLayoutData.mCacheWidth, n8 += this.mHSpacing * (n6 - 1));
                    switch (precisionLayoutData.mHAlign) {
                        case 1: {
                            n5 += Math.max(0, (n8 - (precisionLayoutData.mMarginLeft + precisionLayoutData.mMarginRight) - n10) / 2);
                            break;
                        }
                        case 2: {
                            n5 += Math.max(0, n8 - (precisionLayoutData.mMarginLeft + precisionLayoutData.mMarginRight) - n10);
                            break;
                        }
                        case 3: {
                            n10 = n8 - (precisionLayoutData.mMarginLeft + precisionLayoutData.mMarginRight);
                        }
                    }
                    int n11 = n3 + precisionLayoutData.mMarginTop;
                    int n12 = Math.min(precisionLayoutData.mCacheHeight, n9 += this.mVSpacing * (n7 - 1));
                    switch (precisionLayoutData.mVAlign) {
                        case 1: {
                            n11 += Math.max(0, (n9 - (precisionLayoutData.mMarginTop + precisionLayoutData.mMarginBottom) - n12) / 2);
                            break;
                        }
                        case 2: {
                            n11 += Math.max(0, n9 - (precisionLayoutData.mMarginTop + precisionLayoutData.mMarginBottom) - n12);
                            break;
                        }
                        case 3: {
                            n12 = n9 - (precisionLayoutData.mMarginTop + precisionLayoutData.mMarginBottom);
                        }
                    }
                    Component component = componentArray[i][j];
                    if (component != null) {
                        component.setBounds(n5, n11, n10, n12);
                    }
                }
                n4 += nArray[j] + this.mHSpacing;
            }
            n3 += nArray2[i] + this.mVSpacing;
        }
    }

    private Component[] getChildren(Container container, boolean bl) {
        ArrayList<Component> arrayList = new ArrayList<Component>();
        for (Component component : container.getComponents()) {
            PrecisionLayoutData precisionLayoutData = this.mConstraints.get(component);
            if (precisionLayoutData.mExclude) continue;
            arrayList.add(component);
            precisionLayoutData.computeSize(component, -1, -1, bl);
        }
        return arrayList.toArray(new Component[arrayList.size()]);
    }

    private Component[][] buildGrid(Component[] componentArray) {
        Component[][] componentArray2 = new Component[4][this.mColumns];
        int n = 0;
        int n2 = 0;
        this.mRowCount = 0;
        for (Component component : componentArray) {
            int n3;
            int n4;
            int n5;
            PrecisionLayoutData precisionLayoutData = this.mConstraints.get(component);
            int n6 = Math.max(1, Math.min(precisionLayoutData.mHSpan, this.mColumns));
            int n7 = Math.max(1, precisionLayoutData.mVSpan);
            while (true) {
                if ((n5 = n + n7) >= componentArray2.length) {
                    Component[][] componentArray3 = new Component[n5 + 4][this.mColumns];
                    System.arraycopy(componentArray2, 0, componentArray3, 0, componentArray2.length);
                    componentArray2 = componentArray3;
                }
                if (componentArray2[n] == null) {
                    componentArray2[n] = new Component[this.mColumns];
                }
                while (n2 < this.mColumns && componentArray2[n][n2] != null) {
                    ++n2;
                }
                n4 = n2 + n6;
                if (n4 <= this.mColumns) {
                    for (n3 = n2; n3 < n4 && componentArray2[n][n3] == null; ++n3) {
                    }
                    if (n3 == n4) break;
                    n2 = n3;
                }
                if (n2 + n6 < this.mColumns) continue;
                n2 = 0;
                ++n;
            }
            for (n5 = 0; n5 < n7; ++n5) {
                n4 = n + n5;
                if (componentArray2[n4] == null) {
                    componentArray2[n4] = new Component[this.mColumns];
                }
                for (n3 = 0; n3 < n6; ++n3) {
                    componentArray2[n4][n2 + n3] = component;
                }
            }
            this.mRowCount = Math.max(this.mRowCount, n + n7);
            n2 += n6;
        }
        return componentArray2;
    }

    private PrecisionLayoutData getData(Component[][] componentArray, int n, int n2, int n3, boolean bl) {
        Component component = componentArray[n][n2];
        if (component != null) {
            int n4;
            PrecisionLayoutData precisionLayoutData = this.mConstraints.get(component);
            int n5 = Math.max(1, Math.min(precisionLayoutData.mHSpan, this.mColumns));
            int n6 = Math.max(1, precisionLayoutData.mVSpan);
            int n7 = bl ? n + n6 - 1 : n - n6 + 1;
            int n8 = n4 = bl ? n2 + n5 - 1 : n2 - n5 + 1;
            if (0 <= n7 && n7 < n3 && 0 <= n4 && n4 < this.mColumns && component == componentArray[n7][n4]) {
                return precisionLayoutData;
            }
        }
        return null;
    }

    private int[] adjustColumnWidths(int n, Component[][] componentArray) {
        int[] nArray;
        block33: {
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            int n8;
            int n9;
            int n10;
            int n11;
            int n12;
            boolean[] blArray;
            int[] nArray2;
            int n13;
            int n14;
            block34: {
                int n15;
                n14 = n - this.mHSpacing * (this.mColumns - 1) - (this.mMarginLeft + this.mMarginRight);
                n13 = 0;
                nArray = new int[this.mColumns];
                nArray2 = new int[this.mColumns];
                blArray = new boolean[this.mColumns];
                for (n12 = 0; n12 < this.mColumns; ++n12) {
                    PrecisionLayoutData precisionLayoutData;
                    for (n11 = 0; n11 < this.mRowCount; ++n11) {
                        precisionLayoutData = this.getData(componentArray, n11, n12, this.mRowCount, true);
                        if (precisionLayoutData == null || (n10 = Math.max(1, Math.min(precisionLayoutData.mHSpan, this.mColumns))) != 1) continue;
                        n9 = precisionLayoutData.mCacheWidth + precisionLayoutData.mMarginLeft + precisionLayoutData.mMarginRight;
                        if (nArray[n12] < n9) {
                            nArray[n12] = n9;
                        }
                        if (precisionLayoutData.mHGrab) {
                            if (!blArray[n12]) {
                                ++n13;
                            }
                            blArray[n12] = true;
                        }
                        n8 = precisionLayoutData.mCacheMinWidth;
                        if (precisionLayoutData.mHGrab && n8 == 0) continue;
                        n9 = !precisionLayoutData.mHGrab || n8 == -1 ? precisionLayoutData.mCacheWidth : n8;
                        nArray2[n12] = Math.max(nArray2[n12], n9 += precisionLayoutData.mMarginLeft + precisionLayoutData.mMarginRight);
                    }
                    for (n11 = 0; n11 < this.mRowCount; ++n11) {
                        int n16;
                        precisionLayoutData = this.getData(componentArray, n11, n12, this.mRowCount, false);
                        if (precisionLayoutData == null || (n10 = Math.max(1, Math.min(precisionLayoutData.mHSpan, this.mColumns))) <= 1) continue;
                        n9 = 0;
                        n8 = 0;
                        n7 = 0;
                        for (n16 = 0; n16 < n10; ++n16) {
                            n9 += nArray[n12 - n16];
                            n8 += nArray2[n12 - n16];
                            if (!blArray[n12 - n16]) continue;
                            ++n7;
                        }
                        if (precisionLayoutData.mHGrab && n7 == 0) {
                            ++n13;
                            blArray[n12] = true;
                        }
                        if ((n16 = precisionLayoutData.mCacheWidth + precisionLayoutData.mMarginLeft + precisionLayoutData.mMarginRight - n9 - (n10 - 1) * this.mHSpacing) > 0) {
                            if (this.mEqualColumns) {
                                n6 = (n16 + n9) / n10;
                                n5 = (n16 + n9) % n10;
                                n4 = -1;
                                for (n3 = 0; n3 < n10; ++n3) {
                                    n4 = n12 - n3;
                                    nArray[n4] = Math.max(n6, nArray[n4]);
                                }
                                if (n4 > -1) {
                                    int n17 = n4;
                                    nArray[n17] = nArray[n17] + n5;
                                }
                            } else if (n7 == 0) {
                                int n18 = n12;
                                nArray[n18] = nArray[n18] + n16;
                            } else {
                                n6 = n16 / n7;
                                n5 = n16 % n7;
                                n4 = -1;
                                for (n3 = 0; n3 < n10; ++n3) {
                                    if (!blArray[n12 - n3]) continue;
                                    int n19 = n4 = n12 - n3;
                                    nArray[n19] = nArray[n19] + n6;
                                }
                                if (n4 > -1) {
                                    int n20 = n4;
                                    nArray[n20] = nArray[n20] + n5;
                                }
                            }
                        }
                        n6 = precisionLayoutData.mCacheMinWidth;
                        if (precisionLayoutData.mHGrab && n6 == 0) continue;
                        int n21 = n16 = !precisionLayoutData.mHGrab || n6 == -1 ? precisionLayoutData.mCacheWidth : n6;
                        if ((n16 += precisionLayoutData.mMarginLeft + precisionLayoutData.mMarginRight - n8 - (n10 - 1) * this.mHSpacing) <= 0) continue;
                        if (n7 == 0) {
                            int n22 = n12;
                            nArray2[n22] = nArray2[n22] + n16;
                            continue;
                        }
                        n5 = n16 / n7;
                        n4 = n16 % n7;
                        n3 = -1;
                        for (n2 = 0; n2 < n10; ++n2) {
                            if (!blArray[n12 - n2]) continue;
                            int n23 = n3 = n12 - n2;
                            nArray2[n23] = nArray2[n23] + n5;
                        }
                        if (n3 <= -1) continue;
                        int n24 = n3;
                        nArray2[n24] = nArray2[n24] + n4;
                    }
                }
                if (!this.mEqualColumns) break block34;
                n12 = 0;
                n11 = 0;
                for (n15 = 0; n15 < this.mColumns; ++n15) {
                    n12 = Math.max(n12, nArray2[n15]);
                    n11 = Math.max(n11, nArray[n15]);
                }
                n11 = n == -1 || n13 == 0 ? n11 : Math.max(n12, n14 / this.mColumns);
                for (n15 = 0; n15 < this.mColumns; ++n15) {
                    blArray[n15] = n13 > 0;
                    nArray[n15] = n11;
                }
                break block33;
            }
            if (n == -1 || n13 <= 0) break block33;
            n12 = 0;
            for (n11 = 0; n11 < this.mColumns; ++n11) {
                n12 += nArray[n11];
            }
            n11 = n13;
            int n25 = n14 - n12;
            n10 = n25 / n11;
            n25 %= n11;
            n9 = -1;
            while (n12 != n14) {
                for (n8 = 0; n8 < this.mColumns; ++n8) {
                    if (!blArray[n8]) continue;
                    if (nArray[n8] + n10 > nArray2[n8]) {
                        n9 = n8;
                        nArray[n9] = nArray[n8] + n10;
                        continue;
                    }
                    nArray[n8] = nArray2[n8];
                    blArray[n8] = false;
                    --n11;
                }
                if (n9 > -1) {
                    int n26 = n9;
                    nArray[n26] = nArray[n26] + n25;
                }
                for (n8 = 0; n8 < this.mColumns; ++n8) {
                    for (n7 = 0; n7 < this.mRowCount; ++n7) {
                        PrecisionLayoutData precisionLayoutData = this.getData(componentArray, n7, n8, this.mRowCount, false);
                        if (precisionLayoutData == null || (n6 = Math.max(1, Math.min(precisionLayoutData.mHSpan, this.mColumns))) <= 1) continue;
                        n5 = precisionLayoutData.mCacheMinWidth;
                        if (precisionLayoutData.mHGrab && n5 == 0) continue;
                        n4 = 0;
                        n3 = 0;
                        for (n2 = 0; n2 < n6; ++n2) {
                            n4 += nArray[n8 - n2];
                            if (!blArray[n8 - n2]) continue;
                            ++n3;
                        }
                        int n27 = n2 = !precisionLayoutData.mHGrab || n5 == -1 ? precisionLayoutData.mCacheWidth : n5;
                        if ((n2 += precisionLayoutData.mMarginLeft + precisionLayoutData.mMarginRight - n4 - (n6 - 1) * this.mHSpacing) <= 0) continue;
                        if (n3 == 0) {
                            int n28 = n8;
                            nArray[n28] = nArray[n28] + n2;
                            continue;
                        }
                        int n29 = n2 / n3;
                        int n30 = n2 % n3;
                        int n31 = -1;
                        for (int i = 0; i < n6; ++i) {
                            if (!blArray[n8 - i]) continue;
                            n31 = n8 - i;
                            nArray[n31] = nArray[n31] + n29;
                        }
                        if (n31 <= -1) continue;
                        int n32 = n31;
                        nArray[n32] = nArray[n32] + n30;
                    }
                }
                if (n11 != 0) {
                    n12 = 0;
                    for (n8 = 0; n8 < this.mColumns; ++n8) {
                        n12 += nArray[n8];
                    }
                    n10 = (n14 - n12) / n11;
                    n25 = (n14 - n12) % n11;
                    n9 = -1;
                    continue;
                }
                break;
            }
        }
        return nArray;
    }

    private void wrap(int n, Component[][] componentArray, int[] nArray, boolean bl) {
        if (n != -1) {
            for (int i = 0; i < this.mColumns; ++i) {
                for (int j = 0; j < this.mRowCount; ++j) {
                    int n2;
                    PrecisionLayoutData precisionLayoutData = this.getData(componentArray, j, i, this.mRowCount, false);
                    if (precisionLayoutData == null || precisionLayoutData.mHeightHint != -1) continue;
                    int n3 = Math.max(1, Math.min(precisionLayoutData.mHSpan, this.mColumns));
                    int n4 = 0;
                    for (n2 = 0; n2 < n3; ++n2) {
                        n4 += nArray[i - n2];
                    }
                    if (((n4 += (n3 - 1) * this.mHSpacing - (precisionLayoutData.mMarginLeft + precisionLayoutData.mMarginRight)) == precisionLayoutData.mCacheWidth || precisionLayoutData.mHAlign != 3) && precisionLayoutData.mCacheWidth <= n4) continue;
                    precisionLayoutData.computeSize(componentArray[j][i], Math.max(precisionLayoutData.mCacheMinWidth, n4), -1, bl);
                    n2 = precisionLayoutData.mMinHeight;
                    if (!precisionLayoutData.mVGrab || n2 <= 0) continue;
                    precisionLayoutData.mCacheHeight = Math.max(precisionLayoutData.mCacheHeight, n2);
                }
            }
        }
    }

    private int[] adjustRowHeights(int n, Component[][] componentArray) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13 = n - this.mVSpacing * (this.mRowCount - 1) - (this.mMarginTop + this.mMarginBottom);
        int n14 = 0;
        int[] nArray = new int[this.mRowCount];
        int[] nArray2 = new int[this.mRowCount];
        boolean[] blArray = new boolean[this.mRowCount];
        for (n12 = 0; n12 < this.mRowCount; ++n12) {
            PrecisionLayoutData precisionLayoutData;
            for (n11 = 0; n11 < this.mColumns; ++n11) {
                precisionLayoutData = this.getData(componentArray, n12, n11, this.mRowCount, true);
                if (precisionLayoutData == null || (n10 = Math.max(1, Math.min(precisionLayoutData.mVSpan, this.mRowCount))) != 1) continue;
                n9 = precisionLayoutData.mCacheHeight + precisionLayoutData.mMarginTop + precisionLayoutData.mMarginBottom;
                nArray[n12] = Math.max(nArray[n12], n9);
                if (precisionLayoutData.mVGrab) {
                    if (!blArray[n12]) {
                        ++n14;
                    }
                    blArray[n12] = true;
                }
                n8 = precisionLayoutData.mMinHeight;
                if (precisionLayoutData.mVGrab && n8 == 0) continue;
                n9 = !precisionLayoutData.mVGrab || n8 == -1 ? precisionLayoutData.mCacheHeight : n8;
                nArray2[n12] = Math.max(nArray2[n12], n9 += precisionLayoutData.mMarginTop + precisionLayoutData.mMarginBottom);
            }
            for (n11 = 0; n11 < this.mColumns; ++n11) {
                int n15;
                precisionLayoutData = this.getData(componentArray, n12, n11, this.mRowCount, false);
                if (precisionLayoutData == null || (n10 = Math.max(1, Math.min(precisionLayoutData.mVSpan, this.mRowCount))) <= 1) continue;
                n9 = 0;
                n8 = 0;
                n7 = 0;
                for (n15 = 0; n15 < n10; ++n15) {
                    n9 += nArray[n12 - n15];
                    n8 += nArray2[n12 - n15];
                    if (!blArray[n12 - n15]) continue;
                    ++n7;
                }
                if (precisionLayoutData.mVGrab && n7 == 0) {
                    ++n14;
                    blArray[n12] = true;
                }
                if ((n15 = precisionLayoutData.mCacheHeight + precisionLayoutData.mMarginTop + precisionLayoutData.mMarginBottom - n9 - (n10 - 1) * this.mVSpacing) > 0) {
                    if (n7 == 0) {
                        int n16 = n12;
                        nArray[n16] = nArray[n16] + n15;
                    } else {
                        n6 = n15 / n7;
                        n5 = n15 % n7;
                        n4 = -1;
                        for (n3 = 0; n3 < n10; ++n3) {
                            if (!blArray[n12 - n3]) continue;
                            n4 = n12 - n3;
                            nArray[n4] = nArray[n4] + n6;
                        }
                        if (n4 > -1) {
                            int n17 = n4;
                            nArray[n17] = nArray[n17] + n5;
                        }
                    }
                }
                n6 = precisionLayoutData.mMinHeight;
                if (precisionLayoutData.mVGrab && n6 == 0) continue;
                int n18 = n15 = !precisionLayoutData.mVGrab || n6 == -1 ? precisionLayoutData.mCacheHeight : n6;
                if ((n15 += precisionLayoutData.mMarginTop + precisionLayoutData.mMarginBottom - n8 - (n10 - 1) * this.mVSpacing) <= 0) continue;
                if (n7 == 0) {
                    int n19 = n12;
                    nArray2[n19] = nArray2[n19] + n15;
                    continue;
                }
                n5 = n15 / n7;
                n4 = n15 % n7;
                n3 = -1;
                for (n2 = 0; n2 < n10; ++n2) {
                    if (!blArray[n12 - n2]) continue;
                    n3 = n12 - n2;
                    nArray2[n3] = nArray2[n3] + n5;
                }
                if (n3 <= -1) continue;
                int n20 = n3;
                nArray2[n20] = nArray2[n20] + n4;
            }
        }
        if (n != -1 && n14 > 0) {
            n12 = 0;
            for (n11 = 0; n11 < this.mRowCount; ++n11) {
                n12 += nArray[n11];
            }
            n11 = n14;
            int n21 = (n13 - n12) / n11;
            n10 = (n13 - n12) % n11;
            n9 = -1;
            while (n12 != n13) {
                for (n8 = 0; n8 < this.mRowCount; ++n8) {
                    if (!blArray[n8]) continue;
                    if (nArray[n8] + n21 > nArray2[n8]) {
                        n9 = n8;
                        nArray[n9] = nArray[n8] + n21;
                        continue;
                    }
                    nArray[n8] = nArray2[n8];
                    blArray[n8] = false;
                    --n11;
                }
                if (n9 > -1) {
                    int n22 = n9;
                    nArray[n22] = nArray[n22] + n10;
                }
                for (n8 = 0; n8 < this.mRowCount; ++n8) {
                    for (n7 = 0; n7 < this.mColumns; ++n7) {
                        PrecisionLayoutData precisionLayoutData = this.getData(componentArray, n8, n7, this.mRowCount, false);
                        if (precisionLayoutData == null || (n6 = Math.max(1, Math.min(precisionLayoutData.mVSpan, this.mRowCount))) <= 1) continue;
                        n5 = precisionLayoutData.mMinHeight;
                        if (precisionLayoutData.mVGrab && n5 == 0) continue;
                        n4 = 0;
                        n3 = 0;
                        for (n2 = 0; n2 < n6; ++n2) {
                            n4 += nArray[n8 - n2];
                            if (!blArray[n8 - n2]) continue;
                            ++n3;
                        }
                        int n23 = n2 = !precisionLayoutData.mVGrab || n5 == -1 ? precisionLayoutData.mCacheHeight : n5;
                        if ((n2 += precisionLayoutData.mMarginTop + precisionLayoutData.mMarginBottom - n4 - (n6 - 1) * this.mVSpacing) <= 0) continue;
                        if (n3 == 0) {
                            int n24 = n8;
                            nArray[n24] = nArray[n24] + n2;
                            continue;
                        }
                        int n25 = n2 / n3;
                        int n26 = n2 % n3;
                        int n27 = -1;
                        for (int i = 0; i < n6; ++i) {
                            if (!blArray[n8 - i]) continue;
                            n27 = n8 - i;
                            nArray[n27] = nArray[n27] + n25;
                        }
                        if (n27 <= -1) continue;
                        int n28 = n27;
                        nArray[n28] = nArray[n28] + n26;
                    }
                }
                if (n11 == 0) break;
                n12 = 0;
                for (n8 = 0; n8 < this.mRowCount; ++n8) {
                    n12 += nArray[n8];
                }
                n21 = (n13 - n12) / n11;
                n10 = (n13 - n12) % n11;
                n9 = -1;
            }
        }
        return nArray;
    }
}

