/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.menu;

import com.trollworks.ttk.menu.Command;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JMenu;
import javax.swing.JMenuBar;

public class StdMenuBar
extends JMenuBar {
    private static Class<? extends JMenu>[] MENU_CLASSES;
    private static Command[] COMMANDS;

    public static final void configure(Class<? extends JMenu> ... classArray) {
        MENU_CLASSES = new Class[classArray.length];
        System.arraycopy(classArray, 0, MENU_CLASSES, 0, classArray.length);
        TreeSet<Command> treeSet = new TreeSet<Command>();
        for (Class<? extends JMenu> clazz : MENU_CLASSES) {
            try {
                Method method = clazz.getMethod("getCommands", new Class[0]);
                int n = method.getModifiers();
                if (!Modifier.isStatic(n) || !Modifier.isPublic(n) || !Set.class.isAssignableFrom(method.getReturnType())) continue;
                for (Object e : (Set)method.invoke((Object)null, (Object[])null)) {
                    if (!(e instanceof Command)) continue;
                    treeSet.add((Command)e);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        COMMANDS = treeSet.toArray(new Command[treeSet.size()]);
    }

    public static final Command[] getCommands() {
        return COMMANDS;
    }

    public StdMenuBar() {
        for (Class<? extends JMenu> clazz : MENU_CLASSES) {
            try {
                this.add(clazz.newInstance());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public static JMenu findMenu(JMenuBar jMenuBar, Class<? extends JMenu> clazz) {
        if (jMenuBar != null) {
            int n = jMenuBar.getMenuCount();
            for (int i = 0; i < n; ++i) {
                JMenu jMenu = jMenuBar.getMenu(i);
                if (!clazz.isInstance(jMenu)) continue;
                return jMenu;
            }
        }
        return null;
    }
}

