/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.menu.edit;

import com.trollworks.ttk.menu.Command;
import com.trollworks.ttk.menu.edit.Undoable;
import com.trollworks.ttk.undo.StdUndoManager;
import com.trollworks.ttk.utility.LocalizedMessages;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.JMenuItem;

public class RedoCommand
extends Command {
    public static final String CMD_REDO = "Redo";
    private static String MSG_REDO;
    public static final RedoCommand INSTANCE;

    private RedoCommand() {
        super(MSG_REDO, CMD_REDO, 89);
    }

    @Override
    public void adjustForMenu(JMenuItem jMenuItem) {
        Window window = RedoCommand.getActiveWindow();
        if (window instanceof Undoable) {
            StdUndoManager stdUndoManager = ((Undoable)((Object)window)).getUndoManager();
            this.setEnabled(stdUndoManager.canRedo());
            this.setTitle(stdUndoManager.getRedoPresentationName());
        } else {
            this.setEnabled(false);
            this.setTitle(MSG_REDO);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        ((Undoable)((Object)RedoCommand.getActiveWindow())).getUndoManager().redo();
    }

    static {
        LocalizedMessages.initialize(RedoCommand.class);
        INSTANCE = new RedoCommand();
    }
}

