/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.menu.file;

import com.trollworks.ttk.menu.Command;
import com.trollworks.ttk.menu.file.Saveable;
import com.trollworks.ttk.utility.LocalizedMessages;
import com.trollworks.ttk.utility.Path;
import com.trollworks.ttk.widgets.StdFileDialog;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.JMenuItem;

public class ExportToCommand
extends Command {
    public static final String CMD_EXPORT_TO_HTML = "ExportToHTML";
    public static final String CMD_EXPORT_TO_PDF = "ExportToPDF";
    public static final String CMD_EXPORT_TO_PNG = "ExportToPNG";
    public static final String PNG_EXTENSION = ".png";
    public static final String PDF_EXTENSION = ".pdf";
    public static final String HTML_EXTENSION = ".html";
    private static String MSG_EXPORT_TO_HTML;
    private static String MSG_EXPORT_TO_PDF;
    private static String MSG_EXPORT_TO_PNG;
    public static final ExportToCommand EXPORT_TO_HTML;
    public static final ExportToCommand EXPORT_TO_PDF;
    public static final ExportToCommand EXPORT_TO_PNG;
    private String mExtension;

    private ExportToCommand(String string, String string2, String string3) {
        super(string, string2);
        this.mExtension = string3;
    }

    @Override
    public void adjustForMenu(JMenuItem jMenuItem) {
        Window window = ExportToCommand.getActiveWindow();
        boolean bl = false;
        if (window instanceof Saveable) {
            for (String string : ((Saveable)((Object)window)).getAllowedExtensions()) {
                if (!this.mExtension.equals(string)) continue;
                bl = true;
                break;
            }
        }
        this.setEnabled(bl);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.saveAs((Saveable)((Object)ExportToCommand.getActiveWindow()));
    }

    public File[] saveAs(Saveable saveable) {
        String string = saveable.getPreferredSavePath();
        File file = StdFileDialog.choose(saveable instanceof Component ? (Component)((Object)saveable) : null, false, (String)this.getValue("Name"), Path.getParent(string), Path.getLeafName(string), this.mExtension);
        return file != null ? saveable.saveTo(file) : new File[]{};
    }

    static {
        LocalizedMessages.initialize(ExportToCommand.class);
        EXPORT_TO_HTML = new ExportToCommand(MSG_EXPORT_TO_HTML, CMD_EXPORT_TO_HTML, HTML_EXTENSION);
        EXPORT_TO_PDF = new ExportToCommand(MSG_EXPORT_TO_PDF, CMD_EXPORT_TO_PDF, PDF_EXTENSION);
        EXPORT_TO_PNG = new ExportToCommand(MSG_EXPORT_TO_PNG, CMD_EXPORT_TO_PNG, PNG_EXTENSION);
    }
}

