/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.menu.file;

import com.trollworks.ttk.menu.Command;
import com.trollworks.ttk.menu.file.FileType;
import com.trollworks.ttk.menu.file.RecentFilesMenu;
import com.trollworks.ttk.utility.Debug;
import com.trollworks.ttk.utility.LocalizedMessages;
import com.trollworks.ttk.widgets.AppWindow;
import com.trollworks.ttk.widgets.StdFileDialog;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import javax.swing.JMenuItem;

public class OpenCommand
extends Command {
    public static final String CMD_OPEN = "Open";
    private static String MSG_OPEN;
    public static final OpenCommand INSTANCE;

    private OpenCommand() {
        super(MSG_OPEN, CMD_OPEN, 79);
    }

    @Override
    public void adjustForMenu(JMenuItem jMenuItem) {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.open();
    }

    public void open() {
        Component component = OpenCommand.getFocusOwner();
        this.open(StdFileDialog.choose(component, true, MSG_OPEN, null, null, FileType.getOpenableExtensions()));
    }

    public void open(File file) {
        if (file != null) {
            try {
                String string = file.getName();
                AppWindow appWindow = AppWindow.findWindow(file);
                if (appWindow == null) {
                    for (FileType fileType : FileType.getOpenable()) {
                        if (!string.matches(StdFileDialog.createExtensionMatcher(fileType.getExtension()))) continue;
                        Constructor<? extends AppWindow> constructor = fileType.getWindowClass().getConstructor(File.class);
                        appWindow = constructor.newInstance(file);
                        appWindow.setVisible(true);
                        break;
                    }
                } else {
                    appWindow.toFront();
                }
                if (appWindow == null) {
                    throw new IOException("Unknown file extension");
                }
                RecentFilesMenu.addRecent(file);
            }
            catch (Exception exception) {
                Debug.diagnoseLoadAndSave(exception);
                StdFileDialog.showCannotOpenMsg(OpenCommand.getFocusOwner(), file.getName(), exception);
            }
        }
    }

    static {
        LocalizedMessages.initialize(OpenCommand.class);
        INSTANCE = new OpenCommand();
    }
}

