/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.menu.file;

import com.trollworks.ttk.menu.Command;
import com.trollworks.ttk.menu.file.CloseCommand;
import com.trollworks.ttk.menu.file.RecentFilesMenu;
import com.trollworks.ttk.menu.file.SignificantFrame;
import com.trollworks.ttk.preferences.Preferences;
import com.trollworks.ttk.utility.Fonts;
import com.trollworks.ttk.utility.LocalizedMessages;
import com.trollworks.ttk.utility.Platform;
import com.trollworks.ttk.widgets.BaseWindow;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import javax.swing.JMenuItem;

public class QuitCommand
extends Command {
    public static final String CMD_QUIT = "Quit";
    private static String MSG_QUIT;
    private static String MSG_EXIT;
    public static final QuitCommand INSTANCE;

    private QuitCommand() {
        super(Platform.isMacintosh() ? MSG_QUIT : MSG_EXIT, CMD_QUIT, 81);
    }

    @Override
    public void adjustForMenu(JMenuItem jMenuItem) {
        for (Frame frame : Frame.getFrames()) {
            if (!frame.isVisible() || !BaseWindow.hasOwnedWindowsShowing(frame)) continue;
            this.setEnabled(false);
            return;
        }
        this.setEnabled(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.quit();
    }

    public void quit() {
        if (this.isEnabled() && this.closeFrames(true) && this.closeFrames(false)) {
            try {
                RecentFilesMenu.saveToPreferences();
                Fonts.saveToPreferences();
                Preferences.getInstance().save();
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.exit(0);
        }
    }

    private boolean closeFrames(boolean bl) {
        for (Frame frame : Frame.getFrames()) {
            if (frame instanceof SignificantFrame != bl || !frame.isVisible()) continue;
            try {
                if (CloseCommand.INSTANCE.close(frame, false)) continue;
                return false;
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
        }
        return true;
    }

    static {
        LocalizedMessages.initialize(QuitCommand.class);
        INSTANCE = new QuitCommand();
    }
}

