/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.preferences;

import com.trollworks.ttk.layout.Alignment;
import com.trollworks.ttk.layout.FlexComponent;
import com.trollworks.ttk.layout.FlexContainer;
import com.trollworks.ttk.preferences.PreferencesWindow;
import com.trollworks.ttk.utility.UIUtilities;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ItemListener;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;

public abstract class PreferencePanel
extends JPanel {
    private String mTitle;
    private PreferencesWindow mOwner;

    public PreferencePanel(String string, PreferencesWindow preferencesWindow) {
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setOpaque(false);
        this.mTitle = string;
        this.mOwner = preferencesWindow;
    }

    public PreferencesWindow getOwner() {
        return this.mOwner;
    }

    public abstract void reset();

    public abstract boolean isSetToDefaults();

    protected void adjustResetButton() {
        this.mOwner.adjustResetButton();
    }

    @Override
    public String toString() {
        return this.mTitle;
    }

    protected JLabel createLabel(String string, String string2) {
        return this.createLabel(string, string2, null, 4);
    }

    protected JLabel createLabel(String string, String string2, int n) {
        return this.createLabel(string, string2, null, n);
    }

    protected JLabel createLabel(String string, String string2, ImageIcon imageIcon) {
        return this.createLabel(string, string2, imageIcon, 4);
    }

    protected JLabel createLabel(String string, String string2, ImageIcon imageIcon, int n) {
        JLabel jLabel = new JLabel(string, n);
        jLabel.setOpaque(false);
        jLabel.setToolTipText(string2);
        jLabel.setIcon(imageIcon);
        UIUtilities.setOnlySize(jLabel, jLabel.getPreferredSize());
        this.add(jLabel);
        return jLabel;
    }

    protected void addSeparator(FlexContainer flexContainer) {
        JSeparator jSeparator = new JSeparator();
        jSeparator.setOpaque(false);
        jSeparator.setMaximumSize(new Dimension(0x3FFFFF, 1));
        this.add(jSeparator);
        FlexComponent flexComponent = new FlexComponent(jSeparator, Alignment.CENTER, Alignment.CENTER);
        flexComponent.setInsets(new Insets(5, 0, 5, 0));
        flexContainer.add(flexComponent);
    }

    protected JCheckBox createCheckBox(String string, String string2, boolean bl) {
        JCheckBox jCheckBox = new JCheckBox(string, bl);
        jCheckBox.setOpaque(false);
        jCheckBox.setToolTipText(string2);
        if (this instanceof ItemListener) {
            jCheckBox.addItemListener((ItemListener)((Object)this));
        }
        this.add(jCheckBox);
        return jCheckBox;
    }

    protected JComboBox createCombo(String string) {
        JComboBox jComboBox = new JComboBox();
        jComboBox.setOpaque(false);
        jComboBox.setToolTipText(string);
        this.add(jComboBox);
        return jComboBox;
    }
}

