/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.preferences;

import com.trollworks.ttk.notification.Notifier;
import com.trollworks.ttk.text.Conversion;
import com.trollworks.ttk.utility.App;
import com.trollworks.ttk.utility.Fonts;
import com.trollworks.ttk.utility.LocalizedMessages;
import com.trollworks.ttk.utility.Platform;
import com.trollworks.ttk.utility.SafeFileUpdater;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;

public class Preferences {
    private static String MSG_UNINITIALIZED;
    private static final String VERSION_KEY = "Version";
    private static final String DOT = ".";
    private static Preferences INSTANCE;
    private boolean mDirty;
    private Properties mPrefs;
    private File mFile;
    private Notifier mNotifier;

    public static synchronized Preferences getInstance() {
        if (INSTANCE == null) {
            throw new RuntimeException(MSG_UNINITIALIZED);
        }
        return INSTANCE;
    }

    public static synchronized void setPreferenceFile(File file) {
        if (INSTANCE == null) {
            INSTANCE = new Preferences(file);
        }
    }

    public static synchronized void setPreferenceFile(String string) {
        Preferences.setPreferenceFile(Preferences.getDefaultPreferenceFile(string));
    }

    public static synchronized void setPreferenceFile(String string, String string2) {
        Preferences.setPreferenceFile(Preferences.getDefaultPreferenceFile(string, string2));
    }

    public static File getDefaultPreferenceFile(String string) {
        return Preferences.getDefaultPreferenceFile(null, string);
    }

    public static File getDefaultPreferenceFile(String string, String string2) {
        File file = new File(System.getProperty("user.home", DOT));
        if (Platform.isMacintosh()) {
            file = new File(file, "Library/Preferences");
        } else if (Platform.isWindows()) {
            file = new File(file, "Local Settings/Application Data");
        } else if (string != null) {
            if (!string.startsWith(DOT)) {
                string = DOT + string;
            }
        } else if (!string2.startsWith(DOT)) {
            string2 = DOT + string2;
        }
        if (string != null) {
            file = new File(file, string);
        }
        file.mkdirs();
        return new File(file, string2);
    }

    public static String getModuleKey(String string, String string2) {
        return string + '.' + string2;
    }

    public Preferences(File file) {
        this.mFile = file;
        this.mPrefs = new Properties();
        this.mNotifier = new Notifier();
        if (this.mFile.exists()) {
            try {
                FileInputStream fileInputStream = new FileInputStream(this.mFile);
                this.mPrefs.loadFromXML(fileInputStream);
                ((InputStream)fileInputStream).close();
            }
            catch (Exception exception) {
                this.mPrefs = new Properties();
            }
        }
    }

    public File getFile() {
        return this.mFile;
    }

    public Notifier getNotifier() {
        return this.mNotifier;
    }

    public void startBatch() {
        this.mNotifier.startBatch();
    }

    public void endBatch() {
        this.mNotifier.endBatch();
    }

    public void dispose(boolean bl) {
        if (bl) {
            this.save();
        }
        if (INSTANCE != this) {
            this.mPrefs = null;
            this.mFile = null;
            this.mNotifier = null;
        }
    }

    public boolean getBooleanValue(String string, String string2) {
        return this.getBooleanValue(string, string2, false);
    }

    public boolean getBooleanValue(String string, String string2, boolean bl) {
        String string3 = this.getStringValueForced(string, string2);
        if (Boolean.TRUE.toString().equals(string3)) {
            return true;
        }
        if (Boolean.FALSE.toString().equals(string3)) {
            return false;
        }
        return bl;
    }

    public Dimension getDimensionValue(String string, String string2) {
        return this.getDimensionValue(string, string2, null);
    }

    public Dimension getDimensionValue(String string, String string2, Dimension dimension) {
        Dimension dimension2 = Conversion.extractDimension(this.getStringValue(string, string2));
        return dimension2 == null ? dimension : dimension2;
    }

    public double getDoubleValue(String string, String string2, double d) {
        return this.getDoubleValue(string, string2, d, -1.7976931348623157E308, Double.MAX_VALUE);
    }

    public double getDoubleValue(String string, String string2, double d, double d2, double d3) {
        String string3 = this.getStringValue(string, string2);
        double d4 = d;
        if (string3 != null) {
            try {
                d4 = Double.parseDouble(string3);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (d4 < d2) {
            d4 = d2;
        }
        if (d4 > d3) {
            d4 = d3;
        }
        return d4;
    }

    public float getFloatValue(String string, String string2, float f) {
        return this.getFloatValue(string, string2, f, -3.4028235E38f, Float.MAX_VALUE);
    }

    public float getFloatValue(String string, String string2, float f, float f2, float f3) {
        String string3 = this.getStringValue(string, string2);
        float f4 = f;
        if (string3 != null) {
            try {
                f4 = Float.parseFloat(string3);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (f4 < f2) {
            f4 = f2;
        }
        if (f4 > f3) {
            f4 = f3;
        }
        return f4;
    }

    public Font getFontValue(String string, String string2) {
        String string3 = this.getStringValue(string, string2);
        return string3 == null ? null : Fonts.create(string3);
    }

    public Font getFontValue(String string, String string2, Font font) {
        return Fonts.create(this.getStringValue(string, string2), font);
    }

    public int getIntValue(String string, String string2, int n) {
        return this.getIntValue(string, string2, n, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public int getIntValue(String string, String string2, int n, int n2, int n3) {
        String string3 = this.getStringValue(string, string2);
        int n4 = n;
        if (string3 != null) {
            try {
                n4 = Integer.parseInt(string3);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (n4 < n2) {
            n4 = n2;
        }
        if (n4 > n3) {
            n4 = n3;
        }
        return n4;
    }

    public long getLongValue(String string, String string2, long l) {
        return this.getLongValue(string, string2, l, Long.MIN_VALUE, Long.MAX_VALUE);
    }

    public long getLongValue(String string, String string2, long l, long l2, long l3) {
        String string3 = this.getStringValue(string, string2);
        long l4 = l;
        if (string3 != null) {
            try {
                l4 = Long.parseLong(string3);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (l4 < l2) {
            l4 = l2;
        }
        if (l4 > l3) {
            l4 = l3;
        }
        return l4;
    }

    public List<String> getModuleKeys(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Enumeration<Object> enumeration = this.mPrefs.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string2.startsWith(string) || (string2 = string2.substring(string2.indexOf(46) + 1)) == null || string2.length() <= 0) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    public Point getPointValue(String string, String string2) {
        return this.getPointValue(string, string2, null);
    }

    public Point getPointValue(String string, String string2, Point point) {
        Point point2 = Conversion.extractPoint(this.getStringValue(string, string2));
        return point2 == null ? point : point2;
    }

    public String getStringValue(String string, String string2) {
        return this.mPrefs.getProperty(Preferences.getModuleKey(string, string2));
    }

    public String getStringValue(String string, String string2, String string3) {
        String string4 = this.getStringValue(string, string2);
        return string4 == null ? string3 : string4;
    }

    public String getStringValueForced(String string, String string2) {
        return this.getStringValue(string, string2, "");
    }

    public int getVersion(String string) {
        return this.getIntValue(string, VERSION_KEY, 1);
    }

    public boolean hasPreferences(String string) {
        string = string + '.';
        Enumeration<Object> enumeration = this.mPrefs.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string2.startsWith(string)) continue;
            return true;
        }
        return false;
    }

    public void removePreference(String string, String string2) {
        this.setValue(string, string2, (String)null);
    }

    public void removePreferences(String string) {
        String string2 = string + '.';
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = string2.length();
        Enumeration<Object> enumeration = this.mPrefs.keys();
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            if (!string3.startsWith(string2)) continue;
            arrayList.add(string3.substring(n));
        }
        if (!arrayList.isEmpty()) {
            this.startBatch();
            this.mDirty = true;
            for (String string3 : arrayList) {
                this.removePreference(string, string3);
            }
            this.endBatch();
        }
    }

    public void resetIfVersionMisMatch(String string, int n) {
        if (this.getVersion(string) != n) {
            this.startBatch();
            this.removePreferences(string);
            this.setVersion(string, n);
            this.endBatch();
        }
    }

    public boolean save() {
        if (this.mDirty) {
            try {
                SafeFileUpdater safeFileUpdater = new SafeFileUpdater();
                safeFileUpdater.begin();
                try {
                    File file = safeFileUpdater.getTransactionFile(this.mFile);
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                    this.mPrefs.storeToXML(fileOutputStream, App.getName());
                    ((OutputStream)fileOutputStream).close();
                }
                catch (IOException iOException) {
                    safeFileUpdater.abort();
                    throw iOException;
                }
                safeFileUpdater.commit();
                this.mDirty = false;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return true;
    }

    public void setValue(String string, String string2, boolean bl) {
        this.setValue(string, string2, new Boolean(bl).toString());
    }

    public void setValue(String string, String string2, String string3) {
        string2 = Preferences.getModuleKey(string, string2);
        if (string3 != null) {
            if (!string3.equals(this.mPrefs.getProperty(string2))) {
                this.mPrefs.setProperty(string2, string3);
                this.mDirty = true;
                this.mNotifier.notify(this, string2, string3);
            }
        } else if (this.mPrefs.getProperty(string2) != null) {
            this.mPrefs.remove(string2);
            this.mDirty = true;
            this.mNotifier.notify(this, string2, null);
        }
    }

    public void setValue(String string, String string2, Dimension dimension) {
        this.setValue(string, string2, dimension != null ? Conversion.createString(dimension) : null);
    }

    public void setValue(String string, String string2, Font font) {
        this.setValue(string, string2, font != null ? Fonts.getStringValue(font) : null);
    }

    public void setValue(String string, String string2, int n) {
        this.setValue(string, string2, Integer.toString(n));
    }

    public void setValue(String string, String string2, long l) {
        this.setValue(string, string2, Long.toString(l));
    }

    public void setValue(String string, String string2, double d) {
        this.setValue(string, string2, Double.toString(d));
    }

    public void setValue(String string, String string2, float f) {
        this.setValue(string, string2, Float.toString(f));
    }

    public void setValue(String string, String string2, Point point) {
        this.setValue(string, string2, point != null ? Conversion.createString(point) : null);
    }

    public void setVersion(String string, int n) {
        this.setValue(string, VERSION_KEY, n);
    }

    static {
        INSTANCE = null;
        LocalizedMessages.initialize(Preferences.class);
    }
}

