/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.print;

import com.trollworks.ttk.utility.LocalizedMessages;
import java.awt.print.PageFormat;
import javax.print.attribute.standard.OrientationRequested;

public enum PageOrientation {
    PORTRAIT{

        @Override
        public OrientationRequested getOrientationRequested() {
            return OrientationRequested.PORTRAIT;
        }

        public String toString() {
            return MSG_PORTRAIT;
        }
    }
    ,
    LANDSCAPE{

        @Override
        public OrientationRequested getOrientationRequested() {
            return OrientationRequested.LANDSCAPE;
        }

        public String toString() {
            return MSG_LANDSCAPE;
        }
    }
    ,
    REVERSE_PORTRAIT{

        @Override
        public OrientationRequested getOrientationRequested() {
            return OrientationRequested.REVERSE_PORTRAIT;
        }

        public String toString() {
            return MSG_REVERSE_PORTRAIT;
        }
    }
    ,
    REVERSE_LANDSCAPE{

        @Override
        public OrientationRequested getOrientationRequested() {
            return OrientationRequested.REVERSE_LANDSCAPE;
        }

        public String toString() {
            return MSG_REVERSE_LANDSCAPE;
        }
    };

    static String MSG_LANDSCAPE;
    static String MSG_PORTRAIT;
    static String MSG_REVERSE_LANDSCAPE;
    static String MSG_REVERSE_PORTRAIT;

    public abstract OrientationRequested getOrientationRequested();

    public static final PageOrientation get(OrientationRequested orientationRequested) {
        for (PageOrientation pageOrientation : PageOrientation.values()) {
            if (pageOrientation.getOrientationRequested() != orientationRequested) continue;
            return pageOrientation;
        }
        return PORTRAIT;
    }

    public static final PageOrientation get(PageFormat pageFormat) {
        switch (pageFormat.getOrientation()) {
            case 0: {
                return LANDSCAPE;
            }
            case 2: {
                return REVERSE_LANDSCAPE;
            }
        }
        return PORTRAIT;
    }

    static {
        LocalizedMessages.initialize(PageOrientation.class);
    }
}

