/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.print;

import com.trollworks.ttk.layout.Alignment;
import com.trollworks.ttk.layout.FlexColumn;
import com.trollworks.ttk.layout.FlexComponent;
import com.trollworks.ttk.layout.FlexGrid;
import com.trollworks.ttk.print.DummyPrintService;
import com.trollworks.ttk.print.InkChromaticity;
import com.trollworks.ttk.print.ObjectWrapper;
import com.trollworks.ttk.print.PageOrientation;
import com.trollworks.ttk.print.PageSides;
import com.trollworks.ttk.print.PrintUtilities;
import com.trollworks.ttk.print.Quality;
import com.trollworks.ttk.text.DoubleFormatter;
import com.trollworks.ttk.units.LengthUnits;
import com.trollworks.ttk.utility.GraphicsUtilities;
import com.trollworks.ttk.utility.LocalizedMessages;
import com.trollworks.ttk.utility.UIUtilities;
import com.trollworks.ttk.widgets.CommitEnforcer;
import com.trollworks.ttk.widgets.EditorField;
import com.trollworks.ttk.widgets.LinkedLabel;
import com.trollworks.ttk.widgets.WindowUtils;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PrinterJob;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.StringTokenizer;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Chromaticity;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.NumberUp;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.PrintQuality;
import javax.print.attribute.standard.PrinterResolution;
import javax.print.attribute.standard.Sides;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.text.DefaultFormatterFactory;

public class PageSetupPanel
extends JPanel
implements ActionListener {
    private static String MSG_PRINTER;
    private static String MSG_PAPER_TYPE;
    private static String MSG_ORIENTATION;
    private static String MSG_SIDES;
    private static String MSG_NUMBER_UP;
    private static String MSG_CHROMATICITY;
    private static String MSG_QUALITY;
    private static String MSG_RESOLUTION;
    private static String MSG_DPI;
    private static String MSG_MARGINS;
    private static String MSG_INCHES;
    private PrintService mService;
    private JComboBox mServices;
    private JComboBox mOrientation;
    private JComboBox mPaperType;
    private EditorField mTopMargin;
    private EditorField mLeftMargin;
    private EditorField mRightMargin;
    private EditorField mBottomMargin;
    private JComboBox mChromaticity;
    private JComboBox mSides;
    private JComboBox mNumberUp;
    private JComboBox mPrintQuality;
    private JComboBox mResolution;

    public PageSetupPanel(PrintService printService, PrintRequestAttributeSet printRequestAttributeSet) {
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.rebuild(printService, printRequestAttributeSet);
    }

    public PrintService getService() {
        return this.mService;
    }

    private void rebuild(PrintService printService, PrintRequestAttributeSet printRequestAttributeSet) {
        this.removeAll();
        this.mService = printService;
        FlexGrid flexGrid = new FlexGrid();
        int n = this.createPrinterCombo(flexGrid, 0);
        this.rebuildSelf(printRequestAttributeSet, flexGrid, n);
        flexGrid.apply(this);
        this.revalidate();
        Window window = WindowUtils.getWindowForComponent(this);
        if (window != null) {
            window.setSize(window.getPreferredSize());
            GraphicsUtilities.forceOnScreen(window);
        }
    }

    protected void rebuildSelf(PrintRequestAttributeSet printRequestAttributeSet, FlexGrid flexGrid, int n) {
        n = this.createPaperTypeCombo(printRequestAttributeSet, flexGrid, n);
        n = this.createOrientationCombo(printRequestAttributeSet, flexGrid, n);
        n = this.createSidesCombo(printRequestAttributeSet, flexGrid, n);
        n = this.createNumberUpCombo(printRequestAttributeSet, flexGrid, n);
        n = this.createChromaticityCombo(printRequestAttributeSet, flexGrid, n);
        n = this.createPrintQualityCombo(printRequestAttributeSet, flexGrid, n);
        n = this.createResolutionCombo(printRequestAttributeSet, flexGrid, n);
        n = this.createMarginFields(printRequestAttributeSet, flexGrid, n);
    }

    private int createPrinterCombo(FlexGrid flexGrid, int n) {
        PrintService[] printServiceArray = PrinterJob.lookupPrintServices();
        if (printServiceArray.length == 0) {
            printServiceArray = new PrintService[]{new DummyPrintService()};
        }
        ObjectWrapper[] objectWrapperArray = new ObjectWrapper[printServiceArray.length];
        int n2 = 0;
        for (int i = 0; i < printServiceArray.length; ++i) {
            objectWrapperArray[i] = new ObjectWrapper<PrintService>(printServiceArray[i].getName(), printServiceArray[i]);
            if (printServiceArray[i] != this.mService) continue;
            n2 = i;
        }
        this.mServices = new JComboBox<ObjectWrapper>(objectWrapperArray);
        this.mServices.setSelectedIndex(n2);
        UIUtilities.setOnlySize(this.mServices, this.mServices.getPreferredSize());
        this.mServices.addActionListener(this);
        this.mService = printServiceArray[n2];
        LinkedLabel linkedLabel = new LinkedLabel(MSG_PRINTER, (JComponent)this.mServices);
        this.add(linkedLabel);
        this.add(this.mServices);
        flexGrid.add(new FlexComponent(linkedLabel, Alignment.RIGHT_BOTTOM, Alignment.CENTER), n, 0);
        flexGrid.add(this.mServices, n, 1);
        return n + 1;
    }

    private int createPaperTypeCombo(PrintRequestAttributeSet printRequestAttributeSet, FlexGrid flexGrid, int n) {
        Media[] mediaArray = (Media[])this.mService.getSupportedAttributeValues(Media.class, DocFlavor.SERVICE_FORMATTED.PRINTABLE, null);
        if (mediaArray != null && mediaArray.length > 0) {
            Media media = PrintUtilities.getSetting(this.mService, printRequestAttributeSet, Media.class, true);
            if (media == null) {
                media = MediaSizeName.NA_LETTER;
            }
            ArrayList<ObjectWrapper<MediaSizeName>> arrayList = new ArrayList<ObjectWrapper<MediaSizeName>>();
            int n2 = 0;
            int n3 = 0;
            for (Media media2 : mediaArray) {
                if (!(media2 instanceof MediaSizeName)) continue;
                MediaSizeName mediaSizeName = (MediaSizeName)media2;
                arrayList.add(new ObjectWrapper<MediaSizeName>(this.cleanUpMediaSizeName(mediaSizeName), mediaSizeName));
                if (mediaSizeName == media) {
                    n2 = n3;
                }
                ++n3;
            }
            this.mPaperType = new JComboBox<Object>(arrayList.toArray());
            this.mPaperType.setSelectedIndex(n2);
            UIUtilities.setOnlySize(this.mPaperType, this.mPaperType.getPreferredSize());
            LinkedLabel linkedLabel = new LinkedLabel(MSG_PAPER_TYPE, (JComponent)this.mPaperType);
            this.add(linkedLabel);
            this.add(this.mPaperType);
            flexGrid.add(new FlexComponent(linkedLabel, Alignment.RIGHT_BOTTOM, Alignment.CENTER), n, 0);
            flexGrid.add(this.mPaperType, n, 1);
            return n + 1;
        }
        this.mPaperType = null;
        return n;
    }

    private String cleanUpMediaSizeName(MediaSizeName mediaSizeName) {
        StringBuilder stringBuilder = new StringBuilder();
        StringTokenizer stringTokenizer = new StringTokenizer(mediaSizeName.toString(), "- ", true);
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            if (string.equalsIgnoreCase("na")) {
                stringBuilder.append("US");
                continue;
            }
            if (string.equalsIgnoreCase("iso")) {
                stringBuilder.append("ISO");
                continue;
            }
            if (string.equalsIgnoreCase("jis")) {
                stringBuilder.append("JIS");
                continue;
            }
            if (string.equals("-")) {
                stringBuilder.append(" ");
                continue;
            }
            if (string.length() > 1) {
                stringBuilder.append(Character.toUpperCase(string.charAt(0)));
                stringBuilder.append(string.substring(1));
                continue;
            }
            stringBuilder.append(string.toUpperCase());
        }
        return stringBuilder.toString();
    }

    private int createOrientationCombo(PrintRequestAttributeSet printRequestAttributeSet, FlexGrid flexGrid, int n) {
        OrientationRequested[] orientationRequestedArray = (OrientationRequested[])this.mService.getSupportedAttributeValues(OrientationRequested.class, DocFlavor.SERVICE_FORMATTED.PRINTABLE, null);
        if (orientationRequestedArray != null && orientationRequestedArray.length > 0) {
            HashSet<OrientationRequested> hashSet = new HashSet<OrientationRequested>();
            for (OrientationRequested orientationRequested : orientationRequestedArray) {
                hashSet.add(orientationRequested);
            }
            ArrayList arrayList = new ArrayList();
            for (PageOrientation pageOrientation : PageOrientation.values()) {
                if (!hashSet.contains(pageOrientation.getOrientationRequested())) continue;
                arrayList.add(pageOrientation);
            }
            this.mOrientation = new JComboBox<Object>(arrayList.toArray());
            this.mOrientation.setSelectedItem((Object)PrintUtilities.getPageOrientation(this.mService, printRequestAttributeSet));
            UIUtilities.setOnlySize(this.mOrientation, this.mOrientation.getPreferredSize());
            LinkedLabel linkedLabel = new LinkedLabel(MSG_ORIENTATION, (JComponent)this.mOrientation);
            this.add(linkedLabel);
            this.add(this.mOrientation);
            flexGrid.add(new FlexComponent(linkedLabel, Alignment.RIGHT_BOTTOM, Alignment.CENTER), n, 0);
            flexGrid.add(this.mOrientation, n, 1);
            return n + 1;
        }
        this.mOrientation = null;
        return n;
    }

    private int createSidesCombo(PrintRequestAttributeSet printRequestAttributeSet, FlexGrid flexGrid, int n) {
        Sides[] sidesArray = (Sides[])this.mService.getSupportedAttributeValues(Sides.class, DocFlavor.SERVICE_FORMATTED.PRINTABLE, null);
        if (sidesArray != null && sidesArray.length > 0) {
            HashSet<Sides> hashSet = new HashSet<Sides>();
            for (Sides sides : sidesArray) {
                hashSet.add(sides);
            }
            ArrayList arrayList = new ArrayList();
            for (PageSides pageSides : PageSides.values()) {
                if (!hashSet.contains(pageSides.getSides())) continue;
                arrayList.add(pageSides);
            }
            this.mSides = new JComboBox<Object>(arrayList.toArray());
            this.mSides.setSelectedItem((Object)PrintUtilities.getSides(this.mService, printRequestAttributeSet));
            UIUtilities.setOnlySize(this.mSides, this.mSides.getPreferredSize());
            LinkedLabel linkedLabel = new LinkedLabel(MSG_SIDES, (JComponent)this.mSides);
            this.add(linkedLabel);
            this.add(this.mSides);
            flexGrid.add(new FlexComponent(linkedLabel, Alignment.RIGHT_BOTTOM, Alignment.CENTER), n, 0);
            flexGrid.add(this.mSides, n, 1);
            return n + 1;
        }
        this.mSides = null;
        return n;
    }

    private int createNumberUpCombo(PrintRequestAttributeSet printRequestAttributeSet, FlexGrid flexGrid, int n) {
        NumberUp[] numberUpArray = (NumberUp[])this.mService.getSupportedAttributeValues(NumberUp.class, DocFlavor.SERVICE_FORMATTED.PRINTABLE, null);
        if (numberUpArray != null && numberUpArray.length > 0) {
            NumberUp numberUp = PrintUtilities.getNumberUp(this.mService, printRequestAttributeSet);
            ObjectWrapper[] objectWrapperArray = new ObjectWrapper[numberUpArray.length];
            int n2 = 0;
            for (int i = 0; i < numberUpArray.length; ++i) {
                objectWrapperArray[i] = new ObjectWrapper<NumberUp>(numberUpArray[i].toString(), numberUpArray[i]);
                if (numberUpArray[i] != numberUp) continue;
                n2 = i;
            }
            this.mNumberUp = new JComboBox<ObjectWrapper>(objectWrapperArray);
            this.mNumberUp.setSelectedIndex(n2);
            UIUtilities.setOnlySize(this.mNumberUp, this.mNumberUp.getPreferredSize());
            LinkedLabel linkedLabel = new LinkedLabel(MSG_NUMBER_UP, (JComponent)this.mNumberUp);
            this.add(linkedLabel);
            this.add(this.mNumberUp);
            flexGrid.add(new FlexComponent(linkedLabel, Alignment.RIGHT_BOTTOM, Alignment.CENTER), n, 0);
            flexGrid.add(this.mNumberUp, n, 1);
            return n + 1;
        }
        this.mNumberUp = null;
        return n;
    }

    private int createChromaticityCombo(PrintRequestAttributeSet printRequestAttributeSet, FlexGrid flexGrid, int n) {
        Chromaticity[] chromaticityArray = (Chromaticity[])this.mService.getSupportedAttributeValues(Chromaticity.class, DocFlavor.SERVICE_FORMATTED.PRINTABLE, null);
        if (chromaticityArray != null && chromaticityArray.length > 0) {
            HashSet<Chromaticity> hashSet = new HashSet<Chromaticity>();
            for (Chromaticity chromaticity : chromaticityArray) {
                hashSet.add(chromaticity);
            }
            ArrayList arrayList = new ArrayList();
            for (InkChromaticity inkChromaticity : InkChromaticity.values()) {
                if (!hashSet.contains(inkChromaticity.getChromaticity())) continue;
                arrayList.add(inkChromaticity);
            }
            this.mChromaticity = new JComboBox<Object>(arrayList.toArray());
            this.mChromaticity.setSelectedItem((Object)PrintUtilities.getChromaticity(this.mService, printRequestAttributeSet, true));
            UIUtilities.setOnlySize(this.mChromaticity, this.mChromaticity.getPreferredSize());
            LinkedLabel linkedLabel = new LinkedLabel(MSG_CHROMATICITY, (JComponent)this.mChromaticity);
            this.add(linkedLabel);
            this.add(this.mChromaticity);
            flexGrid.add(new FlexComponent(linkedLabel, Alignment.RIGHT_BOTTOM, Alignment.CENTER), n, 0);
            flexGrid.add(this.mChromaticity, n, 1);
            return n + 1;
        }
        this.mChromaticity = null;
        return n;
    }

    private int createPrintQualityCombo(PrintRequestAttributeSet printRequestAttributeSet, FlexGrid flexGrid, int n) {
        PrintQuality[] printQualityArray = (PrintQuality[])this.mService.getSupportedAttributeValues(PrintQuality.class, DocFlavor.SERVICE_FORMATTED.PRINTABLE, null);
        if (printQualityArray != null && printQualityArray.length > 0) {
            HashSet<PrintQuality> hashSet = new HashSet<PrintQuality>();
            for (PrintQuality printQuality : printQualityArray) {
                hashSet.add(printQuality);
            }
            ArrayList arrayList = new ArrayList();
            for (Quality quality : Quality.values()) {
                if (!hashSet.contains(quality.getPrintQuality())) continue;
                arrayList.add(quality);
            }
            this.mPrintQuality = new JComboBox<Object>(arrayList.toArray());
            this.mPrintQuality.setSelectedItem((Object)PrintUtilities.getPrintQuality(this.mService, printRequestAttributeSet, true));
            UIUtilities.setOnlySize(this.mPrintQuality, this.mPrintQuality.getPreferredSize());
            LinkedLabel linkedLabel = new LinkedLabel(MSG_QUALITY, (JComponent)this.mPrintQuality);
            this.add(linkedLabel);
            this.add(this.mPrintQuality);
            flexGrid.add(new FlexComponent(linkedLabel, Alignment.RIGHT_BOTTOM, Alignment.CENTER), n, 0);
            flexGrid.add(this.mPrintQuality, n, 1);
            return n + 1;
        }
        this.mPrintQuality = null;
        return n;
    }

    private int createResolutionCombo(PrintRequestAttributeSet printRequestAttributeSet, FlexGrid flexGrid, int n) {
        PrinterResolution[] printerResolutionArray = (PrinterResolution[])this.mService.getSupportedAttributeValues(PrinterResolution.class, DocFlavor.SERVICE_FORMATTED.PRINTABLE, null);
        if (printerResolutionArray != null && printerResolutionArray.length > 0) {
            PrinterResolution printerResolution = PrintUtilities.getResolution(this.mService, printRequestAttributeSet, true);
            ObjectWrapper[] objectWrapperArray = new ObjectWrapper[printerResolutionArray.length];
            int n2 = 0;
            for (int i = 0; i < printerResolutionArray.length; ++i) {
                objectWrapperArray[i] = new ObjectWrapper<PrinterResolution>(this.generateResolutionTitle(printerResolutionArray[i]), printerResolutionArray[i]);
                if (printerResolutionArray[i] != printerResolution) continue;
                n2 = i;
            }
            this.mResolution = new JComboBox<ObjectWrapper>(objectWrapperArray);
            this.mResolution.setSelectedIndex(n2);
            UIUtilities.setOnlySize(this.mResolution, this.mResolution.getPreferredSize());
            LinkedLabel linkedLabel = new LinkedLabel(MSG_RESOLUTION, (JComponent)this.mResolution);
            this.add(linkedLabel);
            this.add(this.mResolution);
            flexGrid.add(new FlexComponent(linkedLabel, Alignment.RIGHT_BOTTOM, Alignment.CENTER), n, 0);
            flexGrid.add(this.mResolution, n, 1);
            return n + 1;
        }
        this.mResolution = null;
        return n;
    }

    private String generateResolutionTitle(PrinterResolution printerResolution) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = printerResolution.getCrossFeedResolution(100);
        int n2 = printerResolution.getFeedResolution(100);
        stringBuilder.append(Integer.toString(n));
        if (n != n2) {
            stringBuilder.append(" x ");
            stringBuilder.append(Integer.toString(n2));
        }
        stringBuilder.append(MSG_DPI);
        return stringBuilder.toString();
    }

    private int createMarginFields(PrintRequestAttributeSet printRequestAttributeSet, FlexGrid flexGrid, int n) {
        FlexColumn flexColumn = new FlexColumn();
        flexColumn.setFill(false);
        flexColumn.setVerticalAlignment(Alignment.CENTER);
        JLabel jLabel = new JLabel(MSG_MARGINS, 4);
        this.add(jLabel);
        flexColumn.add(new FlexComponent(jLabel, Alignment.RIGHT_BOTTOM, Alignment.CENTER));
        jLabel = new JLabel(MSG_INCHES, 4);
        this.add(jLabel);
        flexColumn.add(new FlexComponent(jLabel, Alignment.RIGHT_BOTTOM, Alignment.CENTER));
        flexGrid.add(flexColumn, n, 0);
        FlexGrid flexGrid2 = new FlexGrid();
        flexGrid.add(flexGrid2, n++, 1);
        double[] dArray = PrintUtilities.getPageMargins(this.mService, printRequestAttributeSet, LengthUnits.INCHES);
        this.mTopMargin = this.createMarginField(dArray[0]);
        flexGrid2.add(this.mTopMargin, 0, 1);
        this.mLeftMargin = this.createMarginField(dArray[1]);
        flexGrid2.add(this.mLeftMargin, 1, 0);
        this.mRightMargin = this.createMarginField(dArray[3]);
        flexGrid2.add(this.mRightMargin, 1, 2);
        this.mBottomMargin = this.createMarginField(dArray[2]);
        flexGrid2.add(this.mBottomMargin, 2, 1);
        return n;
    }

    private EditorField createMarginField(double d) {
        EditorField editorField = new EditorField(new DefaultFormatterFactory(new DoubleFormatter(0.0, 999.999, false)), null, 4, new Double(d), new Double(999.999), null);
        UIUtilities.setOnlySize(editorField, editorField.getPreferredSize());
        this.add(editorField);
        return editorField;
    }

    public PrintService accept(PrintRequestAttributeSet printRequestAttributeSet) {
        CommitEnforcer.forceFocusToAccept();
        this.mService = (PrintService)((ObjectWrapper)this.mServices.getSelectedItem()).getObject();
        if (this.mOrientation != null) {
            PrintUtilities.setPageOrientation(printRequestAttributeSet, (PageOrientation)((Object)this.mOrientation.getSelectedItem()));
        }
        if (this.mPaperType != null) {
            PrintUtilities.setPaperSize(this.mService, printRequestAttributeSet, PrintUtilities.getMediaDimensions((Media)((ObjectWrapper)this.mPaperType.getSelectedItem()).getObject(), LengthUnits.INCHES), LengthUnits.INCHES);
        }
        PrintUtilities.setPageMargins(this.mService, printRequestAttributeSet, new double[]{(Double)this.mTopMargin.getValue(), (Double)this.mLeftMargin.getValue(), (Double)this.mBottomMargin.getValue(), (Double)this.mRightMargin.getValue()}, LengthUnits.INCHES);
        if (this.mChromaticity != null) {
            PrintUtilities.setChromaticity(printRequestAttributeSet, (InkChromaticity)((Object)this.mChromaticity.getSelectedItem()));
        }
        if (this.mSides != null) {
            PrintUtilities.setSides(printRequestAttributeSet, (PageSides)((Object)this.mSides.getSelectedItem()));
        }
        if (this.mNumberUp != null) {
            PrintUtilities.setNumberUp(printRequestAttributeSet, (NumberUp)((ObjectWrapper)this.mNumberUp.getSelectedItem()).getObject());
        }
        if (this.mPrintQuality != null) {
            PrintUtilities.setPrintQuality(printRequestAttributeSet, (Quality)((Object)this.mPrintQuality.getSelectedItem()));
        }
        if (this.mResolution != null) {
            PrintUtilities.setResolution(printRequestAttributeSet, (PrinterResolution)((ObjectWrapper)this.mResolution.getSelectedItem()).getObject());
        }
        return this.mService instanceof DummyPrintService ? null : this.mService;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.mServices) {
            HashPrintRequestAttributeSet hashPrintRequestAttributeSet = new HashPrintRequestAttributeSet();
            this.rebuild(this.accept(hashPrintRequestAttributeSet), hashPrintRequestAttributeSet);
        }
    }

    static {
        LocalizedMessages.initialize(PageSetupPanel.class);
    }
}

