/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.print;

import com.trollworks.ttk.print.InkChromaticity;
import com.trollworks.ttk.print.PageOrientation;
import com.trollworks.ttk.print.PageSides;
import com.trollworks.ttk.print.Quality;
import com.trollworks.ttk.units.LengthUnits;
import javax.print.PrintService;
import javax.print.attribute.Attribute;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Chromaticity;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.NumberUp;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.PageRanges;
import javax.print.attribute.standard.PrintQuality;
import javax.print.attribute.standard.PrinterResolution;
import javax.print.attribute.standard.Sides;

public class PrintUtilities {
    public static <T extends Attribute> T getSetting(PrintService printService, PrintRequestAttributeSet printRequestAttributeSet, Class<T> clazz, boolean bl) {
        Attribute attribute = printRequestAttributeSet.get(clazz);
        if (bl && attribute == null && printService != null) {
            attribute = (Attribute)printService.getDefaultAttributeValue(clazz);
        }
        return (T)attribute;
    }

    public static PageOrientation getPageOrientation(PrintService printService, PrintRequestAttributeSet printRequestAttributeSet) {
        return PageOrientation.get(PrintUtilities.getSetting(printService, printRequestAttributeSet, OrientationRequested.class, true));
    }

    public static void setPageOrientation(PrintRequestAttributeSet printRequestAttributeSet, PageOrientation pageOrientation) {
        printRequestAttributeSet.add(pageOrientation.getOrientationRequested());
    }

    public static double[] getPaperMargins(PrintService printService, PrintRequestAttributeSet printRequestAttributeSet, LengthUnits lengthUnits) {
        double[] dArray = PrintUtilities.getPaperSize(printService, printRequestAttributeSet, LengthUnits.INCHES);
        MediaPrintableArea mediaPrintableArea = PrintUtilities.getSetting(printService, printRequestAttributeSet, MediaPrintableArea.class, true);
        if (mediaPrintableArea == null) {
            mediaPrintableArea = new MediaPrintableArea(0.5f, 0.5f, (float)(dArray[0] - 1.0), (float)(dArray[1] - 1.0), 25400);
        }
        double d = mediaPrintableArea.getX(25400);
        double d2 = mediaPrintableArea.getY(25400);
        return new double[]{lengthUnits.convert(LengthUnits.INCHES, d2), lengthUnits.convert(LengthUnits.INCHES, d), lengthUnits.convert(LengthUnits.INCHES, dArray[1] - (d2 + (double)mediaPrintableArea.getHeight(25400))), lengthUnits.convert(LengthUnits.INCHES, dArray[0] - (d + (double)mediaPrintableArea.getWidth(25400)))};
    }

    public static void setPaperMargins(PrintService printService, PrintRequestAttributeSet printRequestAttributeSet, double[] dArray, LengthUnits lengthUnits) {
        double[] dArray2 = PrintUtilities.getPaperSize(printService, printRequestAttributeSet, lengthUnits);
        printRequestAttributeSet.add(new MediaPrintableArea((float)LengthUnits.INCHES.convert(lengthUnits, dArray[1]), (float)LengthUnits.INCHES.convert(lengthUnits, dArray[0]), (float)LengthUnits.INCHES.convert(lengthUnits, dArray2[0] - (dArray[1] + dArray[3])), (float)LengthUnits.INCHES.convert(lengthUnits, dArray2[1] - (dArray[0] + dArray[2])), 25400));
    }

    public static double[] getPageMargins(PrintService printService, PrintRequestAttributeSet printRequestAttributeSet, LengthUnits lengthUnits) {
        PageOrientation pageOrientation = PrintUtilities.getPageOrientation(printService, printRequestAttributeSet);
        double[] dArray = PrintUtilities.getPaperMargins(printService, printRequestAttributeSet, lengthUnits);
        if (pageOrientation == PageOrientation.LANDSCAPE) {
            return new double[]{dArray[1], dArray[2], dArray[3], dArray[0]};
        }
        if (pageOrientation == PageOrientation.REVERSE_PORTRAIT) {
            return new double[]{dArray[2], dArray[3], dArray[0], dArray[1]};
        }
        if (pageOrientation == PageOrientation.REVERSE_LANDSCAPE) {
            return new double[]{dArray[3], dArray[0], dArray[1], dArray[2]};
        }
        return dArray;
    }

    public static void setPageMargins(PrintService printService, PrintRequestAttributeSet printRequestAttributeSet, double[] dArray, LengthUnits lengthUnits) {
        PageOrientation pageOrientation = PrintUtilities.getPageOrientation(printService, printRequestAttributeSet);
        if (pageOrientation == PageOrientation.LANDSCAPE) {
            PrintUtilities.setPaperMargins(printService, printRequestAttributeSet, new double[]{dArray[3], dArray[0], dArray[1], dArray[2]}, lengthUnits);
        } else if (pageOrientation == PageOrientation.REVERSE_PORTRAIT) {
            PrintUtilities.setPaperMargins(printService, printRequestAttributeSet, new double[]{dArray[2], dArray[3], dArray[0], dArray[1]}, lengthUnits);
        } else if (pageOrientation == PageOrientation.REVERSE_LANDSCAPE) {
            PrintUtilities.setPaperMargins(printService, printRequestAttributeSet, new double[]{dArray[1], dArray[2], dArray[3], dArray[0]}, lengthUnits);
        } else {
            PrintUtilities.setPaperMargins(printService, printRequestAttributeSet, dArray, lengthUnits);
        }
    }

    public static double[] getPaperSize(PrintService printService, PrintRequestAttributeSet printRequestAttributeSet, LengthUnits lengthUnits) {
        return PrintUtilities.getMediaDimensions(PrintUtilities.getSetting(printService, printRequestAttributeSet, Media.class, true), lengthUnits);
    }

    public static double[] getMediaDimensions(Media media, LengthUnits lengthUnits) {
        MediaSize mediaSize;
        MediaSize mediaSize2 = mediaSize = media instanceof MediaSizeName ? MediaSize.getMediaSizeForName((MediaSizeName)media) : null;
        if (mediaSize == null) {
            mediaSize = MediaSize.NA.LETTER;
        }
        return new double[]{lengthUnits.convert(LengthUnits.INCHES, mediaSize.getX(25400)), lengthUnits.convert(LengthUnits.INCHES, mediaSize.getY(25400))};
    }

    public static void setPaperSize(PrintService printService, PrintRequestAttributeSet printRequestAttributeSet, double[] dArray, LengthUnits lengthUnits) {
        double[] dArray2 = PrintUtilities.getPaperMargins(printService, printRequestAttributeSet, lengthUnits);
        MediaSizeName mediaSizeName = MediaSize.findMedia((float)LengthUnits.INCHES.convert(lengthUnits, dArray[0]), (float)LengthUnits.INCHES.convert(lengthUnits, dArray[1]), 25400);
        if (mediaSizeName == null) {
            mediaSizeName = MediaSizeName.NA_LETTER;
        }
        printRequestAttributeSet.add(mediaSizeName);
        PrintUtilities.setPaperMargins(printService, printRequestAttributeSet, dArray2, lengthUnits);
    }

    public static double[] getPageSize(PrintService printService, PrintRequestAttributeSet printRequestAttributeSet, LengthUnits lengthUnits) {
        PageOrientation pageOrientation = PrintUtilities.getPageOrientation(printService, printRequestAttributeSet);
        double[] dArray = PrintUtilities.getPaperSize(printService, printRequestAttributeSet, lengthUnits);
        if (pageOrientation == PageOrientation.LANDSCAPE || pageOrientation == PageOrientation.REVERSE_LANDSCAPE) {
            double d = dArray[0];
            dArray[0] = dArray[1];
            dArray[1] = d;
        }
        return dArray;
    }

    public static void setPageSize(PrintService printService, PrintRequestAttributeSet printRequestAttributeSet, double[] dArray, LengthUnits lengthUnits) {
        PageOrientation pageOrientation = PrintUtilities.getPageOrientation(printService, printRequestAttributeSet);
        if (pageOrientation == PageOrientation.LANDSCAPE || pageOrientation == PageOrientation.REVERSE_LANDSCAPE) {
            dArray = new double[]{dArray[1], dArray[0]};
        }
        PrintUtilities.setPaperSize(printService, printRequestAttributeSet, dArray, lengthUnits);
    }

    public static InkChromaticity getChromaticity(PrintService printService, PrintRequestAttributeSet printRequestAttributeSet, boolean bl) {
        return InkChromaticity.get(PrintUtilities.getSetting(printService, printRequestAttributeSet, Chromaticity.class, bl));
    }

    public static void setChromaticity(PrintRequestAttributeSet printRequestAttributeSet, InkChromaticity inkChromaticity) {
        printRequestAttributeSet.add(inkChromaticity.getChromaticity());
    }

    public static PageSides getSides(PrintService printService, PrintRequestAttributeSet printRequestAttributeSet) {
        return PageSides.get(PrintUtilities.getSetting(printService, printRequestAttributeSet, Sides.class, true));
    }

    public static void setSides(PrintRequestAttributeSet printRequestAttributeSet, PageSides pageSides) {
        printRequestAttributeSet.add(pageSides.getSides());
    }

    public static Quality getPrintQuality(PrintService printService, PrintRequestAttributeSet printRequestAttributeSet, boolean bl) {
        return Quality.get(PrintUtilities.getSetting(printService, printRequestAttributeSet, PrintQuality.class, bl));
    }

    public static void setPrintQuality(PrintRequestAttributeSet printRequestAttributeSet, Quality quality) {
        printRequestAttributeSet.add(quality.getPrintQuality());
    }

    public static int getCopies(PrintService printService, PrintRequestAttributeSet printRequestAttributeSet) {
        Copies copies = PrintUtilities.getSetting(printService, printRequestAttributeSet, Copies.class, false);
        return copies == null ? 1 : copies.getValue();
    }

    public static void setCopies(PrintRequestAttributeSet printRequestAttributeSet, int n) {
        printRequestAttributeSet.add(new Copies(Math.min(Math.max(n, 1), 999)));
    }

    public static NumberUp getNumberUp(PrintService printService, PrintRequestAttributeSet printRequestAttributeSet) {
        return PrintUtilities.getSetting(printService, printRequestAttributeSet, NumberUp.class, false);
    }

    public static void setNumberUp(PrintRequestAttributeSet printRequestAttributeSet, NumberUp numberUp) {
        printRequestAttributeSet.add(numberUp);
    }

    public static PageRanges getPageRanges(PrintService printService, PrintRequestAttributeSet printRequestAttributeSet) {
        return PrintUtilities.getSetting(printService, printRequestAttributeSet, PageRanges.class, false);
    }

    public static void setPageRanges(PrintRequestAttributeSet printRequestAttributeSet, PageRanges pageRanges) {
        if (pageRanges != null) {
            printRequestAttributeSet.add(pageRanges);
        } else {
            printRequestAttributeSet.remove(PageRanges.class);
        }
    }

    public static PrinterResolution getResolution(PrintService printService, PrintRequestAttributeSet printRequestAttributeSet, boolean bl) {
        return PrintUtilities.getSetting(printService, printRequestAttributeSet, PrinterResolution.class, bl);
    }

    public static void setResolution(PrintRequestAttributeSet printRequestAttributeSet, PrinterResolution printerResolution) {
        if (printerResolution != null) {
            printRequestAttributeSet.add(printerResolution);
        } else {
            printRequestAttributeSet.remove(PrinterResolution.class);
        }
    }
}

