/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.print;

import com.trollworks.ttk.utility.LocalizedMessages;
import javax.print.attribute.standard.PrintQuality;

public enum Quality {
    HIGH{

        @Override
        public PrintQuality getPrintQuality() {
            return PrintQuality.HIGH;
        }

        public String toString() {
            return MSG_HIGH;
        }
    }
    ,
    NORMAL{

        @Override
        public PrintQuality getPrintQuality() {
            return PrintQuality.NORMAL;
        }

        public String toString() {
            return MSG_NORMAL;
        }
    }
    ,
    DRAFT{

        @Override
        public PrintQuality getPrintQuality() {
            return PrintQuality.DRAFT;
        }

        public String toString() {
            return MSG_DRAFT;
        }
    };

    static String MSG_HIGH;
    static String MSG_NORMAL;
    static String MSG_DRAFT;

    public abstract PrintQuality getPrintQuality();

    public static final Quality get(PrintQuality printQuality) {
        for (Quality quality : Quality.values()) {
            if (quality.getPrintQuality() != printQuality) continue;
            return quality;
        }
        return NORMAL;
    }

    static {
        LocalizedMessages.initialize(Quality.class);
    }
}

