/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.text;

import com.trollworks.ttk.text.Numbers;
import java.text.ParseException;
import javax.swing.JFormattedTextField;

public class DoubleFormatter
extends JFormattedTextField.AbstractFormatter {
    private double mMinValue;
    private double mMaxValue;
    private boolean mForceSign;

    public DoubleFormatter(double d, double d2, boolean bl) {
        this.mMinValue = d;
        this.mMaxValue = d2;
        this.mForceSign = bl;
    }

    @Override
    public Object stringToValue(String string) throws ParseException {
        return new Double(Math.min(Math.max(Numbers.getLocalizedDouble(string, this.mMinValue <= 0.0 && this.mMaxValue >= 0.0 ? 0.0 : this.mMinValue), this.mMinValue), this.mMaxValue));
    }

    @Override
    public String valueToString(Object object) throws ParseException {
        double d = (Double)object;
        return this.mForceSign ? Numbers.formatWithForcedSign(d) : Numbers.format(d);
    }
}

