/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.text;

import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import javax.swing.JTextField;

public class NumberFilter
implements KeyListener {
    private static final char GROUP_CHAR;
    private static final char DECIMAL_CHAR;
    private JTextField mField;
    private boolean mIsHeightFilter;
    private boolean mAllowDecimal;
    private boolean mAllowSign;
    private boolean mAllowGroup;
    private int mMaxDigits;

    public NumberFilter(JTextField jTextField) {
        this(jTextField, false, false, false, Integer.MAX_VALUE);
        this.mIsHeightFilter = true;
    }

    public NumberFilter(JTextField jTextField, boolean bl, boolean bl2) {
        this(jTextField, bl, bl2, true, Integer.MAX_VALUE);
    }

    public NumberFilter(JTextField jTextField, boolean bl, boolean bl2, boolean bl3) {
        this(jTextField, bl, bl2, bl3, Integer.MAX_VALUE);
    }

    public NumberFilter(JTextField jTextField, boolean bl, boolean bl2, int n) {
        this(jTextField, bl, bl2, true, n);
    }

    public NumberFilter(JTextField jTextField, boolean bl, boolean bl2, boolean bl3, int n) {
        this.mField = jTextField;
        this.mAllowDecimal = bl;
        this.mAllowSign = bl2;
        this.mAllowGroup = bl3;
        this.mMaxDigits = n;
        for (KeyListener keyListener : this.mField.getKeyListeners()) {
            if (!(keyListener instanceof NumberFilter)) continue;
            this.mField.removeKeyListener(keyListener);
        }
        this.mField.addKeyListener(this);
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        if (c != '\n' && c != '\r' && c != '\t' && c != '\b' && c != '\u007f') {
            if (this.mAllowGroup && c == GROUP_CHAR || c >= '0' && c <= '9' || this.mAllowSign && (c == '-' || c == '+') || this.mAllowDecimal && c == DECIMAL_CHAR || this.mIsHeightFilter && (c == '\'' || c == '\"' || c == ' ')) {
                int n;
                StringBuilder stringBuilder = new StringBuilder(this.mField.getText());
                int n2 = this.mField.getSelectionStart();
                if (n2 != (n = this.mField.getSelectionEnd())) {
                    stringBuilder.delete(n2, n);
                }
                if (c >= '0' && c <= '9') {
                    int n3 = stringBuilder.length();
                    int n4 = 0;
                    for (int i = 0; i < n3; ++i) {
                        char c2 = stringBuilder.charAt(i);
                        if (c2 < '0' || c > '9') continue;
                        ++n4;
                    }
                    if (n4 >= this.mMaxDigits) {
                        this.filter(keyEvent);
                        return;
                    }
                }
                if (c == GROUP_CHAR || c >= '0' && c <= '9') {
                    if (this.mAllowSign && n2 == 0 && stringBuilder.length() > 0 && (stringBuilder.charAt(0) == '-' || stringBuilder.charAt(0) == '+')) {
                        this.filter(keyEvent);
                    }
                } else if (c == '-' || c == '+') {
                    if (n2 != 0) {
                        this.filter(keyEvent);
                    }
                } else if (c == DECIMAL_CHAR) {
                    if (stringBuilder.indexOf("" + DECIMAL_CHAR) != -1 || this.mAllowSign && n2 == 0 && stringBuilder.length() > 0 && (stringBuilder.charAt(0) == '-' || stringBuilder.charAt(0) == '+')) {
                        this.filter(keyEvent);
                    }
                } else if (c == '\'') {
                    if (stringBuilder.indexOf("'") != -1) {
                        this.filter(keyEvent);
                    }
                } else if (c == '\"' && stringBuilder.indexOf("\"") != -1) {
                    this.filter(keyEvent);
                }
            } else {
                this.filter(keyEvent);
            }
        }
    }

    private void filter(KeyEvent keyEvent) {
        Toolkit.getDefaultToolkit().beep();
        keyEvent.consume();
    }

    static {
        DecimalFormatSymbols decimalFormatSymbols = ((DecimalFormat)NumberFormat.getNumberInstance()).getDecimalFormatSymbols();
        GROUP_CHAR = decimalFormatSymbols.getGroupingSeparator();
        DECIMAL_CHAR = decimalFormatSymbols.getDecimalSeparator();
    }
}

