/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.text;

import com.trollworks.ttk.text.Numbers;
import java.io.InputStream;
import javax.xml.stream.Location;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class XMLParser {
    private static final String SEPARATOR = "\u0000";
    private XMLStreamReader mReader;
    private int mDepth;
    private String mMarker;

    public XMLParser(InputStream inputStream) throws XMLStreamException {
        XMLInputFactory xMLInputFactory = XMLInputFactory.newInstance();
        xMLInputFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
        this.mReader = xMLInputFactory.createXMLStreamReader(inputStream);
    }

    public Location getLocation() {
        return this.mReader.getLocation();
    }

    public String getLocationAsString() {
        Location location = this.mReader.getLocation();
        return location.getLineNumber() + ":" + location.getColumnNumber();
    }

    public String getMarker() {
        return this.mMarker;
    }

    public String getCurrentTag() {
        return this.mReader.getLocalName();
    }

    public String nextTag() throws XMLStreamException {
        return this.nextTag(null);
    }

    public String nextTag(String string) throws XMLStreamException {
        while (this.mReader.hasNext()) {
            switch (this.mReader.next()) {
                case 1: {
                    String string2 = this.mReader.getLocalName();
                    this.mMarker = this.mDepth++ + SEPARATOR + string2;
                    return string2;
                }
                case 2: {
                    this.mMarker = --this.mDepth + SEPARATOR + this.mReader.getLocalName();
                    if (string == null || !string.equals(this.mMarker)) break;
                    return null;
                }
                case 7: {
                    this.mMarker = null;
                    if (string == null) break;
                    return null;
                }
                case 8: {
                    this.mMarker = null;
                    return null;
                }
            }
        }
        return null;
    }

    public void skip() throws XMLStreamException {
        this.skip(this.getMarker());
    }

    public void skip(String string) throws XMLStreamException {
        while (this.nextTag(string) != null) {
        }
    }

    public boolean hasAttribute(String string) {
        return this.getAttribute(string) != null;
    }

    public String getAttribute(String string) {
        return this.mReader.getAttributeValue(null, string);
    }

    public String getAttribute(String string, String string2) {
        String string3 = this.getAttribute(string);
        return string3 != null ? string3 : string2;
    }

    public boolean isAttributeSet(String string) {
        return Numbers.getBoolean(this.getAttribute(string));
    }

    public boolean isAttributeSet(String string, boolean bl) {
        return Numbers.getBoolean(this.getAttribute(string, Boolean.toString(bl)));
    }

    public short getShortAttribute(String string) {
        return Numbers.getShort(this.getAttribute(string));
    }

    public short getShortAttribute(String string, short s) {
        return Numbers.getShort(this.getAttribute(string), s);
    }

    public short getShortAttribute(String string, short s, short s2, short s3) {
        return Numbers.getShort(this.getAttribute(string), s, s2, s3);
    }

    public short getShortAttribute(String string, int n, short s, short s2, short s3) {
        return Numbers.getShort(this.getAttribute(string), n, s, s2, s3);
    }

    public int getIntegerAttribute(String string) {
        return Numbers.getInteger(this.getAttribute(string));
    }

    public int getIntegerAttribute(String string, int n) {
        return Numbers.getInteger(this.getAttribute(string), n);
    }

    public int getIntegerAttribute(String string, int n, int n2, int n3) {
        return Numbers.getInteger(this.getAttribute(string), n, n2, n3);
    }

    public int getIntegerAttribute(String string, int n, int n2, int n3, int n4) {
        return Numbers.getInteger(this.getAttribute(string), n, n2, n3, n4);
    }

    public long getLongAttribute(String string) {
        return Numbers.getLong(this.getAttribute(string));
    }

    public long getLongAttribute(String string, long l) {
        return Numbers.getLong(this.getAttribute(string), l);
    }

    public long getLongAttribute(String string, long l, long l2, long l3) {
        return Numbers.getLong(this.getAttribute(string), l, l2, l3);
    }

    public long getLongAttribute(String string, int n, long l, long l2, long l3) {
        return Numbers.getLong(this.getAttribute(string), n, l, l2, l3);
    }

    public float getFloatAttribute(String string) {
        return Numbers.getFloat(this.getAttribute(string));
    }

    public float getFloatAttribute(String string, float f) {
        return Numbers.getFloat(this.getAttribute(string), f);
    }

    public float getFloatAttribute(String string, float f, float f2, float f3) {
        return Numbers.getFloat(this.getAttribute(string), f, f2, f3);
    }

    public double getDoubleAttribute(String string) {
        return Numbers.getDouble(this.getAttribute(string));
    }

    public double getDoubleAttribute(String string, double d) {
        return Numbers.getDouble(this.getAttribute(string), d);
    }

    public double getDoubleAttribute(String string, double d, double d2, double d3) {
        return Numbers.getDouble(this.getAttribute(string), d, d2, d3);
    }

    public int getAttributeCount() {
        return this.mReader.getAttributeCount();
    }

    public String getAttributeName(int n) {
        return this.mReader.getAttributeLocalName(n);
    }

    public String getAttributeValue(int n) {
        return this.mReader.getAttributeValue(n);
    }

    public String getText() throws XMLStreamException {
        String string = this.mReader.getElementText();
        this.mMarker = --this.mDepth + SEPARATOR + this.mReader.getLocalName();
        return string;
    }

    public void close() throws XMLStreamException {
        this.mReader.close();
        this.mReader = null;
    }
}

