/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.units;

import com.trollworks.ttk.text.Numbers;
import com.trollworks.ttk.units.Units;
import com.trollworks.ttk.utility.LocalizedMessages;
import java.text.MessageFormat;

public enum LengthUnits implements Units
{
    POINTS(0.013888888888888888){

        public String toString() {
            return MSG_POINTS_ABBREVIATION;
        }

        @Override
        public String getDescription() {
            return MSG_POINTS;
        }
    }
    ,
    INCHES(1.0){

        public String toString() {
            return MSG_INCHES_ABBREVIATION;
        }

        @Override
        public String getDescription() {
            return MSG_INCHES;
        }
    }
    ,
    FEET(12.0){

        public String toString() {
            return MSG_FEET_ABBREVIATION;
        }

        @Override
        public String getDescription() {
            return MSG_FEET;
        }
    }
    ,
    FEET_AND_INCHES(1.0){

        public String toString() {
            return "'";
        }

        @Override
        public String getDescription() {
            return MSG_FEET_AND_INCHES;
        }

        @Override
        public String format(double d, boolean bl) {
            int n = (int)(Math.floor(d) / 12.0);
            d -= 12.0 * (double)n;
            if (n > 0) {
                String string = this.formatNumber(n, bl) + '\'';
                if (d > 0.0) {
                    return string + ' ' + this.formatNumber(d, bl) + '\"';
                }
                return string;
            }
            return this.formatNumber(d, bl) + '\"';
        }

        private String formatNumber(double d, boolean bl) {
            return Numbers.trimTrailingZerosAfterDecimal(bl ? Numbers.format(d) : Double.toString(d));
        }
    }
    ,
    YARDS(36.0){

        public String toString() {
            return MSG_YARDS_ABBREVIATION;
        }

        @Override
        public String getDescription() {
            return MSG_YARDS;
        }
    }
    ,
    MILES(63360.0){

        public String toString() {
            return MSG_MILES_ABBREVIATION;
        }

        @Override
        public String getDescription() {
            return MSG_MILES;
        }
    }
    ,
    MILLIMETERS(0.03937007874015748){

        public String toString() {
            return MSG_MILLIMETERS_ABBREVIATION;
        }

        @Override
        public String getDescription() {
            return MSG_MILLIMETERS;
        }
    }
    ,
    CENTIMETERS(0.39370078740157477){

        public String toString() {
            return MSG_CENTIMETERS_ABBREVIATION;
        }

        @Override
        public String getDescription() {
            return MSG_CENTIMETERS;
        }
    }
    ,
    KILOMETERS(39370.07874015748){

        public String toString() {
            return MSG_KILOMETERS_ABBREVIATION;
        }

        @Override
        public String getDescription() {
            return MSG_KILOMETERS;
        }
    }
    ,
    METERS(39.37007874015748){

        public String toString() {
            return MSG_METERS_ABBREVIATION;
        }

        @Override
        public String getDescription() {
            return MSG_METERS;
        }
    };

    static String MSG_POINTS;
    static String MSG_POINTS_ABBREVIATION;
    static String MSG_INCHES;
    static String MSG_INCHES_ABBREVIATION;
    static String MSG_FEET;
    static String MSG_FEET_ABBREVIATION;
    static String MSG_FEET_AND_INCHES;
    static String MSG_YARDS;
    static String MSG_YARDS_ABBREVIATION;
    static String MSG_MILES;
    static String MSG_MILES_ABBREVIATION;
    static String MSG_MILLIMETERS;
    static String MSG_MILLIMETERS_ABBREVIATION;
    static String MSG_CENTIMETERS;
    static String MSG_CENTIMETERS_ABBREVIATION;
    static String MSG_KILOMETERS;
    static String MSG_KILOMETERS_ABBREVIATION;
    static String MSG_METERS;
    static String MSG_METERS_ABBREVIATION;
    static String MSG_FORMAT;
    private double mFactor;

    private LengthUnits(double d) {
        this.mFactor = d;
    }

    @Override
    public double convert(Units units, double d) {
        return d * units.getFactor() / this.mFactor;
    }

    @Override
    public double normalize(double d) {
        return d / this.mFactor;
    }

    @Override
    public double getFactor() {
        return this.mFactor;
    }

    @Override
    public String format(double d, boolean bl) {
        String string = bl ? Numbers.format(d) : Double.toString(d);
        return MessageFormat.format(MSG_FORMAT, Numbers.trimTrailingZerosAfterDecimal(string), this.toString());
    }

    @Override
    public Units[] getCompatibleUnits() {
        return LengthUnits.values();
    }

    static {
        LocalizedMessages.initialize(LengthUnits.class);
    }
}

