/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.utility;

import com.trollworks.ttk.cmdline.CmdLine;
import com.trollworks.ttk.menu.Command;
import com.trollworks.ttk.menu.edit.PreferencesCommand;
import com.trollworks.ttk.menu.file.OpenDataFileCommand;
import com.trollworks.ttk.menu.file.PrintCommand;
import com.trollworks.ttk.menu.file.QuitCommand;
import com.trollworks.ttk.menu.help.AboutCommand;
import com.trollworks.ttk.utility.LaunchProxy;
import com.trollworks.ttk.utility.LocalizedMessages;
import com.trollworks.ttk.utility.Path;
import com.trollworks.ttk.utility.Platform;
import com.trollworks.ttk.widgets.AppWindow;
import java.awt.EventQueue;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.KeyEvent;
import java.io.File;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.BitSet;
import javax.swing.JPanel;

public class App
implements KeyEventDispatcher,
Runnable,
InvocationHandler {
    private static String MSG_LONG_VERSION_FORMAT;
    private static String MSG_COPYRIGHT_FORMAT;
    public static final File APP_HOME_DIR;
    private static String NAME;
    private static String VERSION;
    private static String APP_COPYRIGHT_YEARS;
    private static String APP_COPYRIGHT_OWNER;
    private static boolean NOTIFICATION_ALLOWED;
    private static Class<? extends JPanel> ABOUT_PANEL_CLASS;
    private static BitSet KEY_STATE;
    private boolean mHasStarted;

    protected App() {
        if (Platform.isMacintosh()) {
            try {
                ClassLoader classLoader = this.getClass().getClassLoader();
                Class<?> clazz = classLoader.loadClass("com.apple.eawt.ApplicationListener");
                Class<?> clazz2 = classLoader.loadClass("com.apple.eawt.Application");
                Method method = clazz2.getMethod("addApplicationListener", clazz);
                Method method2 = clazz2.getMethod("getApplication", new Class[0]);
                Object object = Proxy.newProxyInstance(classLoader, new Class[]{clazz}, (InvocationHandler)this);
                method.invoke(method2.invoke(null, new Object[0]), object);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) {
        try {
            Object object2 = objectArray[0];
            String string = method.getName();
            if ("handleAbout".equals(string)) {
                this.handleCommand(AboutCommand.INSTANCE);
                this.setHandled(object2, true);
            } else if ("handleOpenFile".equals(string)) {
                OpenDataFileCommand.open(new File(this.getFilename(object2)));
                this.setHandled(object2, true);
            } else if ("handlePreferences".equals(string)) {
                this.handleCommand(PreferencesCommand.INSTANCE);
                this.setHandled(object2, true);
            } else if ("handlePrintFile".equals(string)) {
                final File file = new File(this.getFilename(object2));
                OpenDataFileCommand.open(file);
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AppWindow appWindow = AppWindow.findWindow(file);
                        if (appWindow != null) {
                            PrintCommand.INSTANCE.print(appWindow);
                        } else {
                            EventQueue.invokeLater(this);
                        }
                    }
                });
                this.setHandled(object2, true);
            } else if ("handleQuit".equals(string)) {
                this.handleCommand(QuitCommand.INSTANCE);
                this.setHandled(object2, false);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return null;
    }

    private void handleCommand(Command command) {
        command.adjustForMenu(null);
        if (command.isEnabled()) {
            command.actionPerformed(null);
        }
    }

    private void setHandled(Object object, boolean bl) throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Class<?> clazz = this.getClass().getClassLoader().loadClass("com.apple.eawt.ApplicationEvent");
        Method method = clazz.getMethod("setHandled", Boolean.TYPE);
        method.invoke(object, bl);
    }

    private String getFilename(Object object) throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Class<?> clazz = this.getClass().getClassLoader().loadClass("com.apple.eawt.ApplicationEvent");
        Method method = clazz.getMethod("getFilename", new Class[0]);
        String string = (String)method.invoke(object, new Object[0]);
        System.out.println(string);
        return string;
    }

    public final void startup(CmdLine cmdLine) {
        if (this.mHasStarted) {
            System.err.println(this.getClass().getSimpleName() + ".startup(...) may only be called once.");
        } else {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this);
            this.configureApplication(cmdLine);
            LaunchProxy.getInstance().setReady(true);
            if (Platform.isMacintosh()) {
                try {
                    Class<?> clazz = this.getClass().getClassLoader().loadClass("com.apple.eawt.Application");
                    Object object = clazz.getMethod("getApplication", new Class[0]).invoke(null, new Object[0]);
                    clazz.getMethod("setEnabledAboutMenu", Boolean.TYPE).invoke(object, Boolean.TRUE);
                    clazz.getMethod("setEnabledPreferencesMenu", Boolean.TYPE).invoke(object, Boolean.TRUE);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            for (File file : cmdLine.getArgumentsAsFiles()) {
                OpenDataFileCommand.open(file);
            }
            EventQueue.invokeLater(this);
        }
    }

    public void configureApplication(CmdLine cmdLine) {
    }

    @Override
    public final synchronized void run() {
        OpenDataFileCommand.enablePassThrough();
        if (AppWindow.getAllWindows().isEmpty()) {
            this.noWindowsAreOpenAtStartup(false);
            if (AppWindow.getAllWindows().isEmpty()) {
                this.noWindowsAreOpenAtStartup(true);
            }
        }
        this.finalStartup();
        App.setNotificationAllowed(true);
    }

    public void noWindowsAreOpenAtStartup(boolean bl) {
    }

    public void finalStartup() {
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getID() == 401) {
            KEY_STATE.set(keyEvent.getKeyCode());
        } else if (keyEvent.getID() == 402) {
            KEY_STATE.clear(keyEvent.getKeyCode());
        }
        return false;
    }

    public static boolean isKeyPressed(int n) {
        return KEY_STATE.get(n);
    }

    public static String getName() {
        return NAME;
    }

    public static void setName(String string) {
        NAME = string;
    }

    public static String getVersion() {
        return VERSION;
    }

    public static void setVersion(String string) {
        VERSION = string;
    }

    public static String getCopyrightYears() {
        return APP_COPYRIGHT_YEARS;
    }

    public static void setCopyrightYears(String string) {
        APP_COPYRIGHT_YEARS = string;
    }

    public static String getCopyrightOwner() {
        return APP_COPYRIGHT_OWNER;
    }

    public static void setCopyrightOwner(String string) {
        APP_COPYRIGHT_OWNER = string;
    }

    public static String getVersionBanner(boolean bl) {
        return MessageFormat.format(MSG_LONG_VERSION_FORMAT, App.getName(), App.getVersion(), App.getCopyrightBanner(bl));
    }

    public static String getCopyrightBanner(boolean bl) {
        String string = MessageFormat.format(MSG_COPYRIGHT_FORMAT, App.getCopyrightYears(), App.getCopyrightOwner());
        if (bl) {
            string = string.replaceAll("\\(c\\)", "\u00a9");
        }
        return string;
    }

    public static JPanel createAboutPanel() {
        if (ABOUT_PANEL_CLASS != null) {
            try {
                return ABOUT_PANEL_CLASS.newInstance();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return null;
    }

    public static void setAboutPanel(Class<? extends JPanel> clazz) {
        ABOUT_PANEL_CLASS = clazz;
    }

    public static boolean isNotificationAllowed() {
        return NOTIFICATION_ALLOWED;
    }

    public static void setNotificationAllowed(boolean bl) {
        NOTIFICATION_ALLOWED = bl;
    }

    static {
        String string;
        block6: {
            NAME = "App";
            VERSION = "1";
            APP_COPYRIGHT_YEARS = "????";
            APP_COPYRIGHT_OWNER = "????";
            NOTIFICATION_ALLOWED = false;
            ABOUT_PANEL_CLASS = null;
            KEY_STATE = new BitSet();
            LocalizedMessages.initialize(App.class);
            try {
                String string2 = "/com/trollworks/LaunchConfig.properties";
                string = Path.normalizeFullPath(App.class.getResource(string2).getPath());
                string = string.substring(0, string.length() - string2.length());
                String string3 = "/build";
                if (string.endsWith(string3)) {
                    string = string.substring(0, string.length() - string3.length());
                }
                if (!string.endsWith("!")) break block6;
                string = string.substring(0, string.length() - 1);
                try {
                    File file = new File(new URI(string));
                    file = file.getParentFile();
                    string = Path.getFullPath(file);
                    if (string.endsWith("/Contents/Resources/Java")) {
                        string = Path.getFullPath(file.getParentFile().getParentFile().getParentFile().getParentFile());
                    }
                }
                catch (URISyntaxException uRISyntaxException) {
                    uRISyntaxException.printStackTrace();
                }
            }
            catch (Throwable throwable) {
                string = ".";
            }
        }
        APP_HOME_DIR = new File(string).getAbsoluteFile();
    }
}

