/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.utility;

import java.util.Random;

public class Dice
implements Cloneable {
    public static final String DISPLAY_D6 = "com.trollworks.ttk.Dice.DisplayD6";
    public static final String USE_OPTIONAL_GURPS_DICE_ADDS = "com.trollworks.ttk.Dice.OptionalGURPSDiceAdds";
    private static final Random RANDOM = new Random();
    private int mCount;
    private int mSides;
    private int mModifier;
    private int mMultiplier;
    private int mAltCount;
    private int mAltModifier;

    public Dice() {
        this(1, 6, 0, 1);
    }

    public Dice(String string) {
        StringBuilder stringBuilder = new StringBuilder(string.trim().toLowerCase());
        this.mCount = this.extractValue(stringBuilder);
        char c = this.nextChar(stringBuilder);
        if (c == 'd') {
            stringBuilder.deleteCharAt(0);
            this.mSides = this.extractValue(stringBuilder);
            if (this.mSides == 0) {
                this.mSides = 6;
            }
            c = this.nextChar(stringBuilder);
        }
        if (c == '+' || c == '-') {
            boolean bl = c == '-';
            stringBuilder.deleteCharAt(0);
            this.mModifier = this.extractValue(stringBuilder);
            if (bl) {
                this.mModifier = -this.mModifier;
            }
            c = this.nextChar(stringBuilder);
        }
        if (c == 'x') {
            stringBuilder.deleteCharAt(0);
            this.mMultiplier = this.extractValue(stringBuilder);
        }
        if (this.mMultiplier == 0) {
            this.mMultiplier = 1;
        }
        if (this.mCount != 0 && this.mSides == 0 && this.mModifier == 0) {
            this.mModifier = this.mCount;
            this.mCount = 0;
        }
    }

    public static int[] extractDicePosition(String string) {
        int n = -1;
        int n2 = string.length();
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            switch (n3) {
                case 0: {
                    if (c >= '0' && c <= '9') {
                        if (n != -1) break;
                        n = i;
                        break;
                    }
                    if (c == ' ') break;
                    if (c == 'd') {
                        n3 = 1;
                        break;
                    }
                    if (c != '+' && c != '-') break;
                    n3 = 2;
                    break;
                }
                case 1: {
                    if (c == ' ' || c >= '0' && c <= '9') break;
                    if (c == '+' || c == '-') {
                        n3 = 2;
                        break;
                    }
                    if (c == 'x') {
                        n3 = 3;
                        break;
                    }
                    n3 = 4;
                    break;
                }
                case 2: {
                    if (c >= '0' && c <= '9' || c == ' ') break;
                    if (c == 'x') {
                        n3 = 3;
                        break;
                    }
                    n3 = 4;
                    break;
                }
                case 3: {
                    if (c >= '0' && c <= '9' || c == ' ') break;
                    n3 = 4;
                }
            }
            if (n3 != 4) continue;
            n2 = i;
            break;
        }
        if (n != -1) {
            while (n < n2 && string.charAt(n) == ' ') {
                ++n;
            }
            --n2;
            while (n2 > n && string.charAt(n2) == ' ') {
                --n2;
            }
            if (n < n2) {
                return new int[]{n, n2};
            }
        }
        return null;
    }

    private char nextChar(StringBuilder stringBuilder) {
        return stringBuilder.length() > 0 ? stringBuilder.charAt(0) : (char)'\u0000';
    }

    private int extractValue(StringBuilder stringBuilder) {
        int n = 0;
        while (stringBuilder.length() > 0) {
            char c = stringBuilder.charAt(0);
            if (c >= '0' && c <= '9') {
                n *= 10;
                n += c - 48;
            } else if (c != ' ') break;
            stringBuilder.deleteCharAt(0);
        }
        return n;
    }

    public Dice(int n) {
        this(n, 6, 0, 1);
    }

    public Dice(int n, int n2) {
        this(n, 6, n2, 1);
    }

    public Dice(int n, int n2, int n3) {
        this(n, 6, n2, n3);
    }

    public Dice(int n, int n2, int n3, int n4) {
        this.mCount = n;
        this.mSides = n2;
        this.mModifier = n3;
        this.mMultiplier = n4;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public void add(int n) {
        this.mModifier += n;
    }

    public void multiply(int n) {
        this.mCount *= n;
        this.mModifier *= n;
        if (this.mMultiplier != 1) {
            this.mMultiplier *= n;
        }
    }

    public int getDieCount() {
        return this.mCount;
    }

    public int roll() {
        int n = 0;
        this.updateAlt();
        for (int i = 0; i < this.mAltCount; ++i) {
            n += 1 + RANDOM.nextInt(this.mSides);
        }
        return (n + this.mAltModifier) * this.mMultiplier;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.updateAlt();
        if (this.mAltCount > 0 && this.mSides > 0) {
            stringBuilder.append(this.mAltCount);
            stringBuilder.append('d');
            if (this.mSides != 6 || System.getProperty(DISPLAY_D6) != null) {
                stringBuilder.append(this.mSides);
            }
        }
        if (this.mAltModifier > 0) {
            stringBuilder.append('+');
            stringBuilder.append(this.mAltModifier);
        } else if (this.mAltModifier < 0) {
            stringBuilder.append(this.mAltModifier);
        }
        if (this.mMultiplier != 1) {
            stringBuilder.append('x');
            stringBuilder.append(this.mMultiplier);
        }
        if (stringBuilder.length() == 0) {
            stringBuilder.append('0');
        }
        return stringBuilder.toString();
    }

    private void updateAlt() {
        this.mAltCount = this.mCount;
        this.mAltModifier = this.mModifier;
        if (System.getProperty(USE_OPTIONAL_GURPS_DICE_ADDS) != null) {
            while (this.mAltModifier > 3) {
                if (this.mAltModifier > 6) {
                    this.mAltModifier -= 7;
                    this.mAltCount += 2;
                    continue;
                }
                this.mAltModifier -= 4;
                ++this.mAltCount;
            }
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Dice) {
            Dice dice = (Dice)object;
            return this.mCount == dice.mCount && this.mSides == dice.mSides && this.mModifier == dice.mModifier && this.mMultiplier == dice.mMultiplier;
        }
        return false;
    }
}

