/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.utility;

import com.trollworks.ttk.utility.Geometry;
import com.trollworks.ttk.utility.LocalizedMessages;
import com.trollworks.ttk.utility.Platform;
import com.trollworks.ttk.utility.UIUtilities;
import com.trollworks.ttk.widgets.AppWindow;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.UIManager;

public class GraphicsUtilities {
    private static String MSG_HEADLESS;
    private static Frame HIDDEN_FRAME;
    private static BufferedImage HIDDEN_FRAME_ICON;
    private static boolean HEADLESS_PRINT_MODE;
    private static int HEADLESS_CHECK_RESULT;
    private static Object MAC_NSAPPLICATION;
    private static Method MAC_ACTIVATE_IGNORING_OTHER_APPS;
    private static boolean OK_TO_USE_FULLSCREEN_TRICK;

    public static boolean inHeadlessPrintMode() {
        return HEADLESS_PRINT_MODE;
    }

    public static void setHeadlessPrintMode(boolean bl) {
        HEADLESS_PRINT_MODE = bl;
    }

    public static GraphicsDevice getPreferredScreenDevice(Window window) {
        return GraphicsUtilities.getPreferredScreenDevice(window.getBounds());
    }

    public static GraphicsDevice getPreferredScreenDevice(Rectangle rectangle) {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
        Rectangle rectangle2 = Geometry.intersection(rectangle, graphicsDevice.getDefaultConfiguration().getBounds());
        int n = rectangle2.width * rectangle2.height;
        for (GraphicsDevice graphicsDevice2 : graphicsEnvironment.getScreenDevices()) {
            if (graphicsDevice2.getType() != 0) continue;
            rectangle2 = Geometry.intersection(rectangle, graphicsDevice2.getDefaultConfiguration().getBounds());
            if (rectangle2.width * rectangle2.height <= n) continue;
            graphicsDevice = graphicsDevice2;
        }
        return graphicsDevice;
    }

    public static Rectangle getLocalInsetBounds(JComponent jComponent) {
        Insets insets = jComponent.getInsets();
        return new Rectangle(insets.left, insets.top, jComponent.getWidth() - (insets.left + insets.right), jComponent.getHeight() - (insets.top + insets.bottom));
    }

    public static Rectangle getMaximumWindowBounds() {
        return GraphicsUtilities.getMaximumWindowBounds(GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getBounds());
    }

    public static Rectangle getMaximumWindowBounds(Window window) {
        return GraphicsUtilities.getMaximumWindowBounds(window.getBounds());
    }

    public static Rectangle getMaximumWindowBounds(Component component, Rectangle rectangle) {
        rectangle = new Rectangle(rectangle);
        UIUtilities.convertRectangleToScreen(rectangle, component);
        return GraphicsUtilities.getMaximumWindowBounds(rectangle);
    }

    public static Rectangle getMaximumWindowBounds(Rectangle rectangle) {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice graphicsDevice = GraphicsUtilities.getPreferredScreenDevice(rectangle);
        if (graphicsDevice == graphicsEnvironment.getDefaultScreenDevice()) {
            rectangle = graphicsEnvironment.getMaximumWindowBounds();
            if (!Platform.isMacintosh() && !Platform.isWindows()) {
                Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(graphicsDevice.getDefaultConfiguration());
                if (insets.top == 0 && insets.bottom == 0) {
                    insets.bottom = 48;
                }
                rectangle.x += insets.left;
                rectangle.y += insets.top;
                rectangle.width -= insets.left + insets.right;
                rectangle.height -= insets.top + insets.bottom;
            }
            return rectangle;
        }
        return graphicsDevice.getDefaultConfiguration().getBounds();
    }

    public static void forceOnScreen(Window window) {
        Rectangle rectangle = GraphicsUtilities.getMaximumWindowBounds(window);
        Rectangle rectangle2 = window.getBounds();
        Point point = new Point(rectangle2.x, rectangle2.y);
        Dimension dimension = window.getMinimumSize();
        if (rectangle2.width < dimension.width) {
            rectangle2.width = dimension.width;
        }
        if (rectangle2.height < dimension.height) {
            rectangle2.height = dimension.height;
        }
        if (rectangle2.x < rectangle.x) {
            rectangle2.x = rectangle.x;
        } else if (rectangle2.x >= rectangle.x + rectangle.width) {
            rectangle2.x = rectangle.x + rectangle.width - 1;
        }
        if (rectangle2.x + rectangle2.width >= rectangle.x + rectangle.width) {
            rectangle2.x = rectangle.x + rectangle.width - rectangle2.width;
            if (rectangle2.x < rectangle.x) {
                rectangle2.x = rectangle.x;
                rectangle2.width = rectangle.width;
            }
        }
        if (rectangle2.y < rectangle.y) {
            rectangle2.y = rectangle.y;
        } else if (rectangle2.y >= rectangle.y + rectangle.height) {
            rectangle2.y = rectangle.y + rectangle.height - 1;
        }
        if (rectangle2.y + rectangle2.height >= rectangle.y + rectangle.height) {
            rectangle2.y = rectangle.y + rectangle.height - rectangle2.height;
            if (rectangle2.y < rectangle.y) {
                rectangle2.y = rectangle.y;
                rectangle2.height = rectangle.height;
            }
        }
        if (point.x != rectangle2.x || point.y != rectangle2.y) {
            window.setBounds(rectangle2);
        } else {
            window.setSize(rectangle2.width, rectangle2.height);
        }
        window.validate();
    }

    public static void forceRepaint() {
        for (AppWindow appWindow : AppWindow.getAllWindows()) {
            appWindow.repaint();
        }
    }

    public static void forceRepaintAndInvalidate() {
        for (AppWindow appWindow : AppWindow.getAllWindows()) {
            appWindow.invalidate(appWindow.getRootPane());
        }
    }

    public static Graphics2D prepare(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        return graphics2D;
    }

    public static Graphics2D getGraphics() {
        Graphics2D graphics2D;
        AppWindow appWindow = AppWindow.getTopWindow();
        Graphics2D graphics2D2 = graphics2D = appWindow == null ? null : (Graphics2D)((Component)appWindow).getGraphics();
        if (graphics2D == null) {
            Frame[] frameArray = Frame.getFrames();
            for (Frame frame : frameArray) {
                if (!frame.isDisplayable() || (graphics2D = (Graphics2D)frame.getGraphics()) == null) continue;
                return graphics2D;
            }
            BufferedImage bufferedImage = new BufferedImage(32, 1, 2);
            return bufferedImage.createGraphics();
        }
        return GraphicsUtilities.prepare(graphics2D);
    }

    public static Frame getAnyFrame() {
        AppWindow appWindow = AppWindow.getTopWindow();
        if (appWindow == null) {
            Frame[] frameArray;
            for (Frame frame : frameArray = Frame.getFrames()) {
                if (!frame.isDisplayable()) continue;
                return frame;
            }
            return GraphicsUtilities.getHiddenFrame(true);
        }
        return appWindow;
    }

    public static void setOKToUseFullScreenTrick(boolean bl) {
        OK_TO_USE_FULLSCREEN_TRICK = bl;
    }

    public static void forceAppToFront() {
        Object object;
        Object object2;
        Object object3;
        boolean bl = true;
        if (Platform.isMacintosh()) {
            bl = false;
            try {
                if (MAC_NSAPPLICATION == null) {
                    object3 = new URLClassLoader(new URL[]{new File("/System/Library/Java/").toURI().toURL()});
                    object2 = Class.forName("com.apple.cocoa.application.NSApplication", true, (ClassLoader)object3);
                    object = ((Class)object2).getDeclaredMethod("sharedApplication", new Class[0]);
                    MAC_NSAPPLICATION = ((Method)object).invoke(null, new Object[0]);
                    MAC_ACTIVATE_IGNORING_OTHER_APPS = ((Class)object2).getDeclaredMethod("activateIgnoringOtherApps", Boolean.TYPE);
                }
                MAC_ACTIVATE_IGNORING_OTHER_APPS.invoke(MAC_NSAPPLICATION, Boolean.TRUE);
            }
            catch (Exception exception) {
                bl = true;
            }
        }
        if (bl && OK_TO_USE_FULLSCREEN_TRICK) {
            object3 = GraphicsEnvironment.getLocalGraphicsEnvironment();
            object2 = ((GraphicsEnvironment)object3).getDefaultScreenDevice();
            object = new AppWindow(null, null, null);
            ((Frame)object).setUndecorated(true);
            ((JFrame)object).getContentPane().setBackground(new Color(0, 0, 0, 0));
            ((GraphicsDevice)object2).setFullScreenWindow((Window)object);
            ((GraphicsDevice)object2).setFullScreenWindow(null);
            ((AppWindow)object).dispose();
        }
    }

    public static Frame getHiddenFrame(boolean bl) {
        BufferedImage bufferedImage;
        if (HIDDEN_FRAME == null) {
            if (!bl) {
                return null;
            }
            HIDDEN_FRAME = new Frame();
            HIDDEN_FRAME.setUndecorated(true);
            HIDDEN_FRAME.setBounds(0, 0, 0, 0);
        }
        if (HIDDEN_FRAME_ICON != (bufferedImage = AppWindow.getDefaultWindowIcon())) {
            HIDDEN_FRAME_ICON = bufferedImage;
            HIDDEN_FRAME.setIconImage(bufferedImage);
        }
        return HIDDEN_FRAME;
    }

    public static boolean areGraphicsSafeToUse() {
        if (!GraphicsEnvironment.isHeadless()) {
            if (HEADLESS_CHECK_RESULT == 0) {
                try {
                    GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
                    HEADLESS_CHECK_RESULT = 1;
                }
                catch (Error error) {
                    HEADLESS_CHECK_RESULT = 2;
                }
            }
            if (HEADLESS_CHECK_RESULT == 1) {
                return true;
            }
        }
        return false;
    }

    public static String getReasonForUnsafeGraphics() {
        return MSG_HEADLESS;
    }

    public static void configureStandardUI() {
        System.setProperty("apple.laf.useScreenMenuBar", Boolean.TRUE.toString());
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    static {
        HIDDEN_FRAME = null;
        HIDDEN_FRAME_ICON = null;
        HEADLESS_PRINT_MODE = false;
        HEADLESS_CHECK_RESULT = 0;
        MAC_NSAPPLICATION = null;
        MAC_ACTIVATE_IGNORING_OTHER_APPS = null;
        OK_TO_USE_FULLSCREEN_TRICK = true;
        LocalizedMessages.initialize(GraphicsUtilities.class);
    }
}

