/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.utility;

import java.util.Random;

public class UniqueID {
    private static final Random RANDOM = new Random();
    private long mTimeStamp;
    private final long mSubID;

    public UniqueID() {
        this(System.currentTimeMillis(), RANDOM.nextLong());
    }

    public UniqueID(String string) {
        long l;
        try {
            int n = string.indexOf(58);
            this.mTimeStamp = Long.parseLong(string.substring(0, n), 36);
            l = Long.parseLong(string.substring(n + 1), 36);
        }
        catch (Exception exception) {
            this.mTimeStamp = System.currentTimeMillis();
            l = RANDOM.nextLong();
        }
        this.mSubID = l;
    }

    public UniqueID(long l, long l2) {
        this.mTimeStamp = l;
        this.mSubID = l2;
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof UniqueID) {
            UniqueID uniqueID = (UniqueID)object;
            return this.mSubID == uniqueID.mSubID && this.mTimeStamp == uniqueID.mTimeStamp;
        }
        return false;
    }

    public final boolean subIDEquals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof UniqueID) {
            UniqueID uniqueID = (UniqueID)object;
            return this.mSubID == uniqueID.mSubID;
        }
        return false;
    }

    public final boolean subIDEqualsAndNewer(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof UniqueID) {
            UniqueID uniqueID = (UniqueID)object;
            return this.mSubID == uniqueID.mSubID && this.mTimeStamp < uniqueID.mTimeStamp;
        }
        return false;
    }

    public final int hashCode() {
        return (int)this.mSubID;
    }

    public final String toString() {
        return Long.toString(this.mTimeStamp, 36) + ":" + Long.toString(this.mSubID, 36);
    }

    public final long getSubID() {
        return this.mSubID;
    }

    public final long getTimeStamp() {
        return this.mTimeStamp;
    }

    public final void setTimeStamp(long l) {
        this.mTimeStamp = l;
    }
}

