/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.widgets;

import com.trollworks.ttk.collections.FilteredIterator;
import com.trollworks.ttk.layout.FlexRow;
import com.trollworks.ttk.menu.StdMenuBar;
import com.trollworks.ttk.menu.edit.Undoable;
import com.trollworks.ttk.menu.file.FileProxy;
import com.trollworks.ttk.menu.window.WindowMenu;
import com.trollworks.ttk.preferences.MenuKeyPreferences;
import com.trollworks.ttk.print.PageOrientation;
import com.trollworks.ttk.print.PrintManager;
import com.trollworks.ttk.undo.StdUndoManager;
import com.trollworks.ttk.units.LengthUnits;
import com.trollworks.ttk.utility.Path;
import com.trollworks.ttk.widgets.BaseWindow;
import com.trollworks.ttk.widgets.PaletteWindow;
import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.event.MouseWheelEvent;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JToolBar;

public class AppWindow
extends BaseWindow
implements Comparable<AppWindow>,
Undoable {
    private static BufferedImage DEFAULT_WINDOW_ICON = null;
    private static final ArrayList<AppWindow> WINDOW_LIST = new ArrayList();
    private BufferedImage mWindowIcon;
    private PrintManager mPrintManager;
    private StdUndoManager mUndoManager;
    private BufferedImage mTitleIcon;
    private boolean mIsPrinting;

    public static AppWindow getTopWindow() {
        if (!WINDOW_LIST.isEmpty()) {
            return WINDOW_LIST.get(0);
        }
        return null;
    }

    public AppWindow(String string, BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        this(string, bufferedImage, bufferedImage2, null, false);
    }

    public AppWindow(String string, BufferedImage bufferedImage, BufferedImage bufferedImage2, GraphicsConfiguration graphicsConfiguration, boolean bl) {
        super(string, graphicsConfiguration);
        if (bl) {
            this.setUndecorated(true);
        }
        if (!bl) {
            MenuKeyPreferences.loadFromPreferences();
            this.setJMenuBar(new StdMenuBar());
        }
        if (bufferedImage == null) {
            bufferedImage = DEFAULT_WINDOW_ICON;
        }
        if (bufferedImage != null) {
            this.setTitleIcon(bufferedImage);
        }
        if (bufferedImage2 == null) {
            bufferedImage2 = bufferedImage;
        }
        if (bufferedImage2 != null) {
            this.setMenuIcon(bufferedImage2);
        }
        this.mUndoManager = new StdUndoManager();
        this.enableEvents(24L);
        WINDOW_LIST.add(this);
    }

    protected final void createToolBar() {
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        FlexRow flexRow = new FlexRow();
        flexRow.setInsets(new Insets(2, 5, 2, 5));
        this.createToolBarContents(jToolBar, flexRow);
        flexRow.apply(jToolBar);
        this.add((Component)jToolBar, "North");
    }

    protected void createToolBarContents(JToolBar jToolBar, FlexRow flexRow) {
    }

    public static BufferedImage getDefaultWindowIcon() {
        return DEFAULT_WINDOW_ICON;
    }

    public static void setDefaultWindowIcon(BufferedImage bufferedImage) {
        DEFAULT_WINDOW_ICON = bufferedImage;
    }

    public void setTitleIcon(BufferedImage bufferedImage) {
        if (bufferedImage != this.mTitleIcon) {
            this.mTitleIcon = bufferedImage;
            this.setIconImage(this.mTitleIcon);
        }
    }

    public BufferedImage getTitleIcon() {
        return this.mTitleIcon;
    }

    public BufferedImage getMenuIcon() {
        return this.mWindowIcon;
    }

    public void setMenuIcon(BufferedImage bufferedImage) {
        this.mWindowIcon = bufferedImage;
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            WindowMenu.update();
        }
    }

    @Override
    public void setTitle(String string) {
        super.setTitle(string);
        if (this.isVisible()) {
            WindowMenu.update();
        }
    }

    @Override
    public void toFront() {
        if (!this.isClosed()) {
            if (this.getExtendedState() == 1) {
                this.setExtendedState(0);
            }
            super.toFront();
            if (!this.isActive() || !this.isFocused()) {
                Component component = this.getMostRecentFocusOwner();
                if (component != null) {
                    component.requestFocus();
                } else {
                    this.requestFocus();
                }
            }
        }
    }

    public final PrintManager getPrintManager() {
        if (this.mPrintManager == null) {
            this.mPrintManager = this.createPageSettings();
        }
        return this.mPrintManager;
    }

    public void setPrintManager(PrintManager printManager) {
        this.mPrintManager = printManager;
    }

    protected PrintManager createPageSettings() {
        try {
            return new PrintManager(PageOrientation.PORTRAIT, 0.5, LengthUnits.INCHES);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void adjustToPageSetupChanges() {
    }

    public boolean isPrinting() {
        return this.mIsPrinting;
    }

    public void setPrinting(boolean bl) {
        this.mIsPrinting = bl;
    }

    protected void processMouseWheelEventSuper(MouseWheelEvent mouseWheelEvent) {
        super.processMouseWheelEvent(mouseWheelEvent);
    }

    @Override
    public void dispose() {
        if (!this.isClosed()) {
            WINDOW_LIST.remove(this);
            if (WINDOW_LIST.isEmpty()) {
                for (PaletteWindow paletteWindow : AppWindow.getWindows(PaletteWindow.class)) {
                    paletteWindow.setAppWindow(null);
                }
            }
        }
        super.dispose();
        WindowMenu.update();
    }

    public static <T extends AppWindow> ArrayList<T> getActiveWindows(Class<T> clazz) {
        ArrayList<AppWindow> arrayList = new ArrayList<AppWindow>();
        for (AppWindow appWindow : new FilteredIterator<T>(WINDOW_LIST, clazz)) {
            if (!appWindow.isShowing()) continue;
            arrayList.add(appWindow);
        }
        return arrayList;
    }

    @Override
    public void windowGainedFocus(WindowEvent windowEvent) {
        if (windowEvent.getWindow() == this) {
            WINDOW_LIST.remove(this);
            WINDOW_LIST.add(0, this);
            for (PaletteWindow paletteWindow : AppWindow.getWindows(PaletteWindow.class)) {
                paletteWindow.setAppWindow(this);
            }
        }
        super.windowGainedFocus(windowEvent);
    }

    @Override
    public StdUndoManager getUndoManager() {
        return this.mUndoManager;
    }

    public static AppWindow findWindow(File file) {
        String string = Path.getFullPath(file);
        for (AppWindow appWindow : AppWindow.getAllWindows()) {
            File file2;
            if (!(appWindow instanceof FileProxy) || (file2 = ((FileProxy)((Object)appWindow)).getBackingFile()) == null || !Path.getFullPath(file2).equals(string)) continue;
            return appWindow;
        }
        return null;
    }

    public static ArrayList<AppWindow> getAllWindows() {
        return AppWindow.getWindows(AppWindow.class);
    }

    protected String getTitleForWindowMenu() {
        return this.getTitle();
    }

    @Override
    public int compareTo(AppWindow appWindow) {
        if (this != appWindow) {
            String string = this.getTitleForWindowMenu();
            String string2 = appWindow.getTitleForWindowMenu();
            if (string != null) {
                if (string2 == null) {
                    return 1;
                }
                return string.compareTo(string2);
            }
            if (string2 != null) {
                return -1;
            }
        }
        return 0;
    }
}

