/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.widgets;

import com.trollworks.ttk.layout.ColumnLayout;
import com.trollworks.ttk.layout.FlexGrid;
import com.trollworks.ttk.layout.FlexLayout;
import com.trollworks.ttk.utility.Colors;
import com.trollworks.ttk.utility.GraphicsUtilities;
import com.trollworks.ttk.utility.UIUtilities;
import com.trollworks.ttk.widgets.ActionPanel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import javax.swing.Scrollable;

public class BandedPanel
extends ActionPanel
implements Scrollable {
    private String mTitle;

    public BandedPanel(String string) {
        super(new ColumnLayout(1, 0, 0));
        this.setOpaque(true);
        this.setBackground(Color.white);
        this.mTitle = string;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(GraphicsUtilities.prepare(graphics));
        Rectangle rectangle = this.getBounds();
        rectangle.x = 0;
        rectangle.y = 0;
        int n = this.getStep();
        int n2 = this.getComponentCount();
        for (int i = 0; i < n2; i += n) {
            Rectangle rectangle2 = this.getComponent(i).getBounds();
            rectangle.y = rectangle2.y;
            rectangle.height = rectangle2.height;
            int n3 = i / n;
            graphics.setColor(Colors.getBanding(n3 % 2 == 0));
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    private int getStep() {
        LayoutManager layoutManager = this.getLayout();
        if (layoutManager instanceof ColumnLayout) {
            return ((ColumnLayout)layoutManager).getColumns();
        }
        if (layoutManager instanceof FlexLayout && ((FlexLayout)layoutManager).getRootCell() instanceof FlexGrid) {
            int n = ((FlexGrid)((FlexLayout)layoutManager).getRootCell()).getColumnCount();
            return n - n / 2;
        }
        return 1;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        return n == 1 ? rectangle.height : rectangle.width;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        int n3 = 10;
        int n4 = this.getComponentCount();
        if (n4 > 0) {
            n4 = Math.min(this.getStep(), n4);
            for (int i = 0; i < n4; ++i) {
                int n5 = this.getComponent(i).getHeight();
                if (n5 <= n3) continue;
                n3 = n5;
            }
        }
        return n3;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return UIUtilities.shouldTrackViewportHeight(this);
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return UIUtilities.shouldTrackViewportWidth(this);
    }

    @Override
    public String toString() {
        return this.mTitle;
    }
}

