/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.widgets;

import com.trollworks.ttk.widgets.BoundaryArea;
import com.trollworks.ttk.widgets.BoundaryListener;
import com.trollworks.ttk.widgets.WindowUtils;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class BoundaryTracker
implements MouseListener,
MouseMotionListener {
    private Component mComponent;
    private BoundaryListener mListener;
    private BoundaryArea mAdjuster;
    private Point mSnapshot;
    private Rectangle mBoundsSnapshot;
    private Rectangle mBoundsToAdjust;
    private Rectangle mInterimBounds;

    public BoundaryTracker(Component component, Rectangle rectangle, BoundaryListener boundaryListener) {
        this.mComponent = component;
        this.mListener = boundaryListener;
        this.mBoundsToAdjust = rectangle;
        this.mBoundsSnapshot = new Rectangle(this.mBoundsToAdjust);
        this.mInterimBounds = new Rectangle(this.mBoundsToAdjust);
        this.mAdjuster = BoundaryArea.OUTSIDE;
        this.mComponent.addMouseListener(this);
        this.mComponent.addMouseMotionListener(this);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.updateTracking(mouseEvent);
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.setTracking(BoundaryArea.OUTSIDE);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.mSnapshot = this.mListener.convertToLocalCoordinates(new Point(mouseEvent.getX(), mouseEvent.getY()));
        this.mBoundsSnapshot.setBounds(this.mBoundsToAdjust);
        this.updateTracking(this.mSnapshot);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.updateTracking(mouseEvent);
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        Point point = this.mListener.convertToLocalCoordinates(new Point(mouseEvent.getX(), mouseEvent.getY()));
        this.mInterimBounds.setBounds(this.mBoundsToAdjust);
        this.mAdjuster.adjust(point.x - this.mSnapshot.x, point.y - this.mSnapshot.y, this.mBoundsToAdjust, this.mBoundsSnapshot);
        if (!this.mInterimBounds.equals(this.mBoundsToAdjust)) {
            this.mListener.boundaryChanged(this.mInterimBounds, this.mBoundsToAdjust);
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        this.updateTracking(mouseEvent);
    }

    private void updateTracking(MouseEvent mouseEvent) {
        this.updateTracking(this.mListener.convertToLocalCoordinates(new Point(mouseEvent.getX(), mouseEvent.getY())));
    }

    private void updateTracking(Point point) {
        this.setTracking(BoundaryArea.over(point, this.mBoundsToAdjust));
    }

    private void setTracking(BoundaryArea boundaryArea) {
        if (boundaryArea != this.mAdjuster) {
            this.mAdjuster = boundaryArea;
            Cursor cursor = this.mAdjuster.getCursor();
            this.mComponent.setCursor(cursor);
            WindowUtils.getWindowForComponent(this.mComponent).setCursor(cursor);
            this.mListener.boundaryAreaChanged(this.mAdjuster);
        }
    }
}

