/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.widgets;

import com.trollworks.ttk.text.TextDrawing;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeListener;
import java.text.ParseException;
import javax.swing.JFormattedTextField;
import javax.swing.UIManager;

public class EditorField
extends JFormattedTextField
implements ActionListener {
    private String mHint;

    public EditorField(JFormattedTextField.AbstractFormatterFactory abstractFormatterFactory, PropertyChangeListener propertyChangeListener, int n, Object object, String string) {
        this(abstractFormatterFactory, propertyChangeListener, n, object, null, string);
    }

    public EditorField(JFormattedTextField.AbstractFormatterFactory abstractFormatterFactory, PropertyChangeListener propertyChangeListener, int n, Object object, Object object2, String string) {
        super(abstractFormatterFactory, object2 != null ? object2 : object);
        this.setHorizontalAlignment(n);
        this.setToolTipText(string);
        if (object2 != null) {
            this.setPreferredSize(this.getPreferredSize());
            this.setValue(object);
        }
        if (propertyChangeListener != null) {
            this.addPropertyChangeListener("value", propertyChangeListener);
        }
        this.addActionListener(this);
        this.setCaretColor(UIManager.getColor("TextField.caretForeground"));
        this.setSelectionColor(UIManager.getColor("TextField.selectionBackground"));
        this.setSelectedTextColor(UIManager.getColor("TextField.selectionForeground"));
        this.setDisabledTextColor(UIManager.getColor("TextField.inactiveForeground"));
    }

    @Override
    protected void processFocusEvent(FocusEvent focusEvent) {
        super.processFocusEvent(focusEvent);
        if (focusEvent.getID() == 1004) {
            this.selectAll();
        }
    }

    public void setHint(String string) {
        this.mHint = string;
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.mHint != null && this.getText().length() == 0) {
            Rectangle rectangle = this.getBounds();
            rectangle.x = 0;
            rectangle.y = 0;
            graphics.setColor(Color.GRAY);
            TextDrawing.draw(graphics, rectangle, this.mHint, 0, 0);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        try {
            this.commitEdit();
        }
        catch (ParseException parseException) {
            this.invalidEdit();
        }
    }
}

