/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.widgets;

import com.trollworks.ttk.text.Numbers;
import com.trollworks.ttk.text.TextDrawing;
import com.trollworks.ttk.utility.Colors;
import com.trollworks.ttk.utility.DelayedTask;
import com.trollworks.ttk.utility.GraphicsUtilities;
import com.trollworks.ttk.utility.LocalizedMessages;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.text.MessageFormat;
import javax.swing.JPanel;
import javax.swing.border.BevelBorder;

public class MemoryPanel
extends JPanel
implements Runnable,
HierarchyListener,
MouseListener {
    private static String MSG_FORMAT;
    private static String MSG_TOOLTIP;
    private static final long MB = 0x100000L;
    private MemoryMXBean mMemoryMXBean = ManagementFactory.getMemoryMXBean();
    private long mUsed;
    private long mMax;
    private boolean mPending;

    public MemoryPanel() {
        super(null);
        this.setBorder(new BevelBorder(1));
        this.setToolTipText(MSG_TOOLTIP);
        this.addMouseListener(this);
        this.addHierarchyListener(this);
        this.refresh();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSize() {
        Insets insets = this.getInsets();
        Dimension dimension = TextDrawing.getPreferredSize(this.getFont(), this.getText());
        dimension.width += insets.left + insets.right;
        dimension.height += insets.top + insets.bottom;
        return dimension;
    }

    @Override
    public synchronized void run() {
        this.refresh();
        this.mPending = false;
        this.schedule();
    }

    @Override
    public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
        this.schedule();
    }

    private synchronized void schedule() {
        if (!this.mPending && this.isDisplayable()) {
            this.mPending = true;
            DelayedTask.schedule(this, 1000L);
        }
    }

    private void refresh() {
        MemoryUsage memoryUsage = this.mMemoryMXBean.getHeapMemoryUsage();
        this.mUsed = memoryUsage.getUsed();
        this.mMax = memoryUsage.getMax();
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Rectangle rectangle = GraphicsUtilities.getLocalInsetBounds(this);
        graphics.setColor(Colors.lighter(Color.YELLOW, 90));
        int n = (int)((long)rectangle.width * this.mUsed / this.mMax);
        graphics.fillRect(rectangle.x, rectangle.y, n, rectangle.height);
        graphics.setColor(Colors.darker(Color.YELLOW, 20));
        graphics.drawLine(rectangle.x + n - 1, rectangle.y, rectangle.x + n - 1, rectangle.y + rectangle.height - 1);
        graphics.setColor(Color.BLACK);
        TextDrawing.draw(graphics, rectangle, this.getText(), 0, 0);
    }

    private String getText() {
        return MessageFormat.format(MSG_FORMAT, this.formatMB(this.mUsed), this.formatMB(this.mMax));
    }

    private String formatMB(long l) {
        return Numbers.format((l + 524288L) / 0x100000L);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.mMemoryMXBean.gc();
        this.refresh();
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    static {
        LocalizedMessages.initialize(MemoryPanel.class);
    }
}

