/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.widgets.outline;

import com.trollworks.ttk.widgets.outline.Cell;
import com.trollworks.ttk.widgets.outline.HeaderCell;
import com.trollworks.ttk.widgets.outline.Outline;
import com.trollworks.ttk.widgets.outline.OutlineModel;
import com.trollworks.ttk.widgets.outline.Row;
import com.trollworks.ttk.widgets.outline.TextCell;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;

public class Column
implements Transferable {
    public static final DataFlavor DATA_FLAVOR = new DataFlavor(Column.class, "Outline Column");
    private HeaderCell mHeaderCell;
    private Cell mRowCell;
    private boolean mVisible;
    private int mWidth;
    private String mName;
    private BufferedImage mIcon;
    private int mID;
    private String mToolTipText;

    public Column(int n, String string) {
        this(n, string, (BufferedImage)null);
    }

    public Column(int n, String string, Cell cell) {
        this(n, string, null, null, cell);
    }

    public Column(int n, String string, BufferedImage bufferedImage) {
        this(n, string, bufferedImage, string);
    }

    public Column(int n, String string, String string2) {
        this(n, string, null, string2);
    }

    public Column(int n, String string, BufferedImage bufferedImage, String string2) {
        this(n, string, bufferedImage, string2, new TextCell());
    }

    public Column(int n, String string, String string2, Cell cell) {
        this(n, string, null, string2, cell);
    }

    public Column(int n, String string, BufferedImage bufferedImage, String string2, Cell cell) {
        this.mName = string == null || string.length() == 0 ? " " : string;
        this.mIcon = bufferedImage;
        this.mToolTipText = string2;
        this.mHeaderCell = new HeaderCell();
        this.mRowCell = cell;
        this.mVisible = true;
        this.mWidth = -1;
        this.mID = n;
    }

    public int getID() {
        return this.mID;
    }

    public void setID(int n) {
        this.mID = n;
    }

    public boolean isSortAscending() {
        return this.getHeaderCell().isSortAscending();
    }

    public void setSortCriteria(int n, boolean bl) {
        this.getHeaderCell().setSortCriteria(n, bl);
    }

    public int getSortSequence() {
        return this.getHeaderCell().getSortSequence();
    }

    public void drawHeaderCell(Outline outline, Graphics graphics, Rectangle rectangle) {
        this.getHeaderCell().drawCell(outline, graphics, rectangle, null, this, false, true);
    }

    public void drawRowCell(Outline outline, Graphics graphics, Rectangle rectangle, Row row, boolean bl, boolean bl2) {
        this.getRowCell(row).drawCell(outline, graphics, rectangle, row, this, bl, bl2);
    }

    public HeaderCell getHeaderCell() {
        return this.mHeaderCell;
    }

    public void setHeaderCell(HeaderCell headerCell) {
        this.mHeaderCell = headerCell;
    }

    public Cell getRowCell(Row row) {
        return this.mRowCell;
    }

    public void setRowCell(Cell cell) {
        this.mRowCell = cell;
    }

    public boolean isVisible() {
        return this.mVisible;
    }

    public void setVisible(boolean bl) {
        this.mVisible = bl;
    }

    public int getWidth() {
        return this.mWidth;
    }

    public void setWidth(int n) {
        int n2 = this.getPreferredHeaderWidth();
        if (n < n2 && n != -1) {
            n = n2;
        }
        this.mWidth = n;
    }

    public int getPreferredHeaderWidth() {
        return this.getHeaderCell().getPreferredWidth(null, this);
    }

    public int getPreferredHeaderHeight() {
        return this.getHeaderCell().getPreferredHeight(null, this);
    }

    public int getPreferredWidth(Outline outline) {
        int n = this.getPreferredHeaderWidth();
        OutlineModel outlineModel = outline.getModel();
        for (Row row : outlineModel.getRows()) {
            int n2 = this.getRowCell(row).getPreferredWidth(row, this) + outlineModel.getIndentWidth(row, this);
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    public void setName(String string) {
        this.mName = string == null || string.length() == 0 ? " " : string;
    }

    public String toString() {
        return this.mName;
    }

    public String getSanitizedName() {
        return this.mName.replaceAll("\n", " ");
    }

    public BufferedImage getIcon() {
        return this.mIcon;
    }

    public void setIcon(BufferedImage bufferedImage) {
        this.mIcon = bufferedImage;
    }

    public void setToolTipText(String string) {
        this.mToolTipText = string;
    }

    public String getToolTipText(MouseEvent mouseEvent, Rectangle rectangle) {
        return this.mToolTipText;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{DATA_FLAVOR, DataFlavor.stringFlavor};
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return DATA_FLAVOR.equals(dataFlavor) || DataFlavor.stringFlavor.equals(dataFlavor);
    }

    @Override
    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException {
        if (DATA_FLAVOR.equals(dataFlavor)) {
            return this;
        }
        if (DataFlavor.stringFlavor.equals(dataFlavor)) {
            return this.getSanitizedName();
        }
        throw new UnsupportedFlavorException(dataFlavor);
    }
}

