/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.widgets.outline;

import com.trollworks.ttk.widgets.outline.Column;
import com.trollworks.ttk.widgets.outline.Outline;
import com.trollworks.ttk.widgets.outline.Row;
import com.trollworks.ttk.widgets.outline.TextCell;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;

public class HeaderCell
extends TextCell {
    public static final int SORTER_WIDTH = 12;
    private int mSortSequence = -1;
    private boolean mSortAscending = true;
    private Color mSorterColor;
    private boolean mAllowSort = true;

    public HeaderCell() {
        super(0);
    }

    public boolean isSortAllowed() {
        return this.mAllowSort;
    }

    public void allowSort(boolean bl) {
        if (bl != this.mAllowSort) {
            this.mAllowSort = bl;
            if (!this.mAllowSort) {
                this.mSortSequence = -1;
            }
        }
    }

    public boolean isSortAscending() {
        return this.mSortAscending;
    }

    public void setSortCriteria(int n, boolean bl) {
        if (this.mAllowSort) {
            this.mSortSequence = n;
            this.mSortAscending = bl;
        }
    }

    public int getSortSequence() {
        return this.mSortSequence;
    }

    protected void drawCellSuper(Outline outline, Graphics graphics, Rectangle rectangle, Row row, Column column, boolean bl, boolean bl2) {
        super.drawCell(outline, graphics, rectangle, row, column, bl, bl2);
    }

    @Override
    public void drawCell(Outline outline, Graphics graphics, Rectangle rectangle, Row row, Column column, boolean bl, boolean bl2) {
        if (this.mAllowSort) {
            rectangle.x += 2;
            rectangle.width -= 4;
            if (this.mSortSequence != -1) {
                rectangle.width -= 12;
            }
            this.drawCellSuper(outline, graphics, rectangle, row, column, bl, bl2);
            if (this.mSortSequence != -1) {
                int n;
                rectangle.width += 12;
                int n2 = rectangle.x + rectangle.width - 6;
                int n3 = rectangle.y + rectangle.height / 2 - 1;
                graphics.setColor(this.getSorterColor());
                int n4 = 0;
                for (Column column2 : outline.getModel().getColumns()) {
                    if (column2.getSortSequence() >= 0 && ++n4 > 1) break;
                }
                if (n4 > 1) {
                    for (n = 0; n <= this.mSortSequence; ++n) {
                        graphics.fillRect(rectangle.x + 1 + 3 * n, rectangle.y + rectangle.height - 3, 2, 2);
                    }
                }
                for (n = 0; n < 5; ++n) {
                    int n5 = this.mSortAscending ? n2 - n : n2 + n - 4;
                    int n6 = this.mSortAscending ? n2 + n : n2 + 4 - n;
                    graphics.drawLine(n5, n3 + n, n6, n3 + n);
                }
            }
            rectangle.x -= 2;
            rectangle.width += 4;
        } else {
            this.drawCellSuper(outline, graphics, rectangle, row, column, bl, bl2);
        }
    }

    @Override
    public int getPreferredWidth(Row row, Column column) {
        int n = super.getPreferredWidth(row, column);
        if (this.mAllowSort) {
            n += 16;
        }
        return n;
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent, Rectangle rectangle, Row row, Column column) {
        return column.getToolTipText(mouseEvent, rectangle);
    }

    public Color getSorterColor() {
        if (this.mSorterColor == null) {
            this.mSorterColor = Color.blue.darker();
        }
        return this.mSorterColor;
    }

    public void setSorterColor(Color color) {
        this.mSorterColor = color;
    }
}

