/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.widgets.outline;

import com.trollworks.ttk.widgets.outline.Column;
import com.trollworks.ttk.widgets.outline.OutlineModel;
import com.trollworks.ttk.widgets.outline.RowUndoSnapshot;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class Row {
    private OutlineModel mOwner;
    private int mHeight = -1;
    private boolean mOpen;
    private Row mParent;
    protected ArrayList<Row> mChildren;

    public final boolean equals(Object object) {
        return object == this;
    }

    void applyUndoSnapshot(OutlineModel outlineModel, RowUndoSnapshot rowUndoSnapshot) {
        this.mOwner = outlineModel;
        this.mParent = rowUndoSnapshot.getParent();
        this.mOpen = rowUndoSnapshot.isOpen();
        if (this.canHaveChildren()) {
            this.mChildren.clear();
            for (Row row : rowUndoSnapshot.getChildren()) {
                this.mChildren.add(row);
                row.mParent = this;
            }
        }
    }

    void resetOwner(OutlineModel outlineModel) {
        this.mOwner = outlineModel;
        this.mParent = null;
    }

    public BufferedImage getIcon(Column column) {
        return null;
    }

    public abstract Object getData(Column var1);

    public abstract String getDataAsText(Column var1);

    public abstract void setData(Column var1, Object var2);

    public int getHeight() {
        return this.mHeight;
    }

    public void setHeight(int n) {
        this.mHeight = n;
    }

    public int getPreferredHeight(List<Column> list) {
        int n = 0;
        for (Column column : list) {
            int n2 = column.getRowCell(this).getPreferredHeight(this, column);
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    public OutlineModel getOwner() {
        return this.mOwner;
    }

    void setOwner(OutlineModel outlineModel) {
        this.mOwner = outlineModel;
    }

    public boolean canHaveChildren() {
        return this.mChildren != null;
    }

    public void setCanHaveChildren(boolean bl) {
        if (bl != this.canHaveChildren()) {
            if (bl) {
                this.mChildren = new ArrayList();
            } else {
                this.setOpen(false);
                this.mChildren = null;
            }
        }
    }

    public List<Row> getChildren() {
        return this.canHaveChildren() ? Collections.unmodifiableList(this.mChildren) : null;
    }

    ArrayList<Row> getChildList() {
        return this.canHaveChildren() ? this.mChildren : null;
    }

    public Row getChild(int n) {
        return n >= 0 && n < this.getChildCount() ? this.mChildren.get(n) : null;
    }

    public int getChildCount() {
        return this.canHaveChildren() ? this.mChildren.size() : 0;
    }

    public boolean hasChildren() {
        return this.canHaveChildren() && !this.mChildren.isEmpty();
    }

    public boolean isOpen() {
        return this.mOpen;
    }

    public void setOpen(boolean bl) {
        if (this.mOpen != bl && (!bl || bl && this.canHaveChildren())) {
            this.mOpen = bl;
            if (this.mOwner != null) {
                this.mOwner.rowOpenStateChanged(this, this.mOpen);
            }
        }
    }

    public int getIndexOfChild(Row row) {
        if (this.canHaveChildren()) {
            return this.mChildren.indexOf(row);
        }
        return -1;
    }

    public boolean insertChild(int n, Row row) {
        if (this.canHaveChildren()) {
            int n2;
            row.removeFromParent();
            if (n < 0) {
                n = 0;
            }
            if (n > (n2 = this.mChildren.size())) {
                n = n2;
            }
            this.mChildren.add(n, row);
            row.mParent = this;
            return true;
        }
        return false;
    }

    public boolean addChild(Row row) {
        if (this.canHaveChildren()) {
            row.removeFromParent();
            this.mChildren.add(row);
            row.mParent = this;
            return true;
        }
        return false;
    }

    public boolean removeChild(Row row) {
        if (row.isChildOf(this)) {
            this.mChildren.remove(row);
            row.mParent = null;
            return true;
        }
        return false;
    }

    public boolean isChildOf(Row row) {
        return this.mParent == row;
    }

    public boolean isDescendantOf(Row row) {
        Row row2 = this.mParent;
        while (row2 != null) {
            if (row2 == row) {
                return true;
            }
            row2 = row2.mParent;
        }
        return false;
    }

    public void removeFromParent() {
        if (this.mParent != null) {
            this.mParent.removeChild(this);
        }
    }

    public Row getParent() {
        return this.mParent;
    }

    public Row[] getPath() {
        ArrayList<Row> arrayList = new ArrayList<Row>();
        Row row = this.mParent;
        arrayList.add(this);
        while (row != null) {
            arrayList.add(0, row);
            row = row.mParent;
        }
        return arrayList.toArray(new Row[0]);
    }

    public int getDepth() {
        Row row = this.mParent;
        int n = 0;
        while (row != null) {
            ++n;
            row = row.mParent;
        }
        return n;
    }
}

