/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.widgets.outline;

import com.trollworks.ttk.widgets.outline.Column;
import com.trollworks.ttk.widgets.outline.Row;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;

public class RowSorter
implements Comparator<Row> {
    private Column[] mSortingOrder;

    private RowSorter(ArrayList<Column> arrayList) {
        int n;
        int n2 = arrayList.size();
        Column[] columnArray = new Column[n2];
        int n3 = -1;
        this.mSortingOrder = new Column[n2];
        for (n = 0; n < n2; ++n) {
            Column column = arrayList.get(n);
            int n4 = column.getSortSequence();
            if (n4 >= 0 && n4 < n2) {
                this.mSortingOrder[n4] = column;
                continue;
            }
            columnArray[n] = column;
            if (n3 != -1) continue;
            n3 = n;
        }
        if (n3 != -1) {
            for (n = 0; n < n2; ++n) {
                if (this.mSortingOrder[n] != null) continue;
                this.mSortingOrder[n] = columnArray[n3++];
                while (n3 < n2 && columnArray[n3] == null) {
                    ++n3;
                }
                if (n3 >= n2) break;
            }
        }
    }

    public static void sort(ArrayList<Column> arrayList, ArrayList<Row> arrayList2) {
        RowSorter.sort(arrayList, arrayList2, false);
    }

    public static void sort(ArrayList<Column> arrayList, ArrayList<Row> arrayList2, boolean bl) {
        for (Column column : arrayList) {
            if (column.getSortSequence() == -1) continue;
            RowSorter rowSorter = new RowSorter(arrayList);
            Collections.sort(arrayList2, rowSorter);
            if (bl) {
                for (Row row : RowSorter.collectContainerRows(arrayList2, new HashSet<Row>())) {
                    if (!row.hasChildren()) continue;
                    Collections.sort(row.getChildList(), rowSorter);
                }
            }
            return;
        }
    }

    public static HashSet<Row> collectContainerRows(List<Row> list, HashSet<Row> hashSet) {
        for (Row row : list) {
            if (!row.canHaveChildren()) continue;
            hashSet.add(row);
            if (!row.hasChildren()) continue;
            RowSorter.collectContainerRows(row.getChildren(), hashSet);
        }
        return hashSet;
    }

    @Override
    public int compare(Row row, Row row2) {
        if (row.getParent() == row2.getParent()) {
            for (Column column : this.mSortingOrder) {
                if (column == null) {
                    return 0;
                }
                int n = column.getRowCell(null).compare(column, row, row2);
                if (n == 0) continue;
                return column.isSortAscending() ? n : -n;
            }
        } else {
            if (row.isDescendantOf(row2)) {
                return 1;
            }
            if (row2.isDescendantOf(row)) {
                return -1;
            }
            Row[] rowArray = row.getPath();
            Row[] rowArray2 = row2.getPath();
            int n = Math.min(rowArray.length, rowArray2.length);
            int n2 = 0;
            for (n2 = 0; n2 < n && rowArray[n2] == rowArray2[n2]; ++n2) {
            }
            return this.compare(rowArray[n2], rowArray2[n2]);
        }
        return 0;
    }
}

