/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.widgets.outline;

import com.trollworks.ttk.image.Images;
import com.trollworks.ttk.widgets.outline.Column;
import com.trollworks.ttk.widgets.outline.ImageCell;
import com.trollworks.ttk.widgets.outline.Row;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.JCheckBox;

public class ToggleCell
extends ImageCell {
    private BufferedImage mOn;
    private BufferedImage mOff;

    public ToggleCell() {
        JCheckBox jCheckBox = new JCheckBox();
        jCheckBox.putClientProperty("JComponent.sizeVariant", "mini");
        Dimension dimension = jCheckBox.getPreferredSize();
        jCheckBox.setSize(dimension);
        this.mOff = Images.create(dimension.width, dimension.height);
        Graphics graphics = this.mOff.getGraphics();
        jCheckBox.paint(graphics);
        graphics.dispose();
        jCheckBox.setSelected(true);
        this.mOn = Images.create(dimension.width, dimension.height);
        graphics = this.mOn.getGraphics();
        jCheckBox.paint(graphics);
        graphics.dispose();
    }

    public ToggleCell(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        this.mOn = bufferedImage;
        this.mOff = bufferedImage2;
    }

    @Override
    protected BufferedImage getIcon(Row row, Column column, boolean bl, boolean bl2) {
        Object object = row.getData(column);
        return (Boolean)object != false ? this.mOn : this.mOff;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent, Rectangle rectangle, Row row, Column column) {
        Boolean bl = (Boolean)row.getData(column);
        row.setData(column, bl != false ? Boolean.FALSE : Boolean.TRUE);
    }
}

