/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.widgets.tree;

import com.trollworks.ttk.text.TextDrawing;
import com.trollworks.ttk.utility.Fonts;
import com.trollworks.ttk.widgets.tree.TreePanel;
import com.trollworks.ttk.widgets.tree.TreeRow;
import com.trollworks.ttk.widgets.tree.TreeSorter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.util.Comparator;
import javax.swing.UIManager;

public abstract class TreeColumn
implements Comparator<TreeRow>,
Transferable {
    public static final DataFlavor DATA_FLAVOR = new DataFlavor(TreeColumn.class, "Tree Column");
    private static final int SORTER_WIDTH = 12;
    private static final int HALF_SORTER_WIDTH = 6;
    private String mName;
    private int mWidth;

    protected TreeColumn(String string) {
        this.mName = string;
    }

    public String getName() {
        return this.mName;
    }

    public abstract int calculatePreferredWidth(TreeRow var1);

    public abstract int calculatePreferredHeight(TreeRow var1, int var2);

    public Dimension calculatePreferredHeaderSize(TreePanel treePanel) {
        Font font = this.getHeaderFont();
        int n = this.getWidth();
        if (treePanel.isUserSortable()) {
            n -= 12;
        }
        Dimension dimension = TextDrawing.getPreferredSize(font, TextDrawing.wrapToPixelWidth(font, this.getName(), n));
        if (treePanel.isUserSortable()) {
            dimension.width += 12;
        }
        return dimension;
    }

    public int getWidth() {
        return this.mWidth;
    }

    public void setWidth(int n) {
        this.mWidth = n;
    }

    public int getMinimumWidth(TreePanel treePanel) {
        int n = TextDrawing.getPreferredSize((Font)this.getHeaderFont(), (String)this.getName()).width;
        if (treePanel.isUserSortable()) {
            n += 12;
        }
        return n;
    }

    public void drawHeader(Graphics2D graphics2D, TreePanel treePanel, Rectangle rectangle, boolean bl) {
        Font font = graphics2D.getFont();
        Color color = graphics2D.getColor();
        graphics2D.setColor(UIManager.getColor("Panel.background"));
        graphics2D.fill(rectangle);
        graphics2D.setColor(UIManager.getColor("Panel.foreground"));
        Font font2 = this.getHeaderFont();
        graphics2D.setFont(font2);
        int n = -1;
        TreeSorter treeSorter = treePanel.getTreeSorter();
        if (treePanel.isUserSortable()) {
            n = treeSorter.getSortSequence(this);
        }
        if (n != -1) {
            rectangle.width -= 12;
        }
        String string = TextDrawing.wrapToPixelWidth(font2, this.getName(), rectangle.width);
        TextDrawing.draw(graphics2D, rectangle, string, 0, 0);
        if (n != -1) {
            int n2;
            int n3;
            int n4;
            int n5;
            rectangle.width += 12;
            graphics2D.setColor(this.getSorterColor());
            int n6 = rectangle.x + rectangle.width - 6;
            int n7 = rectangle.y + rectangle.height / 2 - 1;
            if (treeSorter.hasMultipleCriteria()) {
                n5 = n7 - 2;
                n4 = n5 - 2;
                n3 = n5 - 4;
                n2 = n6 - 1;
                int n8 = n2 + 1;
                int n9 = n2 + 2;
                switch (n + 1) {
                    case 1: {
                        graphics2D.drawLine(n8, n3, n8, n5);
                        break;
                    }
                    case 2: {
                        graphics2D.drawLine(n2, n3, n9, n3);
                        graphics2D.drawLine(n9, n3, n9, n4);
                        graphics2D.drawLine(n2, n4, n9, n4);
                        graphics2D.drawLine(n2, n4, n2, n5);
                        graphics2D.drawLine(n2, n5, n9, n5);
                        break;
                    }
                    case 3: {
                        graphics2D.drawLine(n2, n3, n9, n3);
                        graphics2D.drawLine(n9, n3, n9, n5);
                        graphics2D.drawLine(n8, n4, n9, n4);
                        graphics2D.drawLine(n2, n5, n9, n5);
                        break;
                    }
                    case 4: {
                        graphics2D.drawLine(n2, n3, n2, n4);
                        graphics2D.drawLine(n2, n4, n9, n4);
                        graphics2D.drawLine(n9, n3, n9, n5);
                        break;
                    }
                    case 5: {
                        graphics2D.drawLine(n2, n3, n9, n3);
                        graphics2D.drawLine(n2, n3, n2, n4);
                        graphics2D.drawLine(n2, n4, n9, n4);
                        graphics2D.drawLine(n9, n4, n9, n5);
                        graphics2D.drawLine(n2, n5, n9, n5);
                        break;
                    }
                    case 6: {
                        graphics2D.drawLine(n2, n3, n9, n3);
                        graphics2D.drawLine(n2, n3, n2, n5);
                        graphics2D.drawLine(n2, n4, n9, n4);
                        graphics2D.drawLine(n9, n4, n9, n5);
                        graphics2D.drawLine(n2, n5, n9, n5);
                        break;
                    }
                    case 7: {
                        graphics2D.drawLine(n2, n3, n9, n3);
                        graphics2D.drawLine(n9, n3, n9, n5);
                        break;
                    }
                    case 8: {
                        graphics2D.drawLine(n2, n3, n9, n3);
                        graphics2D.drawLine(n2, n3, n2, n5);
                        graphics2D.drawLine(n2, n4, n9, n4);
                        graphics2D.drawLine(n2, n5, n9, n5);
                        graphics2D.drawLine(n9, n3, n9, n5);
                        break;
                    }
                    case 9: {
                        graphics2D.drawLine(n2, n3, n9, n3);
                        graphics2D.drawLine(n2, n3, n2, n4);
                        graphics2D.drawLine(n2, n4, n9, n4);
                        graphics2D.drawLine(n9, n3, n9, n5);
                        graphics2D.drawLine(n2, n5, n9, n5);
                        break;
                    }
                    default: {
                        graphics2D.drawLine(n2, n3, n9, n3);
                        graphics2D.drawLine(n9, n3, n9, n4);
                        graphics2D.drawLine(n8, n4, n9, n4);
                        graphics2D.drawLine(n8, n5, n8, n5);
                    }
                }
            }
            n5 = treeSorter.isSortAscending(this) ? 1 : 0;
            for (n4 = 0; n4 < 5; ++n4) {
                if (n5 != 0) {
                    n3 = n6 - n4;
                    n2 = n6 + n4;
                } else {
                    n3 = n6 + n4 - 4;
                    n2 = n6 + 6 - 2 - n4;
                }
                graphics2D.drawLine(n3, n7 + n4, n2, n7 + n4);
            }
        }
        graphics2D.setFont(font);
        graphics2D.setColor(color);
    }

    public abstract void draw(Graphics2D var1, TreePanel var2, TreeRow var3, int var4, int var5, int var6, int var7, boolean var8, boolean var9);

    public Font getHeaderFont() {
        return Fonts.getDefaultFont();
    }

    public Color getSorterColor() {
        return Color.blue.darker();
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{DATA_FLAVOR};
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return DATA_FLAVOR.equals(dataFlavor);
    }

    @Override
    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException {
        if (DATA_FLAVOR.equals(dataFlavor)) {
            return this;
        }
        throw new UnsupportedFlavorException(dataFlavor);
    }
}

