/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.widgets.tree;

import com.trollworks.ttk.widgets.tree.TreeColumn;
import com.trollworks.ttk.widgets.tree.TreeDragState;
import com.trollworks.ttk.widgets.tree.TreePanel;
import java.awt.Point;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.util.ArrayList;

public class TreeColumnDragState
extends TreeDragState {
    private TreeColumn mColumn;
    private ArrayList<TreeColumn> mOriginal;

    public TreeColumnDragState(TreePanel treePanel, TreeColumn treeColumn) {
        super(treePanel);
        this.mColumn = treeColumn;
        this.mOriginal = new ArrayList<TreeColumn>(treePanel.getColumns());
        this.setHeaderFocus(true);
        this.setContentsFocus(true);
    }

    public TreeColumn getColumn() {
        return this.mColumn;
    }

    public ArrayList<TreeColumn> getOriginalColumns() {
        return this.mOriginal;
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        dropTargetDragEvent.acceptDrag(2);
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        int n;
        TreePanel treePanel = this.getPanel();
        TreeColumn treeColumn = treePanel.overColumn(n = treePanel.toHeaderView((Point)new Point((Point)dropTargetDragEvent.getLocation())).x);
        if (treeColumn != null && treeColumn != this.mColumn) {
            ArrayList<TreeColumn> arrayList = new ArrayList<TreeColumn>(treePanel.getColumns());
            int n2 = arrayList.indexOf(treeColumn);
            int n3 = arrayList.indexOf(this.mColumn);
            int n4 = treePanel.getColumnStart(n2) + treeColumn.getWidth() / 2;
            if (n2 < n3 && n < n4 || n2 > n3 && n > n4) {
                if (n3 < n2) {
                    for (int i = n3; i < n2; ++i) {
                        arrayList.set(i, arrayList.get(i + 1));
                    }
                } else {
                    for (int i = n3; i > n2; --i) {
                        arrayList.set(i, arrayList.get(i - 1));
                    }
                }
                arrayList.set(n2, this.mColumn);
                treePanel.restoreColumns(arrayList);
            }
        }
        dropTargetDragEvent.acceptDrag(2);
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
        TreePanel treePanel = this.getPanel();
        if (((Object)treePanel.getColumns()).equals(this.mOriginal)) {
            treePanel.repaintColumn(this.mColumn);
        } else {
            treePanel.restoreColumns(this.mOriginal);
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        dropTargetDragEvent.acceptDrag(2);
    }

    @Override
    public boolean drop(DropTargetDropEvent dropTargetDropEvent) {
        this.getPanel().repaintColumn(this.mColumn);
        return true;
    }
}

