/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.widgets.tree;

import com.trollworks.ttk.widgets.tree.TreeRow;
import com.trollworks.ttk.widgets.tree.TreeRowIndexComparator;
import com.trollworks.ttk.widgets.tree.TreeSorter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class TreeContainerRow
extends TreeRow {
    private ArrayList<TreeRow> mChildren = new ArrayList();

    @Override
    protected TreeContainerRow clone() {
        TreeContainerRow treeContainerRow = (TreeContainerRow)super.clone();
        ArrayList<TreeRow> arrayList = new ArrayList<TreeRow>(this.mChildren.size());
        for (TreeRow treeRow : this.mChildren) {
            treeRow = treeRow.clone();
            arrayList.add(treeRow);
            treeRow.mParent = treeContainerRow;
        }
        treeContainerRow.mChildren = arrayList;
        treeContainerRow.renumber(0);
        return treeContainerRow;
    }

    public int getChildCount() {
        return this.mChildren.size();
    }

    public List<TreeRow> getChildren() {
        return Collections.unmodifiableList(this.mChildren);
    }

    public TreeRow getChild(int n) {
        return this.mChildren.get(n);
    }

    public void addRow(TreeRow treeRow) {
        this.addRow(this.mChildren.size(), treeRow);
    }

    public void addRow(List<TreeRow> list) {
        this.addRow(this.mChildren.size(), list);
    }

    public void addRow(int n, TreeRow treeRow) {
        ArrayList<TreeRow> arrayList = new ArrayList<TreeRow>(1);
        arrayList.add(treeRow);
        this.addRow(n, arrayList);
    }

    /*
     * WARNING - void declaration
     */
    public void addRow(int n, List<TreeRow> list) {
        if (!list.isEmpty()) {
            HashMap hashMap = new HashMap();
            HashSet<TreeRow> hashSet = new HashSet<TreeRow>();
            ArrayList<TreeRow> arrayList = new ArrayList<TreeRow>();
            for (TreeRow iterator : list) {
                if (iterator.mParent != null) {
                    void var8_12;
                    HashSet hashSet2 = (HashSet)hashMap.get(iterator.mParent);
                    if (hashSet2 == null) {
                        HashSet hashSet3 = new HashSet();
                        hashMap.put(iterator.mParent, hashSet3);
                    }
                    var8_12.add(iterator);
                }
                if (hashSet.contains(iterator)) continue;
                hashSet.add(iterator);
                arrayList.add(iterator);
            }
            for (Map.Entry entry : hashMap.entrySet()) {
                ((TreeContainerRow)entry.getKey()).removeRow((Collection)entry.getValue());
            }
            int n2 = n = Math.min(n, this.mChildren.size());
            for (TreeRow treeRow : arrayList) {
                this.mChildren.add(n++, treeRow);
                treeRow.mParent = this;
            }
            this.renumber(n2);
            this.notify("tree.row.added", list.toArray(new TreeRow[arrayList.size()]));
        }
    }

    public void removeRow(TreeRow treeRow) {
        ArrayList<TreeRow> arrayList = new ArrayList<TreeRow>(1);
        arrayList.add(treeRow);
        this.removeRow(arrayList);
    }

    public void removeRow(Collection<TreeRow> collection) {
        if (!collection.isEmpty()) {
            HashSet<TreeRow> hashSet = new HashSet<TreeRow>();
            for (TreeRow treeRowArray : collection) {
                if (treeRowArray.mParent != this) continue;
                hashSet.add(treeRowArray);
            }
            int n = hashSet.size();
            if (n > 0) {
                TreeRow[] treeRowArray = hashSet.toArray(new TreeRow[n]);
                Arrays.sort(treeRowArray, TreeRowIndexComparator.INSTANCE);
                int n2 = treeRowArray[0].getIndex();
                for (TreeRow treeRow : treeRowArray) {
                    this.mChildren.remove(treeRow);
                    treeRow.mParent = null;
                }
                this.renumber(n2);
                this.notify("tree.row.removed", treeRowArray);
            }
        }
    }

    private void renumber(int n) {
        int n2 = this.mChildren.size();
        while (n < n2) {
            this.mChildren.get(n).setIndex(n);
            ++n;
        }
    }

    public void sort(TreeSorter treeSorter) {
        if (!this.mChildren.isEmpty()) {
            for (TreeRow treeRow : this.mChildren) {
                if (!(treeRow instanceof TreeContainerRow)) continue;
                ((TreeContainerRow)treeRow).sort(treeSorter);
            }
            Collections.sort(this.mChildren, treeSorter);
            this.renumber(0);
        }
    }
}

