/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.widgets.tree;

import com.trollworks.ttk.widgets.tree.TreeContainerRow;
import com.trollworks.ttk.widgets.tree.TreeRow;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class TreeRowIterator
implements Iterator<TreeRow>,
Iterable<TreeRow> {
    private List<TreeRow> mRows;
    private TreeRowIterator mIterator;
    private int mIndex;

    public TreeRowIterator(TreeRow treeRow) {
        this.mRows = new ArrayList<TreeRow>();
        this.mRows.add(treeRow);
    }

    public TreeRowIterator(TreeRow ... treeRowArray) {
        this.mRows = Arrays.asList(treeRowArray);
    }

    public TreeRowIterator(List<TreeRow> list) {
        this.mRows = list;
    }

    @Override
    public Iterator<TreeRow> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        boolean bl;
        boolean bl2 = bl = this.mIterator != null && this.mIterator.hasNext();
        if (!bl) {
            this.mIterator = null;
            bl = this.mIndex < this.mRows.size();
        }
        return bl;
    }

    @Override
    public TreeRow next() {
        if (this.hasNext()) {
            if (this.mIterator == null) {
                TreeContainerRow treeContainerRow;
                TreeRow treeRow;
                if ((treeRow = this.mRows.get(this.mIndex++)) instanceof TreeContainerRow && (treeContainerRow = (TreeContainerRow)treeRow).getChildCount() > 0) {
                    this.mIterator = new TreeRowIterator(treeContainerRow.getChildren());
                }
                return treeRow;
            }
            return this.mIterator.next();
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

