/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.widgets.tree;

import com.trollworks.ttk.widgets.tree.TreeColumn;
import com.trollworks.ttk.widgets.tree.TreeContainerRow;
import com.trollworks.ttk.widgets.tree.TreeRow;
import java.util.ArrayList;
import java.util.Comparator;

public class TreeSorter
implements Comparator<TreeRow> {
    private ArrayList<SortData> mSortData = new ArrayList();

    public boolean hasMultipleCriteria() {
        return this.mSortData.size() > 1;
    }

    public int getSortSequence(TreeColumn treeColumn) {
        int n = this.mSortData.size();
        for (int i = 0; i < n; ++i) {
            if (this.mSortData.get((int)i).mColumn != treeColumn) continue;
            return i;
        }
        return -1;
    }

    public boolean isSortAscending(TreeColumn treeColumn) {
        int n = this.mSortData.size();
        for (int i = 0; i < n; ++i) {
            SortData sortData = this.mSortData.get(i);
            if (sortData.mColumn != treeColumn) continue;
            return sortData.mAscending;
        }
        return true;
    }

    public void clearSort() {
        this.mSortData.clear();
    }

    public void setSort(TreeColumn treeColumn, boolean bl, boolean bl2) {
        if (bl2) {
            this.mSortData.clear();
            this.mSortData.add(new SortData(treeColumn, bl));
        } else {
            boolean bl3 = false;
            for (SortData sortData : this.mSortData) {
                if (sortData.mColumn != treeColumn) continue;
                sortData.mAscending = bl;
                bl3 = true;
                break;
            }
            if (!bl3) {
                this.mSortData.add(new SortData(treeColumn, bl));
            }
        }
    }

    public void setSort(TreeColumn treeColumn, boolean bl) {
        SortData sortData = null;
        boolean bl2 = true;
        for (SortData sortData2 : this.mSortData) {
            if (sortData2.mColumn != treeColumn) continue;
            bl2 = !sortData2.mAscending;
            sortData = sortData2;
            break;
        }
        if (bl) {
            this.mSortData.clear();
            this.mSortData.add(new SortData(treeColumn, bl2));
        } else if (sortData != null) {
            sortData.mAscending = bl2;
        } else {
            this.mSortData.add(new SortData(treeColumn, bl2));
        }
    }

    public void sort(TreeContainerRow treeContainerRow) {
        if (!this.mSortData.isEmpty()) {
            treeContainerRow.sort(this);
        }
    }

    @Override
    public int compare(TreeRow treeRow, TreeRow treeRow2) {
        for (SortData sortData : this.mSortData) {
            int n = sortData.mColumn.compare(treeRow, treeRow2);
            if (n == 0) continue;
            return sortData.mAscending ? n : -n;
        }
        return 0;
    }

    static class SortData {
        TreeColumn mColumn;
        boolean mAscending;

        SortData(TreeColumn treeColumn, boolean bl) {
            this.mColumn = treeColumn;
            this.mAscending = bl;
        }
    }
}

