/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.widgets.tree.test;

import com.trollworks.ttk.cmdline.CmdLine;
import com.trollworks.ttk.image.ToolkitImage;
import com.trollworks.ttk.menu.StdMenuBar;
import com.trollworks.ttk.menu.file.SignificantFrame;
import com.trollworks.ttk.notification.Notifier;
import com.trollworks.ttk.preferences.Preferences;
import com.trollworks.ttk.utility.App;
import com.trollworks.ttk.utility.GraphicsUtilities;
import com.trollworks.ttk.utility.LaunchProxy;
import com.trollworks.ttk.widgets.AppWindow;
import com.trollworks.ttk.widgets.tree.StdTreeDeleter;
import com.trollworks.ttk.widgets.tree.TextTreeColumn;
import com.trollworks.ttk.widgets.tree.TreeContainerRow;
import com.trollworks.ttk.widgets.tree.TreePanel;
import com.trollworks.ttk.widgets.tree.TreeRoot;
import com.trollworks.ttk.widgets.tree.TreeRow;
import com.trollworks.ttk.widgets.tree.test.TreeTesterEditMenu;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.image.BufferedImage;
import java.io.File;

public class TreeTester
extends App {
    public static final void main(String[] stringArray) {
        CmdLine cmdLine = new CmdLine(stringArray);
        LaunchProxy.configure(cmdLine.getArgumentsAsFiles().toArray(new File[0]));
        GraphicsUtilities.configureStandardUI();
        Preferences.setPreferenceFile(new File("/tmp/treetester.prf"));
        TreeTester treeTester = new TreeTester();
        treeTester.startup(cmdLine);
        EventQueue.invokeLater(treeTester);
    }

    @Override
    public void configureApplication(CmdLine cmdLine) {
        StdMenuBar.configure(TreeTesterEditMenu.class);
    }

    @Override
    public void noWindowsAreOpenAtStartup(boolean bl) {
        if (bl) {
            TestWindow testWindow = new TestWindow("Test 1 Drop Copy & Move", true);
            testWindow.setBounds(50, 50, 500, 500);
            testWindow.setVisible(true);
            testWindow = new TestWindow("Test 2 Drop Move Only", false);
            testWindow.setBounds(600, 50, 500, 500);
            testWindow.setVisible(true);
        }
    }

    public class TestWindow
    extends AppWindow
    implements SignificantFrame {
        public TestWindow(String string, boolean bl) {
            super(string, null, null);
            this.getContentPane().add((Component)this.createTestPanel(true, bl), "Center");
        }

        private TreePanel createTestPanel(boolean bl, boolean bl2) {
            int n;
            TreeRoot treeRoot = new TreeRoot(new Notifier());
            TreePanel treePanel = new TreePanel(treeRoot);
            treePanel.setAllowedRowDropTypes(bl2 ? 3 : 2);
            treePanel.setAllowRowDropFromExternal(true);
            if (bl) {
                treePanel.setRowHeight(0);
            }
            TextTreeColumn textTreeColumn = new TextTreeColumn("Testy goop", "name", "icon", 2, bl);
            treePanel.addColumn(textTreeColumn);
            for (n = 2; n < 10; ++n) {
                textTreeColumn = new TextTreeColumn(Integer.toString(n), "second");
                treePanel.addColumn(textTreeColumn);
            }
            for (n = 0; n < 100; ++n) {
                this.buildRows(treeRoot);
            }
            treePanel.sizeColumnsToFit();
            treePanel.pack();
            treePanel.setDeletableProxy(new StdTreeDeleter(treePanel));
            return treePanel;
        }

        private void buildRows(TreeRoot treeRoot) {
            treeRoot.addRow(new TestRow("First"));
            treeRoot.addRow(new TestRow("Second, but with a really long piece of non-pre-wrapped text."));
            treeRoot.addRow(new TestRow("Third, but with a\nreally long piece\nof pre-wrapped text."));
            treeRoot.addRow(new TestRow("Bob"));
            TestContainerRow testContainerRow = new TestContainerRow("Marley");
            for (int i = 0; i < 10; ++i) {
                TestContainerRow testContainerRow2;
                testContainerRow.addRow(new TestRow(Integer.toString(i)));
                if (i == 5) {
                    testContainerRow2 = new TestContainerRow("Submarine");
                    testContainerRow2.addRow(new TestRow("Yellow"));
                    testContainerRow2.addRow(new TestRow("Black"));
                    testContainerRow2.addRow(new TestRow("Blue"));
                    testContainerRow.addRow(testContainerRow2);
                }
                if (i != 9) continue;
                testContainerRow2 = new TestContainerRow("Last");
                testContainerRow2.addRow(new TestRow("Me"));
                testContainerRow2.addRow(new TestRow("You"));
                testContainerRow2.addRow(new TestRow("Them"));
                testContainerRow.addRow(testContainerRow2);
            }
            treeRoot.addRow(testContainerRow);
        }

        public class TestRow
        extends TreeRow {
            private String mName;

            public TestRow(String string) {
                this.mName = string;
            }

            public String getName() {
                return this.mName;
            }

            public String getSecond() {
                return Integer.toString(this.mName.length());
            }

            public BufferedImage getIcon() {
                return ToolkitImage.getMiniWarningIcon();
            }
        }

        public class TestContainerRow
        extends TreeContainerRow {
            private String mName;

            public TestContainerRow(String string) {
                this.mName = string;
            }

            public String getName() {
                return this.mName;
            }

            public String getSecond() {
                return Integer.toString(this.mName.length());
            }
        }
    }
}

