/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.xml;

import com.trollworks.ttk.text.Numbers;
import com.trollworks.ttk.xml.XMLNodeType;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;

public class XMLReader {
    public static boolean SHOW_SKIPPED_TAGS = Numbers.getBoolean(System.getProperty("SHOW_SKIPPED_TAGS", "false"));
    private static final String UNEXPECTED_EOF = "Unexpected EOF";
    private static final String COLON = ":";
    private HashMap<String, String> mEntityMap = new HashMap();
    private HashMap<String, String> mAttributeMap = new HashMap();
    private ArrayList<String> mStack = new ArrayList();
    private char[] mBuffer = new char[32768];
    private char[] mTextBuffer = new char[128];
    private XMLNodeType mType = XMLNodeType.START_DOCUMENT;
    private int mLine = 1;
    private int mColumn = 1;
    private Reader mReader;
    private int mPos;
    private int mCount;
    private boolean mEOF;
    private int mPeek0;
    private int mPeek1;
    private int mTextPos;
    private String mText;
    private boolean mIsWhitespace;
    private String mName;
    private boolean mIsEmptyElementTag;

    public XMLReader(InputStream inputStream) throws IOException {
        this(new InputStreamReader(inputStream));
    }

    public XMLReader(InputStream inputStream, Charset charset) throws IOException {
        this(new InputStreamReader(inputStream, charset));
    }

    public XMLReader(InputStream inputStream, CharsetDecoder charsetDecoder) throws IOException {
        this(new InputStreamReader(inputStream, charsetDecoder));
    }

    public XMLReader(InputStream inputStream, String string) throws IOException {
        this(new InputStreamReader(inputStream, string));
    }

    public XMLReader(Reader reader) throws IOException {
        this.mReader = reader;
        this.mPeek0 = reader.read();
        this.mPeek1 = reader.read();
        this.mEOF = this.mPeek0 == -1;
        this.defineCharacterEntity("amp", "&");
        this.defineCharacterEntity("apos", "'");
        this.defineCharacterEntity("gt", ">");
        this.defineCharacterEntity("lt", "<");
        this.defineCharacterEntity("quot", "\"");
    }

    public void close() throws IOException {
        this.mReader.close();
    }

    public String getMarker() {
        switch (this.mType) {
            case START_TAG: {
                return this.getDepth() - 1 + COLON + this.getName();
            }
            case END_TAG: {
                return this.getDepth() + COLON + this.getName();
            }
        }
        return this.getDepth() + COLON + this.mStack.get(this.mStack.size() - 1);
    }

    public boolean withinMarker(String string) throws IOException {
        if (this.mType == XMLNodeType.END_TAG) {
            if (string.equals(this.getMarker())) {
                this.next();
                return false;
            }
        } else if (this.mType == XMLNodeType.END_DOCUMENT) {
            this.fail("expected: " + XMLNodeType.END_TAG.name() + "/" + string.substring(string.indexOf(58) + 1));
        }
        return true;
    }

    public void require(XMLNodeType xMLNodeType, String string) throws IOException {
        if (this.mType == XMLNodeType.TEXT && xMLNodeType != XMLNodeType.TEXT && this.isWhitespace()) {
            this.next();
        }
        if (xMLNodeType != this.mType || string != null && !string.equals(this.getName())) {
            this.fail("expected: " + xMLNodeType.name() + "/" + string);
        }
    }

    public void skipTag(String string) throws IOException {
        if (SHOW_SKIPPED_TAGS) {
            System.out.println("Skipping tag: " + string);
        }
        this.require(XMLNodeType.START_TAG, string);
        String string2 = this.getMarker();
        do {
            this.next();
        } while (this.withinMarker(string2));
    }

    public String readText() throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        String string = this.getMarker();
        if (this.mType == XMLNodeType.START_TAG) {
            this.next();
        }
        do {
            if (this.mType == XMLNodeType.TEXT) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(' ');
                }
                stringBuilder.append(this.getText());
                this.next();
                continue;
            }
            if (this.mType != XMLNodeType.START_TAG) continue;
            this.skipTag(this.getName());
        } while (this.withinMarker(string));
        return stringBuilder.toString();
    }

    public boolean readBoolean() throws IOException {
        return Numbers.getBoolean(this.readText());
    }

    public short readShort(short s) throws IOException {
        return Numbers.getShort(this.readText(), s);
    }

    public int readInteger(int n) throws IOException {
        return Numbers.getInteger(this.readText(), n);
    }

    public long readLong(long l) throws IOException {
        return Numbers.getLong(this.readText(), l);
    }

    public float readFloat(float f) throws IOException {
        return Numbers.getFloat(this.readText(), f);
    }

    public double readDouble(double d) throws IOException {
        return Numbers.getDouble(this.readText(), d);
    }

    public Calendar readDateTime() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(this.getAttributeAsInteger("year", 1970), this.getAttributeAsInteger("month", 1), this.getAttributeAsInteger("day", 1), this.getAttributeAsInteger("hour", 0), this.getAttributeAsInteger("minute", 0), this.getAttributeAsInteger("second", 0));
        return calendar;
    }

    private final int read() throws IOException {
        int n = this.mPeek0;
        this.mPeek0 = this.mPeek1;
        if (this.mPeek0 == -1) {
            this.mEOF = true;
            return n;
        }
        if (n == 10 || n == 13) {
            ++this.mLine;
            this.mColumn = 0;
            if (n == 13 && this.mPeek0 == 10) {
                this.mPeek0 = 0;
            }
        }
        ++this.mColumn;
        if (this.mPos >= this.mCount) {
            this.mCount = this.mReader.read(this.mBuffer, 0, this.mBuffer.length);
            if (this.mCount <= 0) {
                this.mPeek1 = -1;
                return n;
            }
            this.mPos = 0;
        }
        this.mPeek1 = this.mBuffer[this.mPos++];
        return n;
    }

    private final void fail(String string) throws IOException {
        throw new IOException(string + " pos: " + this.getPositionDescription());
    }

    private final void push(int n) {
        if (n != 0) {
            if (this.mTextPos == this.mTextBuffer.length) {
                char[] cArray = new char[this.mTextPos * 4 / 3 + 4];
                System.arraycopy(this.mTextBuffer, 0, cArray, 0, this.mTextPos);
                this.mTextBuffer = cArray;
            }
            this.mTextBuffer[this.mTextPos++] = (char)n;
        }
    }

    private final void read(char c) throws IOException {
        if (this.read() != c) {
            this.fail("expected: '" + c + "'");
        }
    }

    private final void skip() throws IOException {
        while (!this.mEOF && this.mPeek0 <= 32) {
            this.read();
        }
    }

    private final String pop(int n) {
        String string = new String(this.mTextBuffer, n, this.mTextPos - n);
        this.mTextPos = n;
        return string;
    }

    private final String readName() throws IOException {
        int n = this.mTextPos;
        int n2 = this.mPeek0;
        if (!(n2 >= 97 && n2 <= 122 || n2 >= 65 && n2 <= 90 || n2 == 95 || n2 == 58)) {
            this.fail("name expected");
        }
        do {
            this.push(this.read());
        } while ((n2 = this.mPeek0) >= 97 && n2 <= 122 || n2 >= 65 && n2 <= 90 || n2 >= 48 && n2 <= 57 || n2 == 95 || n2 == 45 || n2 == 58 || n2 == 46);
        return this.pop(n);
    }

    private final void parseLegacy(boolean bl) throws IOException {
        int n;
        String string = "";
        this.read();
        int n2 = this.read();
        if (n2 == 63) {
            n = 63;
        } else if (n2 == 33) {
            if (this.mPeek0 == 45) {
                string = "--";
                n = 45;
            } else {
                string = "DOCTYPE";
                n = -1;
            }
        } else {
            if (n2 != 91) {
                this.fail("can't reach: " + n2);
            }
            string = "CDATA[";
            n = 93;
        }
        for (int i = 0; i < string.length(); ++i) {
            this.read(string.charAt(i));
        }
        if (n == -1) {
            this.parseDoctype();
        } else {
            do {
                if (this.mEOF) {
                    this.fail(UNEXPECTED_EOF);
                }
                n2 = this.read();
                if (!bl) continue;
                this.push(n2);
            } while (n != 63 && n2 != n || this.mPeek0 != n || this.mPeek1 != 62);
            this.read();
            this.read();
            if (bl && n != 63) {
                this.pop(this.mTextPos - 1);
            }
        }
    }

    private final void parseDoctype() throws IOException {
        int n = 1;
        while (true) {
            switch (this.read()) {
                case -1: {
                    this.fail(UNEXPECTED_EOF);
                    break;
                }
                case 60: {
                    ++n;
                    break;
                }
                case 62: {
                    if (--n != 0) break;
                    return;
                }
            }
        }
    }

    private final void parseEndTag() throws IOException {
        this.read();
        this.read();
        this.mName = this.readName();
        int n = this.mStack.size() - 1;
        if (n < 0) {
            this.fail("element stack empty");
        }
        if (this.mName.equals(this.mStack.get(n))) {
            this.mStack.remove(n);
        } else {
            this.fail("expected: " + this.mStack.get(n));
        }
        this.skip();
        this.read('>');
    }

    private final XMLNodeType peekType() {
        switch (this.mPeek0) {
            case -1: {
                return XMLNodeType.END_DOCUMENT;
            }
            case 38: {
                return XMLNodeType.ENTITY_REF;
            }
            case 60: {
                switch (this.mPeek1) {
                    case 47: {
                        return XMLNodeType.END_TAG;
                    }
                    case 91: {
                        return XMLNodeType.DATA;
                    }
                    case 33: 
                    case 63: {
                        return XMLNodeType.OTHER;
                    }
                }
                return XMLNodeType.START_TAG;
            }
        }
        return XMLNodeType.TEXT;
    }

    private final void parseStartTag() throws IOException {
        this.read();
        this.mName = this.readName();
        this.mStack.add(this.mName);
        while (true) {
            String string;
            this.skip();
            int n = this.mPeek0;
            if (n == 47) {
                this.mIsEmptyElementTag = true;
                this.read();
                this.skip();
                this.read('>');
                break;
            }
            if (n == 62) {
                this.read();
                break;
            }
            if (n == -1) {
                this.fail(UNEXPECTED_EOF);
            }
            if ((string = this.readName()).length() == 0) {
                this.fail("attribute name expected");
            }
            this.skip();
            this.read('=');
            this.skip();
            n = this.read();
            if (n != 39 && n != 34) {
                this.fail("<" + this.mName + ">: invalid delimiter: " + (char)n);
            }
            int n2 = this.mTextPos;
            this.pushText(n);
            this.mAttributeMap.put(string, this.pop(n2));
            if (n == 32) continue;
            this.read();
        }
    }

    private final boolean pushEntity() throws IOException {
        boolean bl = true;
        this.read();
        int n = this.mTextPos;
        while (!this.mEOF && this.mPeek0 != 59) {
            this.push(this.read());
        }
        String string = this.pop(n);
        this.read();
        if (string.length() > 0 && string.charAt(0) == '#') {
            int n2 = string.charAt(1) == 'x' ? Integer.parseInt(string.substring(2), 16) : Integer.parseInt(string.substring(1));
            this.push(n2);
            return n2 <= 32;
        }
        String string2 = this.mEntityMap.get(string);
        if (string2 == null) {
            string2 = "&" + string + ";";
        }
        for (int i = 0; i < string2.length(); ++i) {
            char c = string2.charAt(i);
            if (c > ' ') {
                bl = false;
            }
            this.push(c);
        }
        return bl;
    }

    private final boolean pushText(int n) throws IOException {
        boolean bl = true;
        int n2 = this.mPeek0;
        while (!this.mEOF && n2 != n && (n != 32 || n2 > 32 && n2 != 62)) {
            if (n2 == 38) {
                if (!this.pushEntity()) {
                    bl = false;
                }
            } else {
                if (n2 > 32) {
                    bl = false;
                }
                this.push(this.read());
            }
            n2 = this.mPeek0;
        }
        return bl;
    }

    public void defineCharacterEntity(String string, String string2) {
        this.mEntityMap.put(string, string2);
    }

    public int getDepth() {
        return this.mStack.size();
    }

    public String getPositionDescription() {
        StringBuilder stringBuilder = new StringBuilder(this.mType.name());
        stringBuilder.append(" @" + this.mLine + COLON + this.mColumn + ": ");
        if (this.mType == XMLNodeType.START_TAG) {
            stringBuilder.append('<');
            stringBuilder.append(this.mName);
            stringBuilder.append('>');
        } else if (this.mType == XMLNodeType.END_TAG) {
            stringBuilder.append("</");
            stringBuilder.append(this.mName);
            stringBuilder.append('>');
        } else if (this.mIsWhitespace) {
            stringBuilder.append("[whitespace]");
        } else {
            stringBuilder.append(this.getText());
        }
        return stringBuilder.toString();
    }

    public int getLineNumber() {
        return this.mLine;
    }

    public int getColumnNumber() {
        return this.mColumn;
    }

    public boolean isWhitespace() {
        return this.mIsWhitespace;
    }

    public String getText() {
        if (this.mText == null) {
            this.mText = this.pop(0);
        }
        return this.mText;
    }

    public String getName() {
        return this.mName;
    }

    public boolean isEmptyElementTag() {
        return this.mIsEmptyElementTag;
    }

    public String getAttribute(String string) {
        return this.mAttributeMap.get(string);
    }

    public String getAttribute(String string, String string2) {
        String string3 = this.mAttributeMap.get(string);
        return string3 != null ? string3 : string2;
    }

    public boolean hasAttribute(String string) {
        return this.mAttributeMap.get(string) != null;
    }

    public boolean isAttributeSet(String string) {
        return Numbers.getBoolean(this.mAttributeMap.get(string));
    }

    public short getAttributeAsShort(String string, short s) {
        return Numbers.getShort(this.mAttributeMap.get(string), s);
    }

    public int getAttributeAsInteger(String string, int n) {
        return Numbers.getInteger(this.mAttributeMap.get(string), n);
    }

    public long getAttributeAsLong(String string, long l) {
        return Numbers.getLong(this.mAttributeMap.get(string), l);
    }

    public float getAttributeAsFloat(String string, float f) {
        return Numbers.getFloat(this.mAttributeMap.get(string), f);
    }

    public double getAttributeAsDouble(String string, double d) {
        return Numbers.getDouble(this.mAttributeMap.get(string), d);
    }

    public HashMap<String, String> getAttributes() {
        return this.mAttributeMap;
    }

    public XMLNodeType getType() {
        return this.mType;
    }

    public XMLNodeType next() throws IOException {
        if (this.mIsEmptyElementTag) {
            this.mType = XMLNodeType.END_TAG;
            this.mIsEmptyElementTag = false;
            this.mStack.remove(this.mStack.size() - 1);
        } else {
            int n = XMLNodeType.TEXT.ordinal();
            this.mTextPos = 0;
            this.mIsWhitespace = true;
            do {
                this.mAttributeMap.clear();
                this.mName = null;
                this.mText = null;
                this.mType = this.peekType();
                switch (this.mType) {
                    case ENTITY_REF: {
                        this.mIsWhitespace &= this.pushEntity();
                        this.mType = XMLNodeType.TEXT;
                        break;
                    }
                    case START_TAG: {
                        this.parseStartTag();
                        break;
                    }
                    case END_TAG: {
                        this.parseEndTag();
                        break;
                    }
                    case END_DOCUMENT: {
                        break;
                    }
                    case TEXT: {
                        this.mIsWhitespace &= this.pushText(60);
                        break;
                    }
                    case DATA: {
                        this.parseLegacy(true);
                        this.mIsWhitespace = false;
                        this.mType = XMLNodeType.TEXT;
                        break;
                    }
                    default: {
                        this.parseLegacy(false);
                    }
                }
            } while (this.mType.ordinal() > n || this.mType == XMLNodeType.TEXT && this.peekType().ordinal() >= n);
            this.mIsWhitespace &= this.mType == XMLNodeType.TEXT;
        }
        return this.mType;
    }
}

