/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.xml;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Calendar;
import java.util.Date;

public class XMLWriter
extends PrintWriter {
    private static final String END_TAG = "/>";
    private static final String ENTITY_CODE_PREFIX = "&#";
    private static final String AMPERSAND_ENTITY = "&amp;";
    private static final String LESS_THAN_ENTITY = "&lt;";
    private static final String GREATER_THAN_ENTITY = "&gt;";
    private static final String END_COMMENT = " -->";
    public static final String ENCODING = "US-ASCII";
    public static final String YEAR = "year";
    public static final String MONTH = "month";
    public static final String DAY = "day";
    public static final String HOUR = "hour";
    public static final String MINUTE = "minute";
    public static final String SECOND = "second";
    private int mIndent;

    public XMLWriter(OutputStream outputStream) throws IOException {
        super(new OutputStreamWriter(outputStream, ENCODING));
    }

    public void writeHeader() {
        this.print("<?xml version=\"1.0\" encoding=\"");
        this.print(ENCODING);
        this.println("\" ?>");
    }

    public void writeComment(String string) {
        this.writeIndentation();
        this.startComment();
        this.writeEncodedData(string);
        this.finishCommentEOL();
    }

    public void startComment() {
        this.print("<!-- ");
    }

    public void finishComment() {
        this.print(END_COMMENT);
    }

    public void finishCommentEOL() {
        this.println(END_COMMENT);
    }

    public void writeEncodedData(String string) {
        if (string != null) {
            int n = string.length();
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                if (c == '<') {
                    this.print(LESS_THAN_ENTITY);
                    continue;
                }
                if (c == '>') {
                    this.print(GREATER_THAN_ENTITY);
                    continue;
                }
                if (c == '&') {
                    this.print(AMPERSAND_ENTITY);
                    continue;
                }
                if (c == '\r' || c == '\n') {
                    this.println();
                    continue;
                }
                if (c == '\t') {
                    this.print('\t');
                    continue;
                }
                if (c >= ' ' && c <= '~') {
                    this.print(c);
                    continue;
                }
                this.print(ENTITY_CODE_PREFIX);
                this.print((int)c);
                this.print(';');
            }
        }
    }

    public void writeEncodedAttribute(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '<') {
                this.print(LESS_THAN_ENTITY);
                continue;
            }
            if (c == '>') {
                this.print(GREATER_THAN_ENTITY);
                continue;
            }
            if (c == '&') {
                this.print(AMPERSAND_ENTITY);
                continue;
            }
            if (c == '\"') {
                this.print("&quot;");
                continue;
            }
            if (c == '\'') {
                this.print("&apos;");
                continue;
            }
            if (c >= ' ' && c <= '~') {
                this.print(c);
                continue;
            }
            this.print(ENTITY_CODE_PREFIX);
            this.print((int)c);
            this.print(';');
        }
    }

    public void writeAttribute(String string, boolean bl) {
        this.writeAttribute(string, bl ? "yes" : "no");
    }

    public void writeAttribute(String string, int n) {
        this.writeAttribute(string, Integer.toString(n));
    }

    public void writeAttribute(String string, long l) {
        this.writeAttribute(string, Long.toString(l));
    }

    public void writeAttribute(String string, float f) {
        this.writeAttribute(string, Float.toString(f));
    }

    public void writeAttribute(String string, double d) {
        this.writeAttribute(string, Double.toString(d));
    }

    public void writeAttribute(String string, String string2) {
        this.print(' ');
        this.print(string);
        this.print("=\"");
        this.writeEncodedAttribute(string2);
        this.print('\"');
    }

    public void writeAttributeNotZero(String string, int n) {
        if (n != 0) {
            this.writeAttribute(string, Integer.toString(n));
        }
    }

    public void writeAttributeNotZero(String string, long l) {
        if (l != 0L) {
            this.writeAttribute(string, Long.toString(l));
        }
    }

    public void writeAttributeNotZero(String string, float f) {
        if (f != 0.0f) {
            this.writeAttribute(string, Float.toString(f));
        }
    }

    public void writeAttributeNotZero(String string, double d) {
        if (d != 0.0) {
            this.writeAttribute(string, Double.toString(d));
        }
    }

    public void writeAttributeNotOne(String string, float f) {
        if (f != 1.0f) {
            this.writeAttribute(string, Float.toString(f));
        }
    }

    public void writeAttributeNotOne(String string, double d) {
        if (d != 1.0) {
            this.writeAttribute(string, Double.toString(d));
        }
    }

    public void simpleTagWithAttribute(String string, String string2, String string3, String string4) {
        this.startTag(string);
        this.writeAttribute(string3, string4);
        this.finishTag();
        this.writeEncodedData(string2);
        this.endTagEOL(string, false);
    }

    public void simpleTagWithAttribute(String string, String string2, String string3, boolean bl) {
        this.startTag(string);
        this.writeAttribute(string3, bl);
        this.finishTag();
        this.writeEncodedData(string2);
        this.endTagEOL(string, false);
    }

    public void simpleTagWithAttribute(String string, int n, String string2, boolean bl) {
        this.startTag(string);
        this.writeAttribute(string2, bl);
        this.finishTag();
        this.writeEncodedData(Integer.toString(n));
        this.endTagEOL(string, false);
    }

    public void simpleTagWithAttribute(String string, long l, String string2, boolean bl) {
        this.startTag(string);
        this.writeAttribute(string2, bl);
        this.finishTag();
        this.writeEncodedData(Long.toString(l));
        this.endTagEOL(string, false);
    }

    public void simpleTagWithAttribute(String string, double d, String string2, boolean bl) {
        this.startTag(string);
        this.writeAttribute(string2, bl);
        this.finishTag();
        this.writeEncodedData(this.toString(d));
        this.endTagEOL(string, false);
    }

    public void simpleTagWithAttribute(String string, String string2, String string3, int n) {
        this.startTag(string);
        this.writeAttribute(string3, n);
        this.finishTag();
        this.writeEncodedData(string2);
        this.endTagEOL(string, false);
    }

    public void simpleTagWithAttribute(String string, String string2, String string3, long l) {
        this.startTag(string);
        this.writeAttribute(string3, l);
        this.finishTag();
        this.writeEncodedData(string2);
        this.endTagEOL(string, false);
    }

    public void simpleTagWithAttribute(String string, double d, String string2, String string3) {
        this.startTag(string);
        this.writeAttribute(string2, string3);
        this.finishTag();
        this.writeEncodedData(this.toString(d));
        this.endTagEOL(string, false);
    }

    private String toString(double d) {
        String string = Double.toString(d);
        if (string.endsWith(".0")) {
            string = string.substring(0, string.length() - 2);
        }
        return string;
    }

    public void simpleTagWithAttribute(String string, int n, String string2, String string3) {
        this.startTag(string);
        this.writeAttribute(string2, string3);
        this.finishTag();
        this.writeEncodedData(Integer.toString(n));
        this.endTagEOL(string, false);
    }

    public void simpleTagWithAttribute(String string, long l, String string2, String string3) {
        this.startTag(string);
        this.writeAttribute(string2, string3);
        this.finishTag();
        this.writeEncodedData(Long.toString(l));
        this.endTagEOL(string, false);
    }

    public void simpleTag(String string, boolean bl) {
        this.simpleTag(string, Boolean.toString(bl));
    }

    public void simpleTag(String string, int n) {
        this.simpleTag(string, Integer.toString(n));
    }

    public void simpleTagNotZero(String string, int n) {
        if (n != 0) {
            this.simpleTag(string, Integer.toString(n));
        }
    }

    public void simpleTag(String string, long l) {
        this.simpleTag(string, Long.toString(l));
    }

    public void simpleTagNotZero(String string, long l) {
        if (l != 0L) {
            this.simpleTag(string, Long.toString(l));
        }
    }

    public void simpleTag(String string, double d) {
        this.simpleTag(string, this.toString(d));
    }

    public void simpleTag(String string, String string2) {
        this.startSimpleTag(string);
        this.writeEncodedData(string2);
        this.endTagEOL(string, false);
    }

    public void simpleTagNotEmpty(String string, String string2) {
        if (string2 != null && string2.length() != 0) {
            this.startSimpleTag(string);
            this.writeEncodedData(string2);
            this.endTagEOL(string, false);
        }
    }

    public void simpleTag(String string, Object object) {
        if (object != null) {
            this.simpleTag(string, object.toString());
        }
    }

    public void startSimpleTag(String string) {
        this.startTag(string);
        this.finishTag();
    }

    public void startSimpleTagEOL(String string) {
        this.startTag(string);
        this.finishTagEOL();
    }

    public void startTag(String string) {
        this.writeIndentation();
        this.print('<');
        this.print(string);
        this.indent();
    }

    public void endTagEOL(String string, boolean bl) {
        this.outdent();
        if (bl) {
            this.writeIndentation();
        }
        this.print("</");
        this.print(string);
        this.finishTagEOL();
    }

    public void finishTagEOL() {
        this.println('>');
    }

    public void finishTag() {
        this.print('>');
    }

    public void finishEmptyTagEOL() {
        this.println(END_TAG);
        this.outdent();
    }

    public void finishEmptyTag() {
        this.print(END_TAG);
        this.outdent();
    }

    public void indent() {
        ++this.mIndent;
    }

    public void outdent() {
        --this.mIndent;
    }

    public void writeIndentation() {
        for (int i = 0; i < this.mIndent; ++i) {
            this.print('\t');
        }
    }

    public void writeDateTimeTag(String string, long l, boolean bl, boolean bl2, boolean bl3) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(l);
        this.writeDateTimeTag(string, calendar, bl, bl2, bl3);
    }

    public void writeDateTimeTag(String string, Date date, boolean bl, boolean bl2, boolean bl3) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        this.writeDateTimeTag(string, calendar, bl, bl2, bl3);
    }

    public void writeDateTimeTag(String string, Calendar calendar, boolean bl, boolean bl2, boolean bl3) {
        this.startTag(string);
        if (bl) {
            this.writeAttribute(YEAR, calendar.get(1));
            this.writeAttribute(MONTH, calendar.get(2) + 1);
            this.writeAttribute(DAY, calendar.get(5));
        }
        if (bl2) {
            this.writeAttribute(HOUR, calendar.get(11));
            this.writeAttribute(MINUTE, calendar.get(12));
            if (bl3) {
                this.writeAttribute(SECOND, calendar.get(13));
            }
        }
        this.finishEmptyTagEOL();
    }

    public static String encodeData(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '<') {
                stringBuilder.append(LESS_THAN_ENTITY);
                continue;
            }
            if (c == '>') {
                stringBuilder.append(GREATER_THAN_ENTITY);
                continue;
            }
            if (c == '&') {
                stringBuilder.append(AMPERSAND_ENTITY);
                continue;
            }
            if (c >= ' ' && c <= '~') {
                stringBuilder.append(c);
                continue;
            }
            stringBuilder.append(ENTITY_CODE_PREFIX);
            stringBuilder.append((int)c);
            stringBuilder.append(';');
        }
        return stringBuilder.toString();
    }
}

