/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.collections;

import com.trollworks.ttk.collections.AreaObject;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashSet;

class AreaNode
implements AreaObject {
    private static final int MAX_PER_NODE = 4;
    private AreaNode mParent;
    private boolean mLeafNode;
    private Rectangle mBounds;
    private int mStorageCount;
    private AreaObject[] mStorage;

    public AreaNode() {
        this(null, true);
    }

    protected AreaNode(AreaNode areaNode, boolean bl) {
        this.mParent = areaNode;
        this.mLeafNode = bl;
        this.mBounds = new Rectangle(0, 0, 0, 0);
        this.mStorageCount = 0;
        this.mStorage = new AreaObject[5];
    }

    private void addLeavesToList(ArrayList<AreaObject> arrayList) {
        for (int i = 0; i < this.mStorageCount; ++i) {
            if (this.mLeafNode) {
                arrayList.add(this.mStorage[i]);
            } else {
                ((AreaNode)this.mStorage[i]).addLeavesToList(arrayList);
            }
            this.mStorage[i] = null;
        }
        this.mStorageCount = 0;
        this.mLeafNode = true;
    }

    private void adjustBounds() {
        if (this.mStorageCount > 0) {
            Rectangle rectangle = this.mStorage[0].getBounds();
            this.mBounds.x = rectangle.x;
            this.mBounds.y = rectangle.y;
            this.mBounds.width = rectangle.width;
            this.mBounds.height = rectangle.height;
            for (int i = 1; i < this.mStorageCount; ++i) {
                this.mBounds.add(this.mStorage[i].getBounds());
            }
        } else {
            this.mBounds.x = 0;
            this.mBounds.y = 0;
            this.mBounds.width = 0;
            this.mBounds.height = 0;
        }
    }

    protected boolean contains(AreaObject areaObject) {
        return this.findLeaf(areaObject) != null;
    }

    private AreaNode findLeaf(AreaObject areaObject) {
        Rectangle rectangle = areaObject.getBounds();
        for (int i = 0; i < this.mStorageCount; ++i) {
            if (!rectangle.intersects(this.mStorage[i].getBounds())) continue;
            if (!this.mLeafNode) {
                AreaNode areaNode = ((AreaNode)this.mStorage[i]).findLeaf(areaObject);
                if (areaNode == null) continue;
                return areaNode;
            }
            if (this.mStorage[i] != areaObject) continue;
            return this;
        }
        return null;
    }

    @Override
    public Rectangle getBounds() {
        return this.mBounds;
    }

    protected AreaNode insert(AreaObject areaObject) {
        AreaNode areaNode = this;
        AreaNode areaNode2 = null;
        AreaNode areaNode3 = this;
        Rectangle rectangle = areaObject.getBounds();
        while (!areaNode.mLeafNode) {
            long l = Long.MAX_VALUE;
            AreaNode areaNode4 = areaNode;
            for (int i = 0; i < areaNode4.mStorageCount; ++i) {
                AreaNode areaNode5 = (AreaNode)areaNode4.mStorage[i];
                Rectangle rectangle2 = areaNode5.getBounds();
                Rectangle rectangle3 = rectangle2.union(rectangle);
                long l2 = (long)rectangle3.height * (long)rectangle3.width - (long)rectangle2.height * (long)rectangle2.width;
                if (l2 > l) continue;
                l = l2;
                areaNode = areaNode5;
            }
        }
        areaNode.mStorage[areaNode.mStorageCount++] = areaObject;
        if (areaNode.mStorageCount > 4) {
            areaNode2 = this.splitNode(areaNode);
        }
        while (areaNode != null) {
            areaNode.adjustBounds();
            areaNode = areaNode.mParent;
            if (areaNode2 == null) continue;
            areaNode2.adjustBounds();
            if (areaNode == null) continue;
            areaNode.mStorage[areaNode.mStorageCount++] = areaNode2;
            areaNode2.mParent = areaNode;
            if (areaNode.mStorageCount > 4) {
                areaNode2 = this.splitNode(areaNode);
                continue;
            }
            areaNode2 = null;
        }
        if (areaNode2 != null) {
            this.mParent = areaNode3 = new AreaNode(null, false);
            areaNode2.mParent = areaNode3;
            areaNode3.mStorage[areaNode3.mStorageCount++] = this;
            areaNode3.mStorage[areaNode3.mStorageCount++] = areaNode2;
            areaNode3.adjustBounds();
        }
        return areaNode3;
    }

    protected AreaNode remove(AreaObject areaObject) {
        AreaNode areaNode = this.findLeaf(areaObject);
        AreaNode areaNode2 = this;
        if (areaNode != null) {
            ArrayList<AreaObject> arrayList = new ArrayList<AreaObject>();
            areaNode.mStorageCount = this.removeFromArray(areaNode.mStorageCount, areaNode.mStorage, areaObject);
            while (areaNode.mParent != null) {
                AreaNode areaNode3 = areaNode.mParent;
                if (areaNode.mStorageCount < 2) {
                    areaNode.addLeavesToList(arrayList);
                    areaNode3.mStorageCount = this.removeFromArray(areaNode3.mStorageCount, areaNode3.mStorage, areaNode);
                    if (areaNode3.mStorageCount == 0) {
                        areaNode3.mLeafNode = true;
                    }
                } else {
                    areaNode.adjustBounds();
                }
                areaNode = areaNode3;
            }
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                areaNode2 = areaNode2.insert(arrayList.get(i));
            }
            if (!areaNode2.mLeafNode && areaNode2.mStorageCount == 1) {
                areaNode2 = (AreaNode)areaNode2.mStorage[0];
                areaNode2.mParent = null;
            }
        }
        return areaNode2;
    }

    /*
     * WARNING - void declaration
     */
    protected AreaNode remove(ArrayList<AreaObject> arrayList) {
        AreaNode areaNode;
        AreaNode areaNode2 = this;
        HashSet<AreaNode> hashSet = new HashSet<AreaNode>();
        ArrayList<AreaObject> arrayList2 = new ArrayList<AreaObject>();
        for (AreaObject areaObject : arrayList) {
            areaNode = this.findLeaf(areaObject);
            if (areaNode == null) continue;
            hashSet.add(areaNode);
            areaNode.mStorageCount = this.removeFromArray(areaNode.mStorageCount, areaNode.mStorage, areaObject);
        }
        for (AreaNode areaNode3 : hashSet) {
            void var6_9;
            while (var6_9.mParent != null) {
                areaNode = var6_9.mParent;
                if (var6_9.mStorageCount < 2) {
                    super.addLeavesToList(arrayList2);
                    areaNode.mStorageCount = this.removeFromArray(areaNode.mStorageCount, areaNode.mStorage, (AreaObject)var6_9);
                    if (areaNode.mStorageCount == 0) {
                        areaNode.mLeafNode = true;
                    }
                    var6_9.mParent = null;
                } else {
                    super.adjustBounds();
                }
                AreaNode areaNode4 = areaNode;
            }
        }
        for (AreaObject areaObject : arrayList2) {
            areaNode2 = areaNode2.insert(areaObject);
        }
        if (!areaNode2.mLeafNode && areaNode2.mStorageCount == 1) {
            areaNode2 = (AreaNode)areaNode2.mStorage[0];
            areaNode2.mParent = null;
        }
        return areaNode2;
    }

    private int removeFromArray(int n, AreaObject[] areaObjectArray, AreaObject areaObject) {
        for (int i = 0; i < n; ++i) {
            if (areaObjectArray[i] != areaObject) continue;
            if (i != --n) {
                areaObjectArray[i] = areaObjectArray[n];
            }
            areaObjectArray[n] = null;
            break;
        }
        return n;
    }

    protected void search(Rectangle rectangle, ArrayList<AreaObject> arrayList, boolean bl) {
        for (int i = 0; i < this.mStorageCount; ++i) {
            Rectangle rectangle2 = this.mStorage[i].getBounds();
            if (rectangle != null && !rectangle.intersects(rectangle2)) continue;
            if (!this.mLeafNode) {
                ((AreaNode)this.mStorage[i]).search(rectangle, arrayList, bl);
                continue;
            }
            if (rectangle != null && bl && !rectangle.equals(rectangle2)) continue;
            arrayList.add(this.mStorage[i]);
        }
    }

    protected void search(Rectangle rectangle, ArrayList<AreaObject> arrayList, Class<? extends AreaObject> clazz) {
        for (int i = 0; i < this.mStorageCount; ++i) {
            Rectangle rectangle2 = this.mStorage[i].getBounds();
            if (rectangle != null && !rectangle.intersects(rectangle2)) continue;
            if (!this.mLeafNode) {
                ((AreaNode)this.mStorage[i]).search(rectangle, arrayList, clazz);
                continue;
            }
            if (!clazz.isInstance(this.mStorage[i])) continue;
            arrayList.add(this.mStorage[i]);
        }
    }

    protected void search(Point point, ArrayList<AreaObject> arrayList) {
        for (int i = 0; i < this.mStorageCount; ++i) {
            if (!this.mStorage[i].getBounds().contains(point)) continue;
            if (!this.mLeafNode) {
                ((AreaNode)this.mStorage[i]).search(point, arrayList);
                continue;
            }
            arrayList.add(this.mStorage[i]);
        }
    }

    protected void search(Point point, ArrayList<AreaObject> arrayList, Class<? extends AreaObject> clazz) {
        for (int i = 0; i < this.mStorageCount; ++i) {
            if (!this.mStorage[i].getBounds().contains(point)) continue;
            if (!this.mLeafNode) {
                ((AreaNode)this.mStorage[i]).search(point, arrayList);
                continue;
            }
            if (!clazz.isInstance(this.mStorage[i])) continue;
            arrayList.add(this.mStorage[i]);
        }
    }

    protected boolean searchHit(Point point) {
        for (int i = 0; i < this.mStorageCount; ++i) {
            if (!this.mStorage[i].getBounds().contains(point) || !this.mLeafNode && !((AreaNode)this.mStorage[i]).searchHit(point)) continue;
            return true;
        }
        return false;
    }

    protected boolean searchHit(Rectangle rectangle) {
        for (int i = 0; i < this.mStorageCount; ++i) {
            if (!rectangle.intersects(this.mStorage[i].getBounds()) || !this.mLeafNode && !((AreaNode)this.mStorage[i]).searchHit(rectangle)) continue;
            return true;
        }
        return false;
    }

    protected boolean searchHit(Rectangle rectangle, Class<? extends AreaObject> clazz) {
        for (int i = 0; i < this.mStorageCount; ++i) {
            if (!rectangle.intersects(this.mStorage[i].getBounds()) || !(this.mLeafNode ? clazz.isInstance(this.mStorage[i]) : ((AreaNode)this.mStorage[i]).searchHit(rectangle, clazz))) continue;
            return true;
        }
        return false;
    }

    protected int searchCount(Rectangle rectangle, boolean bl) {
        int n = 0;
        for (int i = 0; i < this.mStorageCount; ++i) {
            Rectangle rectangle2 = this.mStorage[i].getBounds();
            if (rectangle != null && !rectangle.intersects(rectangle2)) continue;
            if (!this.mLeafNode) {
                n += ((AreaNode)this.mStorage[i]).searchCount(rectangle, bl);
                continue;
            }
            if (rectangle != null && bl && !rectangle.equals(rectangle2)) continue;
            ++n;
        }
        return n;
    }

    protected int searchCount(Point point) {
        int n = 0;
        for (int i = 0; i < this.mStorageCount; ++i) {
            if (!this.mStorage[i].getBounds().contains(point)) continue;
            if (!this.mLeafNode) {
                n += ((AreaNode)this.mStorage[i]).searchCount(point);
                continue;
            }
            ++n;
        }
        return n;
    }

    private AreaNode splitNode(AreaNode areaNode) {
        AreaObject[] areaObjectArray = new AreaObject[5];
        int n = areaNode.mStorageCount;
        int n2 = -1;
        AreaObject areaObject = null;
        AreaObject areaObject2 = null;
        boolean bl = true;
        if (n > 0) {
            System.arraycopy(areaNode.mStorage, 0, areaObjectArray, 0, areaNode.mStorageCount);
        }
        AreaNode areaNode2 = new AreaNode(areaNode.mParent, areaNode.mLeafNode);
        for (int i = 0; i < n - 1; ++i) {
            for (int j = i + 1; j < n; ++j) {
                int n3 = this.areaWasted(areaObjectArray[i].getBounds(), areaObjectArray[j].getBounds());
                if (n3 < n2) continue;
                n2 = n3;
                areaObject = areaObjectArray[i];
                areaObject2 = areaObjectArray[j];
            }
        }
        while (areaNode.mStorageCount > 0) {
            areaNode.mStorage[--areaNode.mStorageCount] = null;
        }
        areaNode.mStorage[areaNode.mStorageCount++] = areaObject;
        Rectangle rectangle = areaObject.getBounds();
        areaNode.mBounds.x = rectangle.x;
        areaNode.mBounds.y = rectangle.y;
        areaNode.mBounds.width = rectangle.width;
        areaNode.mBounds.height = rectangle.height;
        n = this.removeFromArray(n, areaObjectArray, areaObject);
        if (!areaNode.mLeafNode) {
            ((AreaNode)areaObject).mParent = areaNode;
        }
        areaNode2.mStorage[areaNode2.mStorageCount++] = areaObject2;
        n = this.removeFromArray(n, areaObjectArray, areaObject2);
        rectangle = areaObject2.getBounds();
        areaNode2.mBounds.x = rectangle.x;
        areaNode2.mBounds.y = rectangle.y;
        areaNode2.mBounds.width = rectangle.width;
        areaNode2.mBounds.height = rectangle.height;
        if (!areaNode2.mLeafNode) {
            ((AreaNode)areaObject2).mParent = areaNode2;
        }
        while (n > 0) {
            if (bl) {
                n = areaNode.transferFromLargestOverlap(n, areaObjectArray);
                bl = false;
                continue;
            }
            n = areaNode2.transferFromLargestOverlap(n, areaObjectArray);
            bl = true;
        }
        return areaNode2;
    }

    private int transferFromLargestOverlap(int n, AreaObject[] areaObjectArray) {
        int n2 = Integer.MAX_VALUE;
        int n3 = -1;
        for (int i = 0; i < n; ++i) {
            int n4 = this.areaWasted(this.mBounds, areaObjectArray[i].getBounds());
            if (n4 > n2) continue;
            n2 = n4;
            n3 = i;
        }
        this.mBounds.union(areaObjectArray[n3].getBounds());
        this.mStorage[this.mStorageCount++] = areaObjectArray[n3];
        if (!this.mLeafNode) {
            ((AreaNode)areaObjectArray[n3]).mParent = this;
        }
        if (n3 != --n) {
            areaObjectArray[n3] = areaObjectArray[n];
        }
        areaObjectArray[n] = null;
        return n;
    }

    private int areaWasted(Rectangle rectangle, Rectangle rectangle2) {
        if (rectangle.width > 0 && rectangle.height > 0 && rectangle2.width > 0 && rectangle2.height > 0) {
            long l = (long)rectangle.width * (long)rectangle.height + (long)rectangle2.width * (long)rectangle2.height;
            Rectangle rectangle3 = rectangle.union(rectangle2);
            long l2 = (long)rectangle3.height * (long)rectangle3.width;
            Rectangle rectangle4 = rectangle.intersection(rectangle2);
            long l3 = (long)rectangle4.height * (long)rectangle4.width;
            return (int)((l2 - (l - l3)) * 100L / l);
        }
        return 0x3FFFFFFF;
    }
}

