/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.conduit;

import com.trollworks.ttk.conduit.ConduitMessage;
import com.trollworks.ttk.conduit.ConduitReceiver;
import com.trollworks.ttk.conduit.Server;
import com.trollworks.ttk.utility.Debug;
import java.awt.EventQueue;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;

public class Conduit
implements Runnable {
    public static final int DEFAULT_PORT = 13321;
    private InetSocketAddress mSocketAddress;
    private Server mServer;
    private Socket mSocket;
    private DataInputStream mInput;
    private DataOutputStream mOutput;
    private ConduitReceiver mReceiver;
    private boolean mOnEventThread;
    private Thread mReceptionThread;
    private String mUserFilter;
    private String mIDFilter;

    public Conduit(ConduitReceiver conduitReceiver, boolean bl) {
        this(null, conduitReceiver, bl);
    }

    public Conduit(int n, ConduitReceiver conduitReceiver, boolean bl) {
        this(new InetSocketAddress(Conduit.getLoopBackAddress(), n), conduitReceiver, bl);
    }

    public Conduit(InetAddress inetAddress, int n, ConduitReceiver conduitReceiver, boolean bl) {
        this(new InetSocketAddress(inetAddress, n), conduitReceiver, bl);
    }

    public Conduit(InetSocketAddress inetSocketAddress, ConduitReceiver conduitReceiver, boolean bl) {
        if (inetSocketAddress == null) {
            inetSocketAddress = new InetSocketAddress(Conduit.getLoopBackAddress(), 13321);
        }
        this.mSocketAddress = inetSocketAddress;
        this.mReceiver = conduitReceiver;
        this.mOnEventThread = bl;
        this.mReceptionThread = new Thread((Runnable)this, Conduit.class.getSimpleName() + '@' + this.mSocketAddress);
        this.mUserFilter = this.mReceiver.getConduitMessageUserFilter();
        this.mIDFilter = this.mReceiver.getConduitMessageIDFilter();
        this.reconnect();
        this.mReceptionThread.setPriority(5);
        this.mReceptionThread.setDaemon(true);
        this.mReceptionThread.start();
    }

    private static final InetAddress getLoopBackAddress() {
        try {
            return InetAddress.getByName(null);
        }
        catch (UnknownHostException unknownHostException) {
            assert (false) : Debug.throwableToString(unknownHostException);
            return null;
        }
    }

    private void reconnect() {
        this.shutdownSocket();
        if (this.mServer != null) {
            this.mServer.shutdown();
            this.mServer = null;
        }
        while (true) {
            try {
                this.mServer = new Server(this.mSocketAddress);
                this.mServer.setDaemon(true);
                this.mServer.start();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.mSocket = new Socket();
            try {
                this.mSocket.connect(this.mSocketAddress);
                this.mInput = new DataInputStream(this.mSocket.getInputStream());
                this.mOutput = new DataOutputStream(this.mSocket.getOutputStream());
                return;
            }
            catch (Exception exception) {
                this.shutdownSocket();
                continue;
            }
            break;
        }
    }

    public void send(ConduitMessage conduitMessage) {
        while (true) {
            try {
                conduitMessage.send(this.mOutput);
                return;
            }
            catch (Exception exception) {
                this.reconnect();
                continue;
            }
            break;
        }
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    ConduitMessage conduitMessage = new ConduitMessage(this.mInput);
                    if (this.mUserFilter != null && !this.mUserFilter.equals(conduitMessage.getUser()) || this.mIDFilter != null && !this.mIDFilter.equals(conduitMessage.getID())) continue;
                    if (this.mOnEventThread) {
                        conduitMessage.setReceiver(this.mReceiver);
                        EventQueue.invokeLater(conduitMessage);
                        continue;
                    }
                    this.mReceiver.conduitMessageReceived(conduitMessage);
                }
            }
            catch (Exception exception) {
                this.reconnect();
                continue;
            }
            break;
        }
    }

    private void shutdownSocket() {
        if (this.mSocket != null) {
            try {
                this.mSocket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.mSocket = null;
            this.mInput = null;
            this.mOutput = null;
        }
    }
}

