/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.conduit;

import com.trollworks.ttk.conduit.Client;
import com.trollworks.ttk.conduit.Conduit;
import com.trollworks.ttk.conduit.ConduitMessage;
import com.trollworks.ttk.utility.Debug;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;

class Server
extends Thread {
    private ServerSocket mServerSocket;
    private ArrayList<Client> mClients;
    private Object mSendLock;
    private int mClientCounter;

    Server(InetSocketAddress inetSocketAddress) throws IOException {
        super(Conduit.class.getSimpleName() + '$' + Server.class.getSimpleName() + '@' + inetSocketAddress);
        this.setPriority(5);
        this.setDaemon(true);
        this.mServerSocket = new ServerSocket(inetSocketAddress.getPort(), 0, inetSocketAddress.getAddress());
        this.mClients = new ArrayList();
        this.mSendLock = new Object();
    }

    int getNextClientCounter() {
        return ++this.mClientCounter;
    }

    ServerSocket getServerSocket() {
        return this.mServerSocket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block10: while (true) {
            try {
                while (true) {
                    Socket socket = this.mServerSocket.accept();
                    try {
                        Client client = new Client(this, socket);
                        client.setDaemon(true);
                        client.start();
                        ArrayList<Client> arrayList = this.mClients;
                        synchronized (arrayList) {
                            this.mClients.add(client);
                            continue block10;
                        }
                    }
                    catch (IOException iOException) {
                        socket.close();
                        continue;
                    }
                    break;
                }
            }
            catch (Exception exception) {
                this.shutdown();
                Client[] clientArray = this.mClients;
                synchronized (this.mClients) {
                    Client[] clientArray2 = this.mClients.toArray(new Client[0]);
                    this.mClients.clear();
                    // ** MonitorExit[var2_6] (shouldn't be in output)
                    for (Client client : clientArray2) {
                        client.shutdown();
                    }
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(Client client) {
        ArrayList<Client> arrayList = this.mClients;
        synchronized (arrayList) {
            this.mClients.remove(client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void send(ConduitMessage conduitMessage) {
        Client[] clientArray;
        Object object = this.mClients;
        synchronized (object) {
            clientArray = this.mClients.toArray(new Client[0]);
        }
        object = this.mSendLock;
        synchronized (object) {
            for (Client client : clientArray) {
                client.send(conduitMessage);
            }
        }
    }

    synchronized void shutdown() {
        block2: {
            try {
                this.mServerSocket.close();
            }
            catch (Exception exception) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError((Object)Debug.throwableToString(exception));
            }
        }
    }
}

