/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.layout;

import com.trollworks.ttk.layout.RowDistribution;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;

public class ColumnLayout
implements LayoutManager2 {
    public static final int DEFAULT_H_GAP_SIZE = 5;
    public static final int DEFAULT_V_GAP_SIZE = 2;
    private int mColumns;
    private int mHGap;
    private int mVGap;
    private RowDistribution mDistribution;

    public ColumnLayout() {
        this(1, 5, 2, RowDistribution.USE_PREFERRED_HEIGHT);
    }

    public ColumnLayout(int n) {
        this(n, 5, 2, RowDistribution.USE_PREFERRED_HEIGHT);
    }

    public ColumnLayout(int n, RowDistribution rowDistribution) {
        this(n, 5, 2, rowDistribution);
    }

    public ColumnLayout(int n, int n2, int n3) {
        this(n, n2, n3, RowDistribution.USE_PREFERRED_HEIGHT);
    }

    public ColumnLayout(int n, int n2, int n3, RowDistribution rowDistribution) {
        if (n < 1) {
            throw new IllegalArgumentException("columns must be greater than zero");
        }
        this.mColumns = n;
        this.mHGap = n2;
        this.mVGap = n3;
        this.mDistribution = rowDistribution;
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
    }

    @Override
    public void addLayoutComponent(Component component, Object object) {
    }

    public int getColumns() {
        return this.mColumns;
    }

    public RowDistribution getHeightDistribution() {
        return this.mDistribution;
    }

    public int getHorizontalGap() {
        return this.mHGap;
    }

    public int getVerticalGap() {
        return this.mVGap;
    }

    @Override
    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    @Override
    public void invalidateLayout(Container container) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            Component component;
            int n7;
            Dimension dimension = container.getSize();
            Insets insets = container.getInsets();
            int n8 = container.getComponentCount();
            int n9 = insets.top;
            int n10 = 1 + (n8 - 1) / this.mColumns;
            int[] nArray = new int[this.mColumns];
            int[] nArray2 = new int[this.mColumns];
            int[] nArray3 = new int[this.mColumns];
            int[] nArray4 = new int[n10];
            int n11 = dimension.width - (insets.left + insets.right + (this.mColumns - 1) * this.mHGap);
            int n12 = dimension.height - (insets.top + insets.bottom + (n10 - 1) * this.mVGap);
            Dimension[] dimensionArray = new Dimension[n8];
            Dimension[] dimensionArray2 = new Dimension[n8];
            Dimension[] dimensionArray3 = new Dimension[n8];
            for (n7 = 0; n7 < n8; ++n7) {
                component = container.getComponent(n7);
                dimensionArray[n7] = component.getPreferredSize();
                dimensionArray2[n7] = component.getMaximumSize();
                dimensionArray3[n7] = component.getMinimumSize();
            }
            for (n7 = 0; n7 < n8; n7 += this.mColumns) {
                for (n6 = n7; n6 < n7 + this.mColumns && n6 < n8; ++n6) {
                    n5 = dimensionArray[n6].width;
                    int n13 = n6 - n7;
                    if (n5 > nArray[n13]) {
                        nArray[n13] = n5;
                    }
                    if ((n5 = dimensionArray3[n6].width) > nArray2[n13]) {
                        nArray2[n13] = n5;
                    }
                    if ((n5 = dimensionArray2[n6].width) <= nArray3[n13]) continue;
                    nArray3[n13] = n5;
                }
            }
            for (n7 = 0; n7 < this.mColumns; ++n7) {
                n11 -= nArray[n7];
            }
            n6 = this.mColumns;
            if (n11 > 0) {
                while (n11 > 0 && n6 > 0) {
                    n4 = n11 / n6;
                    if (n4 == 0) {
                        n4 = 1;
                    }
                    n6 = 0;
                    for (n7 = 0; n7 < this.mColumns && n11 != 0; ++n7) {
                        if (nArray[n7] < nArray3[n7]) {
                            if (nArray[n7] + n4 <= nArray3[n7]) {
                                int n14 = n7;
                                nArray[n14] = nArray[n14] + n4;
                                n11 -= n4;
                            } else {
                                n11 -= nArray3[n7] - nArray[n7];
                                nArray[n7] = nArray3[n7];
                            }
                        }
                        if (nArray[n7] < nArray3[n7]) {
                            ++n6;
                        }
                        if (n4 <= n11) continue;
                        n4 = n11;
                    }
                }
            } else if (n11 < 0) {
                n11 = -n11;
                while (n11 > 0 && n6 > 0) {
                    n4 = n11 / n6;
                    if (n4 == 0) {
                        n4 = 1;
                    }
                    n6 = 0;
                    for (n7 = 0; n7 < this.mColumns && n11 != 0; ++n7) {
                        if (nArray[n7] > nArray2[n7]) {
                            if (nArray[n7] - n4 >= nArray2[n7]) {
                                int n15 = n7;
                                nArray[n15] = nArray[n15] - n4;
                                n11 -= n4;
                            } else {
                                n11 -= nArray[n7] - nArray2[n7];
                                nArray[n7] = nArray2[n7];
                            }
                        }
                        if (nArray[n7] > nArray2[n7]) {
                            ++n6;
                        }
                        if (n4 <= n11) continue;
                        n4 = n11;
                    }
                }
            }
            n4 = n12;
            for (n7 = 0; n7 < n10; ++n7) {
                nArray4[n7] = 0;
                for (n6 = 0; n6 < this.mColumns; ++n6) {
                    n3 = n7 * this.mColumns + n6;
                    if (n3 >= n8 || (n3 = dimensionArray[n3].height) <= nArray4[n7]) continue;
                    nArray4[n7] = n3;
                }
                n4 -= nArray4[n7];
            }
            int n16 = n10;
            while (n4 < 0 && n16 > 0) {
                n5 = n16 > 1 ? 1 + -n4 / n16 : -n4;
                n16 = 0;
                for (n7 = 0; n7 < n10; ++n7) {
                    n2 = nArray4[n7] - n5;
                    n = 1;
                    for (n6 = 0; n6 < this.mColumns; ++n6) {
                        int n17;
                        n3 = n7 * this.mColumns + n6;
                        if (n3 >= n8 || (n17 = dimensionArray3[n3].height) <= n2) continue;
                        if (n17 < nArray4[n7]) {
                            n2 = n17;
                            continue;
                        }
                        n = 0;
                        break;
                    }
                    if (n == 0) continue;
                    n4 += nArray4[n7] - n2;
                    nArray4[n7] = n2;
                    ++n16;
                }
            }
            if (n4 > 0 && n10 > 0) {
                if (this.mDistribution == RowDistribution.DISTRIBUTE_HEIGHT) {
                    n6 = n4 / n10;
                    if (n6 > 0) {
                        n7 = 0;
                        while (n7 < n10) {
                            int n18 = n7++;
                            nArray4[n18] = nArray4[n18] + n6;
                        }
                    }
                    n7 = 0;
                    while (n7 < n4 - n6 * n10) {
                        int n19 = n7++;
                        nArray4[n19] = nArray4[n19] + 1;
                    }
                } else if (this.mDistribution == RowDistribution.GIVE_EXCESS_TO_LAST) {
                    int n20 = n10 - 1;
                    nArray4[n20] = nArray4[n20] + n4;
                }
            }
            for (n7 = 0; n7 < n10; ++n7) {
                n5 = insets.left;
                for (n6 = 0; n6 < this.mColumns; ++n6) {
                    n3 = n7 * this.mColumns + n6;
                    if (n3 >= n8) continue;
                    n2 = n9;
                    n = nArray4[n7];
                    if (n < dimensionArray3[n3].height) {
                        n = dimensionArray3[n3].height;
                    }
                    component = container.getComponent(n3);
                    if (n > dimensionArray2[n3].height) {
                        float f = component.getAlignmentY();
                        n = dimensionArray2[n3].height;
                        if ((double)f >= 0.75) {
                            n2 += nArray4[n7] - n;
                        } else if ((double)f >= 0.25) {
                            n2 += (nArray4[n7] - n) / 2;
                        }
                    }
                    component.setBounds(n5, n2, nArray[n6], n);
                    n5 += nArray[n6] + this.mHGap;
                }
                n9 += nArray4[n7] + this.mVGap;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension maximumLayoutSize(Container container) {
        long l = 0L;
        long l2 = (this.mColumns - 1) * this.mHGap;
        Object object = container.getTreeLock();
        synchronized (object) {
            int n;
            Insets insets = container.getInsets();
            int n2 = container.getComponentCount();
            int[] nArray = new int[this.mColumns];
            int n3 = 1 + (n2 - 1) / this.mColumns;
            l2 += (long)(insets.left + insets.right);
            for (int i = 0; i < n3; ++i) {
                int n4 = 0;
                for (int j = 0; j < this.mColumns; ++j) {
                    n = i * this.mColumns + j;
                    if (n >= n2) continue;
                    Dimension dimension = container.getComponent(n).getMaximumSize();
                    if (dimension.height > n4) {
                        n4 = dimension.height;
                    }
                    if (dimension.width <= nArray[j]) continue;
                    nArray[j] = dimension.width;
                }
                l += (long)n4;
            }
            l += (long)(insets.top + insets.bottom);
            if (n3 > 0) {
                l += (long)((n3 - 1) * this.mVGap);
            }
            for (n = 0; n < this.mColumns; ++n) {
                l2 += (long)nArray[n];
            }
        }
        if (l2 > 0x3FFFFFL) {
            l2 = 0x3FFFFFL;
        }
        if (l > 0x3FFFFFL) {
            l = 0x3FFFFFL;
        }
        return new Dimension((int)l2, (int)l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension minimumLayoutSize(Container container) {
        int n = 0;
        int n2 = (this.mColumns - 1) * this.mHGap;
        Object object = container.getTreeLock();
        synchronized (object) {
            int n3;
            Insets insets = container.getInsets();
            int n4 = container.getComponentCount();
            int[] nArray = new int[this.mColumns];
            int n5 = 1 + (n4 - 1) / this.mColumns;
            n2 += insets.left + insets.right;
            for (int i = 0; i < n5; ++i) {
                int n6 = 0;
                for (int j = 0; j < this.mColumns; ++j) {
                    n3 = i * this.mColumns + j;
                    if (n3 >= n4) continue;
                    Dimension dimension = container.getComponent(n3).getMinimumSize();
                    if (dimension.width > nArray[j]) {
                        nArray[j] = dimension.width;
                    }
                    if (dimension.height <= n6) continue;
                    n6 = dimension.height;
                }
                n += n6;
            }
            n += insets.top + insets.bottom;
            if (n5 > 0) {
                n += (n5 - 1) * this.mVGap;
            }
            for (n3 = 0; n3 < this.mColumns; ++n3) {
                n2 += nArray[n3];
            }
        }
        return new Dimension(n2, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension preferredLayoutSize(Container container) {
        int n = 0;
        int n2 = (this.mColumns - 1) * this.mHGap;
        Object object = container.getTreeLock();
        synchronized (object) {
            int n3;
            Insets insets = container.getInsets();
            int n4 = container.getComponentCount();
            int[] nArray = new int[this.mColumns];
            int n5 = 1 + (n4 - 1) / this.mColumns;
            n2 += insets.left + insets.right;
            for (int i = 0; i < n5; ++i) {
                int n6 = 0;
                for (int j = 0; j < this.mColumns; ++j) {
                    n3 = i * this.mColumns + j;
                    if (n3 >= n4) continue;
                    Dimension dimension = container.getComponent(n3).getPreferredSize();
                    if (dimension.height > n6) {
                        n6 = dimension.height;
                    }
                    if (dimension.width <= nArray[j]) continue;
                    nArray[j] = dimension.width;
                }
                n += n6;
            }
            n += insets.top + insets.bottom;
            if (n5 > 0) {
                n += (n5 - 1) * this.mVGap;
            }
            for (n3 = 0; n3 < this.mColumns; ++n3) {
                n2 += nArray[n3];
            }
        }
        return new Dimension(n2, n);
    }

    @Override
    public void removeLayoutComponent(Component component) {
    }
}

