/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.layout;

import com.trollworks.ttk.layout.Alignment;
import com.trollworks.ttk.layout.FlexCell;
import com.trollworks.ttk.layout.LayoutSize;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;

public class FlexComponent
extends FlexCell {
    private Component mComponent;
    private boolean mOnlyPreferredSize;

    public FlexComponent(Component component) {
        this.mComponent = component;
    }

    public FlexComponent(Component component, boolean bl) {
        this.mComponent = component;
        this.mOnlyPreferredSize = bl;
    }

    public FlexComponent(Component component, Alignment alignment, Alignment alignment2) {
        this.mComponent = component;
        if (alignment != null) {
            this.setHorizontalAlignment(alignment);
        }
        if (alignment2 != null) {
            this.setVerticalAlignment(alignment2);
        }
    }

    public void setOnlyPreferredSize(boolean bl) {
        this.mOnlyPreferredSize = bl;
    }

    @Override
    protected Dimension getSizeSelf(LayoutSize layoutSize) {
        if (this.mOnlyPreferredSize) {
            layoutSize = LayoutSize.PREFERRED;
        }
        return layoutSize.get(this.mComponent);
    }

    @Override
    protected void layoutSelf(Rectangle rectangle) {
        Rectangle rectangle2 = new Rectangle(rectangle);
        if (!this.mOnlyPreferredSize) {
            Dimension dimension = LayoutSize.MINIMUM.get(this.mComponent);
            if (rectangle2.width < dimension.width) {
                rectangle2.width = dimension.width;
            }
            if (rectangle2.height < dimension.height) {
                rectangle2.height = dimension.height;
            }
            dimension = LayoutSize.MAXIMUM.get(this.mComponent);
            if (rectangle2.width > dimension.width) {
                rectangle2.width = dimension.width;
            }
            if (rectangle2.height > dimension.height) {
                rectangle2.height = dimension.height;
            }
        }
        this.mComponent.setBounds(Alignment.position(rectangle, rectangle2, this.getHorizontalAlignment(), this.getVerticalAlignment()));
    }

    @Override
    public String toString() {
        return this.mComponent.getClass().getSimpleName();
    }
}

