/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.layout;

import java.awt.Component;
import java.awt.Dimension;
import java.util.StringTokenizer;

public final class PrecisionLayoutData {
    public static final String KEY_HALIGN = "hAlign";
    public static final String KEY_VALIGN = "vAlign";
    public static final String KEY_WIDTH = "width";
    public static final String KEY_HEIGHT = "height";
    public static final String KEY_MIN_WIDTH = "minWidth";
    public static final String KEY_MIN_HEIGHT = "minHeight";
    public static final String KEY_HSPAN = "hSpan";
    public static final String KEY_VSPAN = "vSpan";
    public static final String KEY_HGRAB = "hGrab";
    public static final String KEY_VGRAB = "vGrab";
    public static final String KEY_EXCLUDE = "exclude";
    public static final String KEY_MARGINS = "margins";
    public static final String KEY_TOP = "top";
    public static final String KEY_LEFT = "left";
    public static final String KEY_BOTTOM = "bottom";
    public static final String KEY_RIGHT = "right";
    public static final String VALUE_BEGINNING = "beginning";
    public static final String VALUE_MIDDLE = "middle";
    public static final String VALUE_END = "end";
    public static final String VALUE_FILL = "fill";
    public static final int DEFAULT = -1;
    public static final int BEGINNING = 0;
    public static final int MIDDLE = 1;
    public static final int END = 2;
    public static final int FILL = 3;
    public int mVAlign = 1;
    public int mHAlign = 0;
    public int mWidthHint = -1;
    public int mHeightHint = -1;
    public int mMarginTop = 0;
    public int mMarginLeft = 0;
    public int mMarginBottom = 0;
    public int mMarginRight = 0;
    public int mHSpan = 1;
    public int mVSpan = 1;
    public boolean mHGrab = false;
    public boolean mVGrab = false;
    public int mMinWidth = -1;
    public int mMinHeight = -1;
    public boolean mExclude = false;
    int mCacheMinWidth;
    int mCacheWidth;
    int mCacheHeight;

    public PrecisionLayoutData() {
    }

    public PrecisionLayoutData(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n = string2.indexOf(58);
            String string3 = string2.substring(0, n);
            String string4 = string2.substring(n + 1);
            if (KEY_HALIGN.equalsIgnoreCase(string3)) {
                this.mHAlign = PrecisionLayoutData.decodeAlignment(string4, true);
                continue;
            }
            if (KEY_VALIGN.equalsIgnoreCase(string3)) {
                this.mVAlign = PrecisionLayoutData.decodeAlignment(string4, true);
                continue;
            }
            if (KEY_WIDTH.equalsIgnoreCase(string3)) {
                this.mWidthHint = Integer.parseInt(string4);
                continue;
            }
            if (KEY_HEIGHT.equalsIgnoreCase(string3)) {
                this.mHeightHint = Integer.parseInt(string4);
                continue;
            }
            if (KEY_MIN_WIDTH.equalsIgnoreCase(string3)) {
                this.mMinWidth = Integer.parseInt(string4);
                continue;
            }
            if (KEY_MIN_HEIGHT.equalsIgnoreCase(string3)) {
                this.mMinHeight = Integer.parseInt(string4);
                continue;
            }
            if (KEY_HSPAN.equalsIgnoreCase(string3)) {
                this.mHSpan = Integer.parseInt(string4);
                continue;
            }
            if (KEY_VSPAN.equalsIgnoreCase(string3)) {
                this.mVSpan = Integer.parseInt(string4);
                continue;
            }
            if (KEY_HGRAB.equalsIgnoreCase(string3)) {
                this.mHGrab = PrecisionLayoutData.decodeBoolean(string4);
                continue;
            }
            if (KEY_VGRAB.equalsIgnoreCase(string3)) {
                this.mVGrab = PrecisionLayoutData.decodeBoolean(string4);
                continue;
            }
            if (KEY_EXCLUDE.equalsIgnoreCase(string3)) {
                this.mExclude = PrecisionLayoutData.decodeBoolean(string4);
                continue;
            }
            if (KEY_MARGINS.equalsIgnoreCase(string3)) {
                this.mMarginLeft = this.mMarginTop = Integer.parseInt(string4);
                this.mMarginBottom = this.mMarginTop;
                this.mMarginRight = this.mMarginTop;
                continue;
            }
            if (KEY_TOP.equalsIgnoreCase(string3)) {
                this.mMarginTop = Integer.parseInt(string4);
                continue;
            }
            if (KEY_LEFT.equalsIgnoreCase(string3)) {
                this.mMarginLeft = Integer.parseInt(string4);
                continue;
            }
            if (KEY_BOTTOM.equalsIgnoreCase(string3)) {
                this.mMarginBottom = Integer.parseInt(string4);
                continue;
            }
            if (KEY_RIGHT.equalsIgnoreCase(string3)) {
                this.mMarginRight = Integer.parseInt(string4);
                continue;
            }
            throw new IllegalArgumentException(string2);
        }
    }

    static boolean decodeBoolean(String string) {
        return "true".equalsIgnoreCase(string) || "yes".equalsIgnoreCase(string) || "y".equalsIgnoreCase(string) || "1".equalsIgnoreCase(string);
    }

    static int decodeAlignment(String string, boolean bl) {
        if (VALUE_BEGINNING.equalsIgnoreCase(string)) {
            return 0;
        }
        if (VALUE_MIDDLE.equalsIgnoreCase(string)) {
            return 1;
        }
        if (VALUE_END.equalsIgnoreCase(string)) {
            return 2;
        }
        if (bl && VALUE_FILL.equalsIgnoreCase(string)) {
            return 3;
        }
        throw new IllegalArgumentException(string);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        PrecisionLayoutData.emitAlign(KEY_HALIGN, this.mHAlign, stringBuilder);
        PrecisionLayoutData.emitAlign(KEY_VALIGN, this.mVAlign, stringBuilder);
        PrecisionLayoutData.emit(KEY_WIDTH, this.mWidthHint, stringBuilder);
        PrecisionLayoutData.emit(KEY_HEIGHT, this.mHeightHint, stringBuilder);
        PrecisionLayoutData.emit(KEY_MIN_WIDTH, this.mMinWidth, stringBuilder);
        PrecisionLayoutData.emit(KEY_MIN_HEIGHT, this.mMinHeight, stringBuilder);
        PrecisionLayoutData.emit(KEY_HSPAN, this.mHSpan, stringBuilder);
        PrecisionLayoutData.emit(KEY_VSPAN, this.mVSpan, stringBuilder);
        PrecisionLayoutData.emit(KEY_HGRAB, this.mHGrab, stringBuilder);
        PrecisionLayoutData.emit(KEY_VGRAB, this.mVGrab, stringBuilder);
        if (this.mMarginTop == this.mMarginLeft && this.mMarginTop == this.mMarginBottom && this.mMarginTop == this.mMarginRight) {
            PrecisionLayoutData.emit(KEY_MARGINS, this.mMarginTop, stringBuilder);
        } else {
            PrecisionLayoutData.emit(KEY_TOP, this.mMarginTop, stringBuilder);
            PrecisionLayoutData.emit(KEY_LEFT, this.mMarginLeft, stringBuilder);
            PrecisionLayoutData.emit(KEY_BOTTOM, this.mMarginBottom, stringBuilder);
            PrecisionLayoutData.emit(KEY_RIGHT, this.mMarginBottom, stringBuilder);
        }
        PrecisionLayoutData.emit(KEY_EXCLUDE, this.mExclude, stringBuilder);
        return stringBuilder.toString();
    }

    static void emit(String string, boolean bl, StringBuilder stringBuilder) {
        if (stringBuilder.length() > 0) {
            stringBuilder.append(' ');
        }
        stringBuilder.append(string);
        stringBuilder.append(':');
        stringBuilder.append(bl);
    }

    static void emit(String string, int n, StringBuilder stringBuilder) {
        if (stringBuilder.length() > 0) {
            stringBuilder.append(' ');
        }
        stringBuilder.append(string);
        stringBuilder.append(':');
        stringBuilder.append(n);
    }

    static void emitAlign(String string, int n, StringBuilder stringBuilder) {
        if (stringBuilder.length() > 0) {
            stringBuilder.append(' ');
        }
        stringBuilder.append(string);
        stringBuilder.append(':');
        if (n == 0) {
            stringBuilder.append(VALUE_BEGINNING);
        } else if (n == 1) {
            stringBuilder.append(VALUE_MIDDLE);
        } else if (n == 2) {
            stringBuilder.append(VALUE_END);
        } else if (n == 3) {
            stringBuilder.append(VALUE_FILL);
        } else {
            stringBuilder.append(n);
        }
    }

    void computeSize(Component component, int n, int n2, boolean bl) {
        Dimension dimension = null;
        if (n != -1 || n2 != -1) {
            int n3;
            dimension = component.getMinimumSize();
            int n4 = this.mCacheMinWidth = this.mMinWidth != -1 ? this.mMinWidth : dimension.width;
            if (n != -1 && n < this.mCacheMinWidth) {
                n = this.mCacheMinWidth;
            }
            int n5 = n3 = this.mMinHeight != -1 ? this.mMinHeight : dimension.height;
            if (n2 != -1 && n2 < n3) {
                n2 = n3;
            }
            dimension = component.getMaximumSize();
            if (n != -1 && n > dimension.width) {
                n = dimension.width;
            }
            if (n2 != -1 && n2 > dimension.height) {
                n2 = dimension.height;
            }
        }
        if (bl) {
            dimension = component.getMinimumSize();
            this.mCacheMinWidth = this.mMinWidth != -1 ? this.mMinWidth : dimension.width;
        } else {
            dimension = component.getPreferredSize();
        }
        if (this.mWidthHint != -1) {
            dimension.width = this.mWidthHint;
        }
        if (this.mMinWidth != -1 && dimension.width < this.mMinWidth) {
            dimension.width = this.mMinWidth;
        }
        if (this.mHeightHint != -1) {
            dimension.height = this.mHeightHint;
        }
        if (this.mMinHeight != -1 && dimension.height < this.mMinHeight) {
            dimension.height = this.mMinHeight;
        }
        if (n != -1) {
            dimension.width = n;
        }
        if (n2 != -1) {
            dimension.height = n2;
        }
        this.mCacheWidth = dimension.width;
        this.mCacheHeight = dimension.height;
    }
}

