/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.menu;

import com.trollworks.ttk.menu.DynamicMenuEnabler;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;

public abstract class Command
extends AbstractAction
implements Comparable<Command> {
    public static final int COMMAND_MODIFIER = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    public static final int SHIFTED_COMMAND_MODIFIER = COMMAND_MODIFIER | 0x40;
    private boolean mMarked;
    private KeyStroke mOriginalAccelerator;

    public Command(String string, String string2) {
        super(string);
        this.setCommand(string2);
    }

    public Command(String string, String string2, Icon icon) {
        super(string, icon);
        this.setCommand(string2);
    }

    public Command(String string, String string2, int n) {
        super(string);
        this.setAccelerator(n);
        this.mOriginalAccelerator = this.getAccelerator();
        this.setCommand(string2);
    }

    public Command(String string, String string2, int n, int n2) {
        super(string);
        this.setAccelerator(n, n2);
        this.mOriginalAccelerator = this.getAccelerator();
        this.setCommand(string2);
    }

    public Command(String string, String string2, Icon icon, int n) {
        super(string, icon);
        this.setAccelerator(n);
        this.mOriginalAccelerator = this.getAccelerator();
        this.setCommand(string2);
    }

    public Command(String string, String string2, Icon icon, int n, int n2) {
        super(string, icon);
        this.setAccelerator(n, n2);
        this.mOriginalAccelerator = this.getAccelerator();
        this.setCommand(string2);
    }

    public Command(String string, String string2, KeyStroke keyStroke) {
        super(string);
        this.setAccelerator(keyStroke);
        this.mOriginalAccelerator = this.getAccelerator();
        this.setCommand(string2);
    }

    public Command(String string, String string2, Icon icon, KeyStroke keyStroke) {
        super(string, icon);
        this.setAccelerator(keyStroke);
        this.mOriginalAccelerator = this.getAccelerator();
        this.setCommand(string2);
    }

    public abstract void adjustForMenu(JMenuItem var1);

    @Override
    public abstract void actionPerformed(ActionEvent var1);

    public final String getTitle() {
        Object object = this.getValue("Name");
        return object != null ? object.toString() : null;
    }

    public final void setTitle(String string) {
        this.putValue("Name", string);
    }

    public final String getCommand() {
        Object object = this.getValue("ActionCommandKey");
        return object != null ? object.toString() : null;
    }

    public final void setCommand(String string) {
        this.putValue("ActionCommandKey", string);
    }

    public final KeyStroke getAccelerator() {
        Object object = this.getValue("AcceleratorKey");
        return object instanceof KeyStroke ? (KeyStroke)object : null;
    }

    public final KeyStroke getOriginalAccelerator() {
        return this.mOriginalAccelerator;
    }

    public final boolean hasOriginalAccelerator() {
        KeyStroke keyStroke = this.getAccelerator();
        return keyStroke == null ? this.mOriginalAccelerator == null : keyStroke.equals(this.mOriginalAccelerator);
    }

    public final void setAccelerator(int n) {
        this.setAccelerator(n, COMMAND_MODIFIER);
    }

    public final void setAccelerator(int n, int n2) {
        this.setAccelerator(KeyStroke.getKeyStroke(n, n2));
    }

    public final void setAccelerator(KeyStroke keyStroke) {
        DynamicMenuEnabler.remove(this);
        this.putValue("AcceleratorKey", keyStroke);
        DynamicMenuEnabler.add(this);
    }

    public final void removeAccelerator() {
        DynamicMenuEnabler.remove(this);
        this.putValue("AcceleratorKey", null);
    }

    public final boolean isMarked() {
        return this.mMarked;
    }

    public final void setMarked(boolean bl) {
        this.mMarked = bl;
    }

    public final void updateMark(JMenuItem jMenuItem) {
        if (jMenuItem instanceof JCheckBoxMenuItem || jMenuItem instanceof JRadioButtonMenuItem) {
            jMenuItem.setSelected(this.mMarked);
        }
    }

    @Override
    public int compareTo(Command command) {
        int n = this.getTitle().compareTo(command.getTitle());
        if (n == 0) {
            int n2;
            int n3 = this.hashCode();
            if (n3 > (n2 = command.hashCode())) {
                return 1;
            }
            if (n3 < n2) {
                return -1;
            }
        }
        return n;
    }

    public static final Component getFocusOwner() {
        return KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner();
    }

    public static final Window getActiveWindow() {
        return KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
    }
}

