/*
 * Decompiled with CFR 0.152.
 */
package com.trollworks.ttk.menu.edit;

import com.trollworks.ttk.menu.Command;
import com.trollworks.ttk.menu.edit.Undoable;
import com.trollworks.ttk.undo.StdUndoManager;
import com.trollworks.ttk.utility.LocalizedMessages;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.JMenuItem;

public class UndoCommand
extends Command {
    public static final String CMD_UNDO = "Undo";
    private static String MSG_UNDO;
    public static final UndoCommand INSTANCE;

    private UndoCommand() {
        super(MSG_UNDO, CMD_UNDO, 90);
    }

    @Override
    public void adjustForMenu(JMenuItem jMenuItem) {
        Window window = UndoCommand.getActiveWindow();
        if (window instanceof Undoable) {
            StdUndoManager stdUndoManager = ((Undoable)((Object)window)).getUndoManager();
            this.setEnabled(stdUndoManager.canUndo());
            this.setTitle(stdUndoManager.getUndoPresentationName());
        } else {
            this.setEnabled(false);
            this.setTitle(MSG_UNDO);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        ((Undoable)((Object)UndoCommand.getActiveWindow())).getUndoManager().undo();
    }

    static {
        LocalizedMessages.initialize(UndoCommand.class);
        INSTANCE = new UndoCommand();
    }
}

